/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.Builtins;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;
import java.io.UnsupportedEncodingException;

final class BuiltinEncode {
    private static final String hexDigits = "0123456789abcdef0123456789ABCDEF";
    private static final String decDigits = "0123456789";
    private static final byte[] safe = new byte[]{0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final HTMLEntity[] entity = new HTMLEntity[]{new HTMLEntity("AElig", '\u00c6'), new HTMLEntity("Aacute", '\u00c1'), new HTMLEntity("Acirc", '\u00c2'), new HTMLEntity("Agrave", '\u00c0'), new HTMLEntity("Alpha", '\u0391'), new HTMLEntity("Aring", '\u00c5'), new HTMLEntity("Atilde", '\u00c3'), new HTMLEntity("Auml", '\u00c4'), new HTMLEntity("Beta", '\u0392'), new HTMLEntity("Ccedil", '\u00c7'), new HTMLEntity("Chi", '\u03a7'), new HTMLEntity("Dagger", '\u2021'), new HTMLEntity("Delta", '\u0394'), new HTMLEntity("ETH", '\u00d0'), new HTMLEntity("Eacute", '\u00c9'), new HTMLEntity("Ecirc", '\u00ca'), new HTMLEntity("Egrave", '\u00c8'), new HTMLEntity("Epsilon", '\u0395'), new HTMLEntity("Eta", '\u0397'), new HTMLEntity("Euml", '\u00cb'), new HTMLEntity("Gamma", '\u0393'), new HTMLEntity("Iacute", '\u00cd'), new HTMLEntity("Icirc", '\u00ce'), new HTMLEntity("Igrave", '\u00cc'), new HTMLEntity("Iota", '\u0399'), new HTMLEntity("Iuml", '\u00cf'), new HTMLEntity("Kappa", '\u039a'), new HTMLEntity("Lambda", '\u039b'), new HTMLEntity("Mu", '\u039c'), new HTMLEntity("Ntilde", '\u00d1'), new HTMLEntity("Nu", '\u039d'), new HTMLEntity("OElig", '\u0152'), new HTMLEntity("Oacute", '\u00d3'), new HTMLEntity("Ocirc", '\u00d4'), new HTMLEntity("Ograve", '\u00d2'), new HTMLEntity("Omega", '\u03a9'), new HTMLEntity("Omicron", '\u039f'), new HTMLEntity("Oslash", '\u00d8'), new HTMLEntity("Otilde", '\u00d5'), new HTMLEntity("Ouml", '\u00d6'), new HTMLEntity("Phi", '\u03a6'), new HTMLEntity("Pi", '\u03a0'), new HTMLEntity("Prime", '\u2033'), new HTMLEntity("Psi", '\u03a8'), new HTMLEntity("Rho", '\u03a1'), new HTMLEntity("Scaron", '\u0160'), new HTMLEntity("Sigma", '\u03a3'), new HTMLEntity("THORN", '\u00de'), new HTMLEntity("Tau", '\u03a4'), new HTMLEntity("Theta", '\u0398'), new HTMLEntity("Uacute", '\u00da'), new HTMLEntity("Ucirc", '\u00db'), new HTMLEntity("Ugrave", '\u00d9'), new HTMLEntity("Upsilon", '\u03a5'), new HTMLEntity("Uuml", '\u00dc'), new HTMLEntity("Xi", '\u039e'), new HTMLEntity("Yacute", '\u00dd'), new HTMLEntity("Yuml", '\u0178'), new HTMLEntity("Zeta", '\u0396'), new HTMLEntity("aacute", '\u00e1'), new HTMLEntity("acirc", '\u00e2'), new HTMLEntity("acute", '\u00b4'), new HTMLEntity("aelig", '\u00e6'), new HTMLEntity("agrave", '\u00e0'), new HTMLEntity("alefsym", '\u2135'), new HTMLEntity("alpha", '\u03b1'), new HTMLEntity("amp", '&'), new HTMLEntity("and", '\u2227'), new HTMLEntity("ang", '\u2220'), new HTMLEntity("aring", '\u00e5'), new HTMLEntity("asymp", '\u2248'), new HTMLEntity("atilde", '\u00e3'), new HTMLEntity("auml", '\u00e4'), new HTMLEntity("bdquo", '\u201e'), new HTMLEntity("beta", '\u03b2'), new HTMLEntity("brvbar", '\u00a6'), new HTMLEntity("bull", '\u2022'), new HTMLEntity("cap", '\u2229'), new HTMLEntity("ccedil", '\u00e7'), new HTMLEntity("cedil", '\u00b8'), new HTMLEntity("cent", '\u00a2'), new HTMLEntity("chi", '\u03c7'), new HTMLEntity("circ", '\u02c6'), new HTMLEntity("clubs", '\u2663'), new HTMLEntity("cong", '\u2245'), new HTMLEntity("copy", '\u00a9'), new HTMLEntity("crarr", '\u21b5'), new HTMLEntity("cup", '\u222a'), new HTMLEntity("curren", '\u00a4'), new HTMLEntity("dArr", '\u21d3'), new HTMLEntity("dagger", '\u2020'), new HTMLEntity("darr", '\u2193'), new HTMLEntity("deg", '\u00b0'), new HTMLEntity("delta", '\u03b4'), new HTMLEntity("diams", '\u2666'), new HTMLEntity("divide", '\u00f7'), new HTMLEntity("eacute", '\u00e9'), new HTMLEntity("ecirc", '\u00ea'), new HTMLEntity("egrave", '\u00e8'), new HTMLEntity("empty", '\u2205'), new HTMLEntity("emsp", '\u2003'), new HTMLEntity("ensp", '\u2002'), new HTMLEntity("epsilon", '\u03b5'), new HTMLEntity("equiv", '\u2261'), new HTMLEntity("eta", '\u03b7'), new HTMLEntity("eth", '\u00f0'), new HTMLEntity("euml", '\u00eb'), new HTMLEntity("euro", '\u20ac'), new HTMLEntity("exist", '\u2203'), new HTMLEntity("fnof", '\u0192'), new HTMLEntity("forall", '\u2200'), new HTMLEntity("frac12", '\u00bd'), new HTMLEntity("frac14", '\u00bc'), new HTMLEntity("frac34", '\u00be'), new HTMLEntity("frasl", '\u2044'), new HTMLEntity("gamma", '\u03b3'), new HTMLEntity("ge", '\u2265'), new HTMLEntity("gt", '>'), new HTMLEntity("hArr", '\u21d4'), new HTMLEntity("harr", '\u2194'), new HTMLEntity("hearts", '\u2665'), new HTMLEntity("hellip", '\u2026'), new HTMLEntity("iacute", '\u00ed'), new HTMLEntity("icirc", '\u00ee'), new HTMLEntity("iexcl", '\u00a1'), new HTMLEntity("igrave", '\u00ec'), new HTMLEntity("image", '\u2111'), new HTMLEntity("infin", '\u221e'), new HTMLEntity("int", '\u222b'), new HTMLEntity("iota", '\u03b9'), new HTMLEntity("iquest", '\u00bf'), new HTMLEntity("isin", '\u2208'), new HTMLEntity("iuml", '\u00ef'), new HTMLEntity("kappa", '\u03ba'), new HTMLEntity("lArr", '\u21d0'), new HTMLEntity("lambda", '\u03bb'), new HTMLEntity("lang", '\u2329'), new HTMLEntity("laquo", '\u00ab'), new HTMLEntity("larr", '\u2190'), new HTMLEntity("lceil", '\u2308'), new HTMLEntity("ldquo", '\u201c'), new HTMLEntity("le", '\u2264'), new HTMLEntity("lfloor", '\u230a'), new HTMLEntity("lowast", '\u2217'), new HTMLEntity("loz", '\u25ca'), new HTMLEntity("lrm", '\u200e'), new HTMLEntity("lsaquo", '\u2039'), new HTMLEntity("lsquo", '\u2018'), new HTMLEntity("lt", '<'), new HTMLEntity("macr", '\u00af'), new HTMLEntity("mdash", '\u2014'), new HTMLEntity("micro", '\u00b5'), new HTMLEntity("middot", '\u00b7'), new HTMLEntity("minus", '\u2212'), new HTMLEntity("mu", '\u03bc'), new HTMLEntity("nabla", '\u2207'), new HTMLEntity("nbsp", '\u00a0'), new HTMLEntity("ndash", '\u2013'), new HTMLEntity("ne", '\u2260'), new HTMLEntity("ni", '\u220b'), new HTMLEntity("not", '\u00ac'), new HTMLEntity("notin", '\u2209'), new HTMLEntity("nsub", '\u2284'), new HTMLEntity("ntilde", '\u00f1'), new HTMLEntity("nu", '\u03bd'), new HTMLEntity("oacute", '\u00f3'), new HTMLEntity("ocirc", '\u00f4'), new HTMLEntity("oelig", '\u0153'), new HTMLEntity("ograve", '\u00f2'), new HTMLEntity("oline", '\u203e'), new HTMLEntity("omega", '\u03c9'), new HTMLEntity("omicron", '\u03bf'), new HTMLEntity("oplus", '\u2295'), new HTMLEntity("or", '\u2228'), new HTMLEntity("ordf", '\u00aa'), new HTMLEntity("ordm", '\u00ba'), new HTMLEntity("oslash", '\u00f8'), new HTMLEntity("otilde", '\u00f5'), new HTMLEntity("otimes", '\u2297'), new HTMLEntity("ouml", '\u00f6'), new HTMLEntity("para", '\u00b6'), new HTMLEntity("part", '\u2202'), new HTMLEntity("permil", '\u2030'), new HTMLEntity("perp", '\u22a5'), new HTMLEntity("phi", '\u03c6'), new HTMLEntity("pi", '\u03c0'), new HTMLEntity("piv", '\u03d6'), new HTMLEntity("plusmn", '\u00b1'), new HTMLEntity("pound", '\u00a3'), new HTMLEntity("prime", '\u2032'), new HTMLEntity("prod", '\u220f'), new HTMLEntity("prop", '\u221d'), new HTMLEntity("psi", '\u03c8'), new HTMLEntity("quot", '\"'), new HTMLEntity("rArr", '\u21d2'), new HTMLEntity("radic", '\u221a'), new HTMLEntity("rang", '\u232a'), new HTMLEntity("raquo", '\u00bb'), new HTMLEntity("rarr", '\u2192'), new HTMLEntity("rceil", '\u2309'), new HTMLEntity("rdquo", '\u201d'), new HTMLEntity("real", '\u211c'), new HTMLEntity("reg", '\u00ae'), new HTMLEntity("rfloor", '\u230b'), new HTMLEntity("rho", '\u03c1'), new HTMLEntity("rlm", '\u200f'), new HTMLEntity("rsaquo", '\u203a'), new HTMLEntity("rsquo", '\u2019'), new HTMLEntity("sbquo", '\u201a'), new HTMLEntity("scaron", '\u0161'), new HTMLEntity("sdot", '\u22c5'), new HTMLEntity("sect", '\u00a7'), new HTMLEntity("shy", '\u00ad'), new HTMLEntity("sigma", '\u03c3'), new HTMLEntity("sigmaf", '\u03c2'), new HTMLEntity("sim", '\u223c'), new HTMLEntity("spades", '\u2660'), new HTMLEntity("sub", '\u2282'), new HTMLEntity("sube", '\u2286'), new HTMLEntity("sum", '\u2211'), new HTMLEntity("sup", '\u2283'), new HTMLEntity("sup1", '\u00b9'), new HTMLEntity("sup2", '\u00b2'), new HTMLEntity("sup3", '\u00b3'), new HTMLEntity("supe", '\u2287'), new HTMLEntity("szlig", '\u00df'), new HTMLEntity("tau", '\u03c4'), new HTMLEntity("there4", '\u2234'), new HTMLEntity("theta", '\u03b8'), new HTMLEntity("thetasym", '\u03d1'), new HTMLEntity("thinsp", '\u2009'), new HTMLEntity("thorn", '\u00fe'), new HTMLEntity("tilde", '\u02dc'), new HTMLEntity("times", '\u00d7'), new HTMLEntity("trade", '\u2122'), new HTMLEntity("uArr", '\u21d1'), new HTMLEntity("uacute", '\u00fa'), new HTMLEntity("uarr", '\u2191'), new HTMLEntity("ucirc", '\u00fb'), new HTMLEntity("ugrave", '\u00f9'), new HTMLEntity("uml", '\u00a8'), new HTMLEntity("upsih", '\u03d2'), new HTMLEntity("upsilon", '\u03c5'), new HTMLEntity("uuml", '\u00fc'), new HTMLEntity("weierp", '\u2118'), new HTMLEntity("xi", '\u03be'), new HTMLEntity("yacute", '\u00fd'), new HTMLEntity("yen", '\u00a5'), new HTMLEntity("yuml", '\u00ff'), new HTMLEntity("zeta", '\u03b6'), new HTMLEntity("zwj", '\u200d'), new HTMLEntity("zwnj", '\u200c')};

    private BuiltinEncode() {
    }

    private static String urlEncode(String src, boolean bLegacyScripting) {
        byte[] srcBuf;
        block7: {
            srcBuf = new byte[]{};
            if (!bLegacyScripting) {
                try {
                    srcBuf = src.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError();
                }
            }
        }
        int n = bLegacyScripting ? src.length() : srcBuf.length;
        int needs_encoding = 0;
        for (int i = 0; i < n; ++i) {
            char chr;
            char c = chr = bLegacyScripting ? src.charAt(i) : srcBuf[i];
            if (chr >= ' ' && '\u007f' >= chr && safe[chr - 32] != 0) continue;
            ++needs_encoding;
        }
        if (needs_encoding == 0) {
            return src;
        }
        StringBuilder dst = new StringBuilder(src.length() + needs_encoding * 2);
        for (int i = 0; i < n; ++i) {
            char chr;
            char c = chr = bLegacyScripting ? src.charAt(i) : srcBuf[i];
            if (chr < ' ' || '\u007f' < chr || safe[chr - 32] == 0) {
                dst.append('%');
                dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                dst.append(hexDigits.charAt(chr & 0xF));
                continue;
            }
            dst.append(chr);
        }
        return dst.toString();
    }

    private static String htmlEncode(String src) {
        int needs_encoding = 0;
        int n = src.length();
        for (int i = 0; i < n; ++i) {
            char chr = src.charAt(i);
            if (chr == '<' || chr == '>' || chr == '&' || chr == '\"') {
                ++needs_encoding;
                continue;
            }
            if (chr <= '\u007f') continue;
            ++needs_encoding;
        }
        if (needs_encoding == 0) {
            return src;
        }
        StringBuilder dst = new StringBuilder(src.length() + needs_encoding * 10);
        int i = 0;
        int n2 = src.length();
        while (i < n2) {
            int chr;
            i += (chr = src.codePointAt(i)) <= 65535 ? 1 : 2;
            if (chr == 60) {
                dst.append("&lt;");
                continue;
            }
            if (chr == 62) {
                dst.append("&gt;");
                continue;
            }
            if (chr == 38) {
                dst.append("&amp;");
                continue;
            }
            if (chr == 34) {
                dst.append("&quot;");
                continue;
            }
            if (chr > 127) {
                dst.append("&#x");
                if ((chr & 0xF00000) != 0) {
                    dst.append(hexDigits.charAt(chr >> 20 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 16 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 12 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 8 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                    dst.append(hexDigits.charAt(chr & 0xF));
                } else if ((chr & 0xF0000) != 0) {
                    dst.append(hexDigits.charAt(chr >> 16 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 12 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 8 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                    dst.append(hexDigits.charAt(chr & 0xF));
                } else if ((chr & 0xF000) != 0) {
                    dst.append(hexDigits.charAt(chr >> 12 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 8 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                    dst.append(hexDigits.charAt(chr & 0xF));
                } else if ((chr & 0xF00) != 0) {
                    dst.append(hexDigits.charAt(chr >> 8 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                    dst.append(hexDigits.charAt(chr & 0xF));
                } else if ((chr & 0xF0) != 0) {
                    dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                    dst.append(hexDigits.charAt(chr & 0xF));
                } else {
                    dst.append(hexDigits.charAt(chr & 0xF));
                }
                dst.append(';');
                continue;
            }
            dst.append((char)chr);
        }
        return dst.toString();
    }

    private static String xmlEncode(String src) {
        int needs_encoding = 0;
        int n = src.length();
        for (int i = 0; i < n; ++i) {
            char chr = src.charAt(i);
            if (chr == '<' || chr == '>' || chr == '&' || chr == '\'' || chr == '\"') {
                ++needs_encoding;
                continue;
            }
            if (chr <= '\u007f') continue;
            ++needs_encoding;
        }
        if (needs_encoding == 0) {
            return src;
        }
        StringBuilder dst = new StringBuilder(src.length() + needs_encoding * 10);
        int i = 0;
        int n2 = src.length();
        while (i < n2) {
            int chr;
            i += (chr = src.codePointAt(i)) <= 65535 ? 1 : 2;
            if (chr == 60) {
                dst.append("&lt;");
                continue;
            }
            if (chr == 62) {
                dst.append("&gt;");
                continue;
            }
            if (chr == 38) {
                dst.append("&amp;");
                continue;
            }
            if (chr == 39) {
                dst.append("&apos;");
                continue;
            }
            if (chr == 34) {
                dst.append("&quot;");
                continue;
            }
            if (chr > 127) {
                dst.append("&#x");
                if ((chr & 0xF00000) != 0) {
                    dst.append(hexDigits.charAt(chr >> 20 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 16 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 12 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 8 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                    dst.append(hexDigits.charAt(chr & 0xF));
                } else if ((chr & 0xF0000) != 0) {
                    dst.append(hexDigits.charAt(chr >> 16 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 12 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 8 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                    dst.append(hexDigits.charAt(chr & 0xF));
                } else if ((chr & 0xF000) != 0) {
                    dst.append(hexDigits.charAt(chr >> 12 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 8 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                    dst.append(hexDigits.charAt(chr & 0xF));
                } else if ((chr & 0xF00) != 0) {
                    dst.append(hexDigits.charAt(chr >> 8 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                    dst.append(hexDigits.charAt(chr & 0xF));
                } else if ((chr & 0xF0) != 0) {
                    dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                    dst.append(hexDigits.charAt(chr & 0xF));
                } else {
                    dst.append(hexDigits.charAt(chr & 0xF));
                }
                dst.append(';');
                continue;
            }
            dst.append((char)chr);
        }
        return dst.toString();
    }

    private static String urlDecode(String src) {
        StringBuilder dst = new StringBuilder(src.length());
        boolean needsDecoding = false;
        int n = src.length();
        for (int i = 0; i < n; ++i) {
            int chr = src.charAt(i);
            if (chr == 43) {
                dst.append(' ');
                needsDecoding = true;
                continue;
            }
            if (chr == 37) {
                if (i + 1 < n) {
                    chr = 48 <= (chr = src.charAt(++i)) && chr <= 57 ? (chr -= 48) : (65 <= chr && chr <= 70 ? (chr -= 55) : (chr -= 87));
                    int hex = chr * 16;
                    if (i + 1 < n) {
                        chr = 48 <= (chr = (int)src.charAt(++i)) && chr <= 57 ? (chr -= 48) : (65 <= chr && chr <= 70 ? (chr -= 55) : (chr -= 87));
                        dst.append((char)(hex += chr));
                    }
                }
                needsDecoding = true;
                continue;
            }
            dst.append((char)chr);
        }
        return needsDecoding ? dst.toString() : src;
    }

    private static String htmlDecode(String src) {
        assert (src != null);
        int n = src.length();
        StringBuilder dst = new StringBuilder(n);
        boolean needsDecoding = false;
        for (int s = 0; s < n; ++s) {
            int p;
            if (src.charAt(s) == '&' && (p = src.indexOf(59, s++)) >= 0) {
                String ent = src.substring(s, p);
                int lo = 0;
                int hi = entity.length - 1;
                while (lo <= hi) {
                    int mid = lo + hi >>> 1;
                    int cmp = ent.compareTo(BuiltinEncode.entity[mid].name);
                    if (cmp == 0) {
                        dst.append(BuiltinEncode.entity[mid].value);
                        break;
                    }
                    if (cmp < 0) {
                        hi = mid - 1;
                        continue;
                    }
                    lo = mid + 1;
                }
                if (src.charAt(s++) == '#') {
                    int q;
                    int d = 0;
                    if (src.charAt(s) == 'x' || src.charAt(s) == 'X') {
                        ++s;
                        while ((q = hexDigits.indexOf(src.charAt(s))) >= 0) {
                            d = d * 16 + (q & 0xF);
                            ++s;
                        }
                    } else {
                        while ((q = decDigits.indexOf(src.charAt(s))) >= 0) {
                            d = d * 10 + q;
                            ++s;
                        }
                    }
                    if (src.charAt(s) == ';') {
                        if (d > 65535) {
                            dst.append((char)((d -= 65536) >> 10 | 0xD800));
                            dst.append((char)(d & 0x3FF | 0xDC00));
                        } else {
                            dst.append((char)d);
                        }
                    }
                }
                s = p;
                needsDecoding = true;
                continue;
            }
            dst.append(src.charAt(s));
        }
        return needsDecoding ? dst.toString() : src;
    }

    private static String xmlDecode(String src) {
        assert (src != null);
        int n = src.length();
        StringBuilder dst = new StringBuilder(n);
        boolean needsDecoding = false;
        for (int s = 0; s < n; ++s) {
            int p;
            if (src.charAt(s) == '&' && (p = src.indexOf(59, s++)) >= 0) {
                String ent = src.substring(s, p);
                if (ent.equals("lt")) {
                    dst.append('<');
                } else if (ent.equals("gt")) {
                    dst.append('>');
                } else if (ent.equals("amp")) {
                    dst.append('&');
                } else if (ent.equals("apos")) {
                    dst.append('\'');
                } else if (ent.equals("quot")) {
                    dst.append('\"');
                } else if (src.charAt(s++) == '#') {
                    int q;
                    int d = 0;
                    if (src.charAt(s) == 'x' || src.charAt(s) == 'X') {
                        ++s;
                        while ((q = hexDigits.indexOf(src.charAt(s))) >= 0) {
                            d = d * 16 + (q & 0xF);
                            ++s;
                        }
                    } else {
                        while ((q = decDigits.indexOf(src.charAt(s))) >= 0) {
                            d = d * 10 + q;
                            ++s;
                        }
                    }
                    if (src.charAt(s) == ';') {
                        if (d > 65535) {
                            dst.append((char)((d -= 65536) >> 10 | 0xD800));
                            dst.append((char)(d & 0x3FF | 0xDC00));
                        } else {
                            dst.append((char)d);
                        }
                    }
                }
                s = p;
                needsDecoding = true;
                continue;
            }
            dst.append(src.charAt(s));
        }
        return needsDecoding ? dst.toString() : src;
    }

    private static String javaEncode(String src, boolean bLegacyScripting) {
        int needs_encoding = src.length();
        StringBuilder dst = new StringBuilder(needs_encoding * 10);
        int i = 0;
        int n = src.length();
        while (i < n) {
            int chr;
            i += (chr = src.codePointAt(i)) <= 65535 ? 1 : 2;
            if (bLegacyScripting) {
                if (chr > 65535) {
                    dst.append("\\U");
                } else {
                    dst.append("\\u");
                }
                if ((chr & 0xF00000) != 0) {
                    dst.append('0');
                    dst.append('0');
                    dst.append(hexDigits.charAt(chr >> 20 & 0xF));
                    dst.append(hexDigits.charAt(chr >> 16 & 0xF));
                } else if ((chr & 0xF0000) != 0) {
                    dst.append('0');
                    dst.append('0');
                    dst.append('0');
                    dst.append(hexDigits.charAt(chr >> 16 & 0xF));
                }
            } else if (chr > 65535) {
                int hs = (chr -= 65536) >> 10 | 0xD800;
                dst.append("\\u");
                dst.append(hexDigits.charAt(hs >> 12 & 0xF));
                dst.append(hexDigits.charAt(hs >> 8 & 0xF));
                dst.append(hexDigits.charAt(hs >> 4 & 0xF));
                dst.append(hexDigits.charAt(hs & 0xF));
                dst.append("\\u");
                chr = chr & 0x3FF | 0xDC00;
            }
            if ((chr & 0xF000) != 0) {
                dst.append(hexDigits.charAt(chr >> 12 & 0xF));
                dst.append(hexDigits.charAt(chr >> 8 & 0xF));
                dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                dst.append(hexDigits.charAt(chr & 0xF));
                continue;
            }
            if ((chr & 0xF00) != 0) {
                dst.append('0');
                dst.append(hexDigits.charAt(chr >> 8 & 0xF));
                dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                dst.append(hexDigits.charAt(chr & 0xF));
                continue;
            }
            if ((chr & 0xF0) != 0) {
                dst.append('0');
                dst.append('0');
                dst.append(hexDigits.charAt(chr >> 4 & 0xF));
                dst.append(hexDigits.charAt(chr & 0xF));
                continue;
            }
            dst.append('0');
            dst.append('0');
            dst.append('0');
            dst.append(hexDigits.charAt(chr & 0xF));
        }
        return dst.toString();
    }

    private static String javaDecode(String src, boolean bLegacyScripting) {
        assert (src != null);
        int n = src.length();
        StringBuilder dst = new StringBuilder(n);
        boolean needsDecoding = false;
        for (int s = 0; s < n; ++s) {
            if (src.charAt(s) == '\\') {
                int q;
                int i;
                int d = 0;
                if (src.charAt(++s) == 'u') {
                    ++s;
                    i = 0;
                    while ((q = hexDigits.indexOf(src.charAt(s))) >= 0) {
                        d = d * 16 + (q & 0xF);
                        if (++i == 4) break;
                        ++s;
                    }
                    if (i != 4) {
                        d = 0;
                    }
                } else if (bLegacyScripting && src.charAt(s) == 'U') {
                    ++s;
                    i = 0;
                    while ((q = hexDigits.indexOf(src.charAt(s))) >= 0) {
                        d = d * 16 + (q & 0xF);
                        if (++i == 8) break;
                        ++s;
                    }
                    if (i != 8) {
                        d = 0;
                    }
                    if (d > 65535) {
                        dst.append((char)((d -= 65536) >> 10 | 0xD800));
                        d = d & 0x3FF | 0xDC00;
                    }
                }
                if (d > 0) {
                    dst.append((char)d);
                }
                needsDecoding = true;
                continue;
            }
            dst.append(src.charAt(s));
        }
        if (!bLegacyScripting) {
            // empty if block
        }
        return needsDecoding ? dst.toString() : src;
    }

    static void Encode(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String sStr = oParser.getString(oArgSym[0]);
                String sEnc = oParser.getString(oArgSym[1]);
                String sEncoded = sEnc.equalsIgnoreCase("html") ? BuiltinEncode.htmlEncode(sStr) : (sEnc.equalsIgnoreCase("xml") ? BuiltinEncode.xmlEncode(sStr) : (sEnc.equalsIgnoreCase("javascript") ? BuiltinEncode.javaEncode(sStr, oParser.moLegacyScripting.contains((Object)CalcParser.LegacyVersion.V30_SCRIPTING)) : BuiltinEncode.urlEncode(sStr, oParser.moLegacyScripting.contains((Object)CalcParser.LegacyVersion.V30_SCRIPTING))));
                oRetSym = new CalcSymbol(sEncoded);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    static void Decode(CalcParser oParser, CalcSymbol[] oArgSym) {
        CalcSymbol oRetSym;
        block2: {
            int nArgs = oArgSym.length;
            oRetSym = null;
            try {
                Builtins.minArgs(nArgs, 2);
                Builtins.maxArgs(nArgs, 2);
                Builtins.limitExceptionArgs(oArgSym);
                Builtins.limitNullArgs(oParser, nArgs, oArgSym);
                String sStr = oParser.getString(oArgSym[0]);
                String sEnc = oParser.getString(oArgSym[1]);
                String sDecoded = sEnc.equalsIgnoreCase("html") ? BuiltinEncode.htmlDecode(sStr) : (sEnc.equalsIgnoreCase("xml") ? BuiltinEncode.xmlDecode(sStr) : (sEnc.equalsIgnoreCase("javascript") ? BuiltinEncode.javaDecode(sStr, oParser.moLegacyScripting.contains((Object)CalcParser.LegacyVersion.V30_SCRIPTING)) : BuiltinEncode.urlDecode(sStr)));
                oRetSym = new CalcSymbol(sDecoded);
            }
            catch (CalcException e) {
                oRetSym = e.getSymbol();
                if (oRetSym.getType() == 1) break block2;
                oParser.mbInThrow = true;
            }
        }
        oParser.mStack.push(oRetSym);
    }

    private static class HTMLEntity {
        String name;
        char value;

        HTMLEntity(String n, char v) {
            this.name = n;
            this.value = v;
        }
    }
}

