/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Apply Metadata Template"})
public class ApplyMetadataTemplateProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(ApplyMetadataTemplateProcess.class);
    private static final String JCR_CONTENT_METADATA = "jcr:content/metadata";

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        block13: {
            try {
                Session session = workflowSession.getSession();
                Asset asset = this.getAssetFromPayload(workItem, session);
                if (null != asset) {
                    Node assetNode;
                    Node node = assetNode = asset.adaptTo(Node.class);
                    boolean metadataTemplatePresent = false;
                    while (!node.getPath().equals("/content") && !metadataTemplatePresent) {
                        Node assetMetadataNode;
                        if ((node = node.getParent()).getPrimaryNodeType().getName().equals("dam:Asset") || !node.hasNode(JCR_CONTENT_METADATA)) continue;
                        metadataTemplatePresent = true;
                        Node folderMetadataNode = node.getNode(JCR_CONTENT_METADATA);
                        if (!assetNode.hasNode(JCR_CONTENT_METADATA)) {
                            Node _jcr_content = !assetNode.hasNode("jcr:content") ? assetNode.addNode("jcr:content", "nt:unstructured") : assetNode.getNode("jcr:content");
                            assetMetadataNode = _jcr_content.addNode("metadata", "nt:unstructured");
                        } else {
                            assetMetadataNode = assetNode.getNode(JCR_CONTENT_METADATA);
                        }
                        PropertyIterator dpi = folderMetadataNode.getProperties();
                        while (dpi.hasNext()) {
                            javax.jcr.Property p = dpi.nextProperty();
                            if (p.getName().startsWith("jcr:")) continue;
                            if (assetMetadataNode.hasProperty(p.getName())) {
                                ArrayList<Value> updatedVals;
                                Value[] vals;
                                javax.jcr.Property prop = assetMetadataNode.getProperty(p.getName());
                                if (p.isMultiple() && prop.isMultiple()) {
                                    vals = prop.getValues();
                                    updatedVals = new ArrayList<Value>();
                                    updatedVals.addAll(Arrays.asList(vals));
                                    for (Value val : p.getValues()) {
                                        if (updatedVals.contains(val)) continue;
                                        updatedVals.add(val);
                                    }
                                    assetMetadataNode.setProperty(prop.getName(), updatedVals.toArray(new Value[updatedVals.size()]), prop.getType());
                                    continue;
                                }
                                if (!p.isMultiple() && prop.isMultiple()) {
                                    vals = prop.getValues();
                                    updatedVals = new ArrayList();
                                    updatedVals.addAll(Arrays.asList(vals));
                                    if (!updatedVals.contains(p.getValue())) {
                                        updatedVals.add(p.getValue());
                                    }
                                    assetMetadataNode.setProperty(prop.getName(), updatedVals.toArray(new Value[updatedVals.size()]), prop.getType());
                                    continue;
                                }
                                if (p.isMultiple() || prop.isMultiple()) continue;
                                assetMetadataNode.setProperty(p.getName(), p.getValue());
                                continue;
                            }
                            if (!p.isMultiple()) {
                                assetMetadataNode.setProperty(p.getName(), p.getValue());
                                continue;
                            }
                            assetMetadataNode.setProperty(p.getName(), p.getValues(), p.getType());
                        }
                    }
                    break block13;
                }
                String wfPayload = workItem.getWorkflowData().getPayload().toString();
                String message = "execute: cannot apply metadata template, asset [{" + wfPayload + "}] in payload doesn't exist for workflow [{" + workItem.getId() + "}].";
                throw new WorkflowException(message);
            }
            catch (Exception e) {
                log.warn("unexpected error occurred during metadata extraction. Cause: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

