/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.adobe.granite.offloading.api.OffloadingJobProperties;
import com.adobe.granite.offloading.workflow.api.WorkflowOffloadingHelper;
import com.adobe.granite.offloading.workflow.api.WorkflowOffloadingProcessArguments;
import com.adobe.granite.offloading.workflow.api.WorkflowOffloadingProperties;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowExternalProcess;
import com.adobe.granite.workflow.metadata.MetaDataMap;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class AssetOffloadingProcess
implements WorkflowExternalProcess {
    private static final String TYPE_JCR_PATH = "JCR_PATH";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private JobManager jobManager;

    @Override
    public Serializable execute(WorkItem item, WorkflowSession wfSession, MetaDataMap arguments) throws WorkflowException {
        String[] includeMimeTypes = (String[])arguments.get(Arguments.INCLUDE_MIME_TYPES.name(), String[].class);
        Asset asset = this.getAsset(item, wfSession, arguments);
        if (!this.doProcess(asset, includeMimeTypes)) {
            this.log.debug("Skipping for asset " + asset.getPath());
            return null;
        }
        if (asset != null) {
            String jobTopic;
            ValueMap jobProperties = this.getAllJobProperties(asset, item, arguments);
            String userId = this.getUserId(wfSession, item);
            if (userId != null) {
                jobProperties.put("userId", userId);
            }
            if (StringUtils.isEmpty(jobTopic = WorkflowOffloadingHelper.getJobTopic(arguments))) {
                throw new WorkflowException("job topic must not be empty");
            }
            Job offloadingJob = this.jobManager.addJob(jobTopic, jobProperties);
            if (offloadingJob == null) {
                throw new WorkflowException("not able to create job");
            }
            return offloadingJob.getId();
        }
        throw new WorkflowException("Can not execute step. Not a path based workflow payload");
    }

    @Override
    public boolean hasFinished(Serializable externalProcessId, WorkItem item, WorkflowSession session, MetaDataMap arguments) {
        Job offloadingJob = this.jobManager.getJobById((String)((Object)externalProcessId));
        boolean hasFinished = false;
        if (offloadingJob != null) {
            Job.JobState jobState = offloadingJob.getJobState();
            switch (jobState) {
                case ACTIVE: 
                case QUEUED: {
                    hasFinished = false;
                    break;
                }
                case SUCCEEDED: 
                case STOPPED: 
                case GIVEN_UP: 
                case ERROR: 
                case DROPPED: {
                    hasFinished = true;
                    break;
                }
                default: {
                    this.log.warn("Unrecognized job status '{}' for job {}", (Object)jobState, (Object)offloadingJob.getId());
                    hasFinished = false;
                }
            }
            this.log.debug("hasFinished = '{}', jobState = '{}' for job {}", new Object[]{hasFinished, jobState, offloadingJob.getId()});
        } else {
            hasFinished = true;
        }
        return hasFinished;
    }

    @Override
    public void handleResult(Serializable externalProcessId, WorkItem workItem, WorkflowSession session, MetaDataMap arguments) throws WorkflowException {
    }

    protected Asset getAsset(WorkItem item, WorkflowSession wfSession, MetaDataMap arguments) {
        ResourceResolver resolver;
        Resource resource;
        Asset asset = null;
        String payload = (String)((Object)arguments.get(WorkflowOffloadingProcessArguments.WORKFLOW_PAYLOAD.getArgumentName(), String.class));
        if (StringUtils.isBlank(payload) && item.getWorkflowData().getPayloadType().equals(TYPE_JCR_PATH)) {
            payload = item.getWorkflowData().getPayload().toString();
        }
        if (null != (resource = (resolver = wfSession.adaptTo(ResourceResolver.class)).getResource(payload))) {
            asset = DamUtil.resolveToAsset(resource);
        } else {
            this.log.error("getAsset: asset [{}] in payload of workflow [{}] does not exist.", (Object)payload, (Object)item.getWorkflow().getId());
        }
        return asset;
    }

    private String getUserId(WorkflowSession workflowSession, WorkItem workItem) {
        Object userId = workItem.getWorkflow().getWorkflowData().getMetaDataMap().get("userId");
        return userId != null ? userId.toString() : null;
    }

    private ValueMap getAllJobProperties(Asset asset, WorkItem item, MetaDataMap arguments) throws WorkflowException {
        ValueMapDecorator allJobProperties = new ValueMapDecorator(new HashMap<String, Object>());
        String workflowModel = WorkflowOffloadingHelper.getWorkflowModel(arguments);
        if (StringUtils.isEmpty(workflowModel)) {
            throw new WorkflowException("No workflow model specified, cannot execute workflow.");
        }
        String workflowPayload = asset.getOriginal().getPath();
        allJobProperties.put(WorkflowOffloadingProperties.OFFLOADING_WORKFLOW_MODEL.getPropertyName(), workflowModel);
        allJobProperties.put(WorkflowOffloadingProperties.OFFLOADING_WORKFLOW_PAYLOAD.getPropertyName(), workflowPayload);
        allJobProperties.putAll(WorkflowOffloadingHelper.getJobProperties(arguments));
        String workflowOffloadingInput = WorkflowOffloadingHelper.getWorkflowOffloadingInput(arguments, asset.getPath(), workflowModel);
        allJobProperties.put(OffloadingJobProperties.INPUT_PAYLOAD.propertyName(), workflowOffloadingInput);
        String workflowOffloadingOutput = WorkflowOffloadingHelper.getWorkflowOffloadingOutput(arguments, asset.getPath(), workflowModel);
        allJobProperties.put(OffloadingJobProperties.OUTPUT_PAYLOAD.propertyName(), workflowOffloadingOutput);
        return allJobProperties;
    }

    private boolean doProcess(Asset asset, String[] includeMimeTypes) {
        if (asset == null) {
            return false;
        }
        if (includeMimeTypes == null) {
            return true;
        }
        String mimeType = asset.getMimeType();
        for (int i = 0; i < includeMimeTypes.length; ++i) {
            if (!includeMimeTypes[i].equalsIgnoreCase(mimeType) && !includeMimeTypes[i].equals("*")) continue;
            return true;
        }
        return false;
    }

    protected void bindJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void unbindJobManager(JobManager jobManager) {
        if (this.jobManager == jobManager) {
            this.jobManager = null;
        }
    }

    public static enum Arguments {
        INCLUDE_MIME_TYPES;

    }
}

