/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.core.process;

import com.day.cq.commons.Externalizer;
import com.day.cq.dam.api.jobs.AssetDownloadService;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Properties(value={@Property(name="service.description", value={"Download selected asset(s)."}), @Property(name="process.label", value={"Download Dam Asset"})})
public class DownloadAssetProcess
extends AbstractAssetWorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(DownloadAssetProcess.class);
    private static final String DOWNLOADASSETS = "downloadAssets";
    private static final String DOWNLOADRENDITIONS = "downloadRenditions";
    private static final String DOWNLOADSUBASSETS = "downloadSubassets";
    private static final String FLATSTRUCTURE = "flatStructure";
    private static final String S7EXPORTSETTINGS = "s7exportsettings";
    private static final String EMAILTO = "emailTo";
    private static final String CONTEXTPATH = "contextPath";
    private static final String SERVICE_USER_ID = "assetidhelper";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    public AssetDownloadService assetDownloadService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    public Externalizer externalizer;
    @Reference
    public SlingRepository slingRepository;

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        try {
            int idx;
            Session session = workflowSession.getSession();
            ResourceResolver rr = this.getResourceResolver(session);
            String payload = workItem.getWorkflowData().getPayload().toString();
            String srcPath = payload.split(".assetdownload.zip")[0];
            MetaDataMap wfMetaDataMap = workItem.getWorkflowData().getMetaDataMap();
            String contextPath = wfMetaDataMap.get(CONTEXTPATH, new String());
            Resource resource = rr.getResource(srcPath.substring(contextPath.length()));
            boolean downloadAssets = Boolean.parseBoolean(this.getValueFromPayload(DOWNLOADASSETS, payload));
            boolean downloadRenditions = Boolean.parseBoolean(this.getValueFromPayload(DOWNLOADRENDITIONS, payload));
            boolean downloadSubassets = Boolean.parseBoolean(this.getValueFromPayload(DOWNLOADSUBASSETS, payload));
            String s7exportsettings = this.getValueFromPayload(S7EXPORTSETTINGS, payload);
            if (StringUtils.isNotBlank(s7exportsettings)) {
                s7exportsettings = URLDecoder.decode(s7exportsettings, "UTF-8");
            }
            String downloadName = (idx = payload.indexOf("?")) == -1 ? "" : payload.substring(0, idx);
            downloadName = this.getDownloadName(downloadName);
            ArrayList<String> paths = this.getAssetPath(payload);
            HashSet<Resource> downloadSet = new HashSet<Resource>();
            if (paths != null && !paths.isEmpty()) {
                for (String path : paths) {
                    Resource res = rr.getResource(path);
                    if (res == null) continue;
                    downloadSet.add(res);
                }
            } else {
                downloadSet.add(resource);
            }
            String emailRecipients = wfMetaDataMap.get(EMAILTO, new String());
            boolean flatStructure = Boolean.parseBoolean(this.getValueFromPayload(FLATSTRUCTURE, payload));
            String downloadUrl = this.assetDownloadService.assetDownload(new AssetDownloadService.AssetDownloadParams(resource, downloadSet, downloadAssets, downloadRenditions, downloadSubassets, s7exportsettings, null, downloadName, emailRecipients, flatStructure, null, null));
            if (!StringUtils.isEmpty(downloadUrl)) {
                downloadUrl = this.getHostPrefix(workItem, rr, resource.getPath()) + downloadUrl;
                wfMetaDataMap.put("downloadUrl", downloadUrl);
            } else {
                log.debug("downloadUrl is null or empty.");
            }
        }
        catch (Exception e) {
            log.error("execute: error while processing download asset; work item [{}]: ", (Object)workItem.getId(), (Object)e);
        }
    }

    private ArrayList<String> getAssetPath(String arg) {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            int beginIdx = arg.indexOf("path=");
            while (beginIdx != -1) {
                int endIdx = arg.indexOf("&", beginIdx + 1);
                endIdx = endIdx == -1 ? arg.length() : endIdx;
                String path = arg.substring(beginIdx + "path+".length(), endIdx);
                paths.add(URLDecoder.decode(path, "UTF-8"));
                beginIdx = arg.indexOf("path=", endIdx + 1);
            }
        }
        catch (Exception e) {
            log.error("unable to parse asset paths for download: " + arg, e);
        }
        return paths;
    }

    private String getValueFromPayload(String key, String argment) {
        String value = null;
        int beginIdx = argment.indexOf(key);
        if (beginIdx != -1 && this.validKeyParameter(key, argment.substring(beginIdx - 1, beginIdx + key.length() + 1))) {
            int endIdx = argment.indexOf("&", beginIdx);
            endIdx = endIdx == -1 ? argment.length() : endIdx;
            value = beginIdx == -1 ? "" : argment.substring(beginIdx + (key + "=").length(), endIdx);
        }
        return value;
    }

    private boolean validKeyParameter(String key, String argment) {
        boolean valid = false;
        List<String> params = Arrays.asList(argment.split("&|\\?|="));
        for (String param : params) {
            if (param.length() == 0) continue;
            valid = param.equals(key);
        }
        return valid;
    }

    private String getDownloadName(String pathInfo) {
        String name = pathInfo.substring(pathInfo.lastIndexOf("/") + 1, pathInfo.length());
        name = (name = name.replaceAll("[\\[\\]\\/ :*|'\"S]", "")).endsWith(".zip") ? name : name + ".zip";
        return name;
    }

    private String getHostPrefix(WorkItem workItem, ResourceResolver resolver, String resourcePath) {
        ResourceResolver resolverForExternalizer = this.getResolverForExternalizer(workItem, resolver);
        String externalizerHost = this.externalizer.externalLink(resolverForExternalizer, "author", "");
        if (externalizerHost != null && externalizerHost.endsWith("/")) {
            externalizerHost = externalizerHost.substring(0, externalizerHost.length() - 1);
        }
        String tenantID = this.getTenantId(resolver, resourcePath);
        externalizerHost = this.adaptTenantIDToHostUrl(externalizerHost, tenantID);
        return externalizerHost;
    }

    private String adaptTenantIDToHostUrl(String hostPrefix, String tenantID) {
        try {
            URI uri = new URI(hostPrefix, false);
            String uriWithTenant = !StringUtils.isEmpty(tenantID) ? tenantID + "." + uri.getHost() : uri.getHost();
            URI hostPrefixUri = new URI(uri.getScheme(), uri.getUserinfo(), uriWithTenant, uri.getPort(), uri.getPath());
            hostPrefix = hostPrefixUri.getURIReference();
        }
        catch (URIException e) {
            log.error("Build uri failed with hostUrl [{}] and tenantID [{}]", (Object)new String[]{hostPrefix, tenantID}, (Object)e);
        }
        return hostPrefix;
    }

    private String getTenantId(ResourceResolver resolver, String downloadAssetsPath) {
        Tenant tenant = resolver.getResource(downloadAssetsPath).adaptTo(Tenant.class);
        return tenant == null ? null : tenant.getId();
    }

    private ResourceResolver getResolverForExternalizer(WorkItem workItem, ResourceResolver workFlowResourceResolver) {
        String initiator = workItem.getWorkflow().getInitiator();
        Session initiatorSession = this.getUserSession(initiator);
        ResourceResolver initiatorResolver = this.getResourceResolver(initiatorSession);
        if (initiatorResolver != null) {
            return initiatorResolver;
        }
        return workFlowResourceResolver;
    }

    private Session getUserSession(String userId) {
        SimpleCredentials credentials = new SimpleCredentials(userId, new char[0]);
        try {
            return this.slingRepository.impersonateFromService(SERVICE_USER_ID, credentials, null);
        }
        catch (Exception e) {
            log.info("Impersonation of user '{}' failed", (Object)userId, (Object)e);
            return null;
        }
    }

    protected void bindAssetDownloadService(AssetDownloadService assetDownloadService) {
        this.assetDownloadService = assetDownloadService;
    }

    protected void unbindAssetDownloadService(AssetDownloadService assetDownloadService) {
        if (this.assetDownloadService == assetDownloadService) {
            this.assetDownloadService = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }
}

