/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging;

import com.drew.imaging.FileType;
import com.drew.imaging.FileTypeDetector;
import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.avi.AviMetadataReader;
import com.drew.imaging.bmp.BmpMetadataReader;
import com.drew.imaging.eps.EpsMetadataReader;
import com.drew.imaging.gif.GifMetadataReader;
import com.drew.imaging.ico.IcoMetadataReader;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.mp4.Mp4MetadataReader;
import com.drew.imaging.pcx.PcxMetadataReader;
import com.drew.imaging.png.PngMetadataReader;
import com.drew.imaging.psd.PsdMetadataReader;
import com.drew.imaging.quicktime.QuickTimeMetadataReader;
import com.drew.imaging.raf.RafMetadataReader;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.imaging.wav.WavMetadataReader;
import com.drew.imaging.webp.WebpMetadataReader;
import com.drew.lang.RandomAccessStreamReader;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.file.FileSystemMetadataReader;
import com.drew.metadata.file.FileTypeDirectory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class ImageMetadataReader {
    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws ImageProcessingException, IOException {
        return ImageMetadataReader.readMetadata(inputStream, -1L);
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream, long streamLength) throws ImageProcessingException, IOException {
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        FileType fileType = FileTypeDetector.detectFileType(bufferedInputStream);
        Metadata metadata = ImageMetadataReader.readMetadata(bufferedInputStream, streamLength, fileType);
        metadata.addDirectory(new FileTypeDirectory(fileType));
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream, long streamLength, FileType fileType) throws IOException, ImageProcessingException {
        switch (fileType) {
            case Jpeg: {
                return JpegMetadataReader.readMetadata(inputStream);
            }
            case Tiff: 
            case Arw: 
            case Cr2: 
            case Nef: 
            case Orf: 
            case Rw2: {
                return TiffMetadataReader.readMetadata(new RandomAccessStreamReader(inputStream, 2048, streamLength));
            }
            case Psd: {
                return PsdMetadataReader.readMetadata(inputStream);
            }
            case Png: {
                return PngMetadataReader.readMetadata((InputStream)inputStream);
            }
            case Bmp: {
                return BmpMetadataReader.readMetadata((InputStream)inputStream);
            }
            case Gif: {
                return GifMetadataReader.readMetadata((InputStream)inputStream);
            }
            case Ico: {
                return IcoMetadataReader.readMetadata((InputStream)inputStream);
            }
            case Pcx: {
                return PcxMetadataReader.readMetadata((InputStream)inputStream);
            }
            case WebP: {
                return WebpMetadataReader.readMetadata((InputStream)inputStream);
            }
            case Raf: {
                return RafMetadataReader.readMetadata((InputStream)inputStream);
            }
            case Avi: {
                return AviMetadataReader.readMetadata((InputStream)inputStream);
            }
            case Wav: {
                return WavMetadataReader.readMetadata((InputStream)inputStream);
            }
            case Mov: {
                return QuickTimeMetadataReader.readMetadata((InputStream)inputStream);
            }
            case Mp4: {
                return Mp4MetadataReader.readMetadata((InputStream)inputStream);
            }
            case Eps: {
                return EpsMetadataReader.readMetadata((InputStream)inputStream);
            }
            case Unknown: {
                throw new ImageProcessingException("File format could not be determined");
            }
        }
        return new Metadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws ImageProcessingException, IOException {
        Metadata metadata;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            metadata = ImageMetadataReader.readMetadata(inputStream, file.length());
        }
        finally {
            ((InputStream)inputStream).close();
        }
        new FileSystemMetadataReader().read(file, metadata);
        return metadata;
    }

    private ImageMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }

    public static void main(@NotNull String[] args) throws MetadataException, IOException {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean markdownFormat = argList.remove("-markdown");
        boolean showHex = argList.remove("-hex");
        if (argList.size() < 1) {
            String version = ImageMetadataReader.class.getPackage().getImplementationVersion();
            System.out.println("metadata-extractor version " + version);
            System.out.println();
            System.out.println(String.format("Usage: java -jar metadata-extractor-%s.jar <filename> [<filename>] [-thumb] [-markdown] [-hex]", version == null ? "a.b.c" : version));
            System.exit(1);
        }
        for (String filePath : argList) {
            long startTime = System.nanoTime();
            File file = new File(filePath);
            if (!markdownFormat && argList.size() > 1) {
                System.out.printf("\n***** PROCESSING: %s%n%n", filePath);
            }
            Metadata metadata = null;
            try {
                metadata = ImageMetadataReader.readMetadata(file);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            long took = System.nanoTime() - startTime;
            if (!markdownFormat) {
                System.out.printf("Processed %.3f MB file in %.2f ms%n%n", (double)file.length() / 1048576.0, (double)took / 1000000.0);
            }
            if (markdownFormat) {
                String fileName = file.getName();
                String urlName = StringUtil.urlEncode(filePath);
                ExifIFD0Directory exifIFD0Directory = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
                String make = exifIFD0Directory == null ? "" : exifIFD0Directory.getString(271);
                String model = exifIFD0Directory == null ? "" : exifIFD0Directory.getString(272);
                System.out.println();
                System.out.println("---");
                System.out.println();
                System.out.printf("# %s - %s%n", make, model);
                System.out.println();
                System.out.printf("<a href=\"https://raw.githubusercontent.com/drewnoakes/metadata-extractor-images/master/%s\">%n", urlName);
                System.out.printf("<img src=\"https://raw.githubusercontent.com/drewnoakes/metadata-extractor-images/master/%s\" width=\"300\"/><br/>%n", urlName);
                System.out.println(fileName);
                System.out.println("</a>");
                System.out.println();
                System.out.println("Directory | Tag Id | Tag Name | Extracted Value");
                System.out.println(":--------:|-------:|----------|----------------");
            }
            for (Directory directory : metadata.getDirectories()) {
                String directoryName = directory.getName();
                for (Tag tag : directory.getTags()) {
                    String tagName = tag.getTagName();
                    String description = tag.getDescription();
                    if (description != null && description.length() > 1024) {
                        description = description.substring(0, 1024) + "...";
                    }
                    if (markdownFormat) {
                        System.out.printf("%s|0x%s|%s|%s%n", directoryName, Integer.toHexString(tag.getTagType()), tagName, description);
                        continue;
                    }
                    if (showHex) {
                        System.out.printf("[%s - %s] %s = %s%n", directoryName, tag.getTagTypeHex(), tagName, description);
                        continue;
                    }
                    System.out.printf("[%s] %s = %s%n", directoryName, tagName, description);
                }
                for (String error : directory.getErrors()) {
                    System.err.println("ERROR: " + error);
                }
            }
        }
    }
}

