/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.jackrabbit.core.config.DataSourceConfig;
import org.apache.jackrabbit.core.util.db.DataSourceWrapper;
import org.apache.jackrabbit.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(ConnectionFactory.class);
    private final Object lock = new Object();
    private final Map<String, DataSource> keyToDataSource = new HashMap<String, DataSource>();
    private final Map<String, DataSource> nameToDataSource = new HashMap<String, DataSource>();
    private final Map<String, DataSourceConfig.DataSourceDefinition> nameToDataSourceDef = new HashMap<String, DataSourceConfig.DataSourceDefinition>();
    private final List<BasicDataSource> created = new ArrayList<BasicDataSource>();
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataSources(DataSourceConfig dsc) throws RepositoryException {
        Object object = this.lock;
        synchronized (object) {
            this.sanityCheck();
            for (DataSourceConfig.DataSourceDefinition def : dsc.getDefinitions()) {
                Class<Context> driverClass = this.getDriverClass(def.getDriver());
                if (driverClass != null && Context.class.isAssignableFrom(driverClass)) {
                    DataSource ds = this.getJndiDataSource(driverClass, def.getUrl());
                    this.nameToDataSource.put(def.getLogicalName(), ds);
                    this.nameToDataSourceDef.put(def.getLogicalName(), def);
                    continue;
                }
                BasicDataSource bds = this.getDriverDataSource(driverClass, def.getUrl(), def.getUser(), def.getPassword());
                if (def.getMaxPoolSize() > 0) {
                    bds.setMaxActive(def.getMaxPoolSize());
                }
                if (def.getValidationQuery() != null && !"".equals(def.getValidationQuery().trim())) {
                    bds.setValidationQuery(def.getValidationQuery());
                }
                this.nameToDataSource.put(def.getLogicalName(), (DataSource)bds);
                this.nameToDataSourceDef.put(def.getLogicalName(), def);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataSource(String logicalName) throws RepositoryException {
        Object object = this.lock;
        synchronized (object) {
            this.sanityCheck();
            DataSource ds = this.nameToDataSource.get(logicalName);
            if (ds == null) {
                throw new RepositoryException("DataSource with logicalName " + logicalName + " has not been configured");
            }
            return ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataBaseType(String logicalName) throws RepositoryException {
        Object object = this.lock;
        synchronized (object) {
            this.sanityCheck();
            DataSourceConfig.DataSourceDefinition def = this.nameToDataSourceDef.get(logicalName);
            if (def == null) {
                throw new RepositoryException("DataSource with logicalName " + logicalName + " has not been configured");
            }
            return def.getDbType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getDataSource(String driver, String url, String user, String password) throws RepositoryException, SQLException {
        String key = driver + url + user;
        Object object = this.lock;
        synchronized (object) {
            this.sanityCheck();
            DataSource ds = this.keyToDataSource.get(key);
            if (ds == null) {
                ds = this.createDataSource(driver, url, user, Base64.decodeIfEncoded(password));
                this.keyToDataSource.put(key, ds);
            }
            return ds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.sanityCheck();
            for (BasicDataSource ds : this.created) {
                try {
                    ds.close();
                }
                catch (SQLException e) {
                    log.error("failed to close " + ds, e);
                }
            }
            this.keyToDataSource.clear();
            this.nameToDataSource.clear();
            this.nameToDataSourceDef.clear();
            this.created.clear();
            this.closed = true;
        }
    }

    public static Connection unwrap(Connection con) throws SQLException {
        if (con instanceof DelegatingConnection) {
            return ((DelegatingConnection)con).getInnermostDelegate();
        }
        throw new SQLException("failed to unwrap connection of class " + con.getClass().getName() + ", expected it to be a " + DelegatingConnection.class.getName());
    }

    private void sanityCheck() {
        if (this.closed) {
            throw new IllegalStateException("this factory has already been closed");
        }
    }

    private DataSource createDataSource(String driver, String url, String user, String password) throws RepositoryException {
        Class<Context> driverClass = this.getDriverClass(driver);
        if (driverClass != null && Context.class.isAssignableFrom(driverClass)) {
            DataSource database = this.getJndiDataSource(driverClass, url);
            if (user == null && password == null) {
                return database;
            }
            return new DataSourceWrapper(database, user, password);
        }
        return this.getDriverDataSource(driverClass, url, user, password);
    }

    private Class<?> getDriverClass(String driver) throws RepositoryException {
        try {
            if (driver != null && driver.length() > 0) {
                return Class.forName(driver);
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            throw new RepositoryException("Could not load JDBC driver class " + driver, e);
        }
    }

    private DataSource getJndiDataSource(Class<Context> contextClass, String name) throws RepositoryException {
        try {
            Object object = contextClass.newInstance().lookup(name);
            if (object instanceof DataSource) {
                return (DataSource)object;
            }
            throw new RepositoryException("Object " + object + " with JNDI name " + name + " is not a JDBC DataSource");
        }
        catch (InstantiationException e) {
            throw new RepositoryException("Invalid JNDI context: " + contextClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryException("Invalid JNDI context: " + contextClass.getName(), e);
        }
        catch (NamingException e) {
            throw new RepositoryException("JNDI name not found: " + name, e);
        }
    }

    private BasicDataSource getDriverDataSource(Class<?> driverClass, String url, String user, String password) {
        BasicDataSource ds = new BasicDataSource();
        this.created.add(ds);
        if (driverClass != null) {
            Driver instance = null;
            try {
                instance = (Driver)driverClass.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (instance != null && instance.jdbcCompliant()) {
                ds.setValidationQueryTimeout(3);
            }
            ds.setDriverClassName(driverClass.getName());
        }
        ds.setUrl(url);
        ds.setUsername(user);
        ds.setPassword(password);
        ds.setDefaultAutoCommit(true);
        ds.setTestOnBorrow(false);
        ds.setTestWhileIdle(true);
        ds.setTimeBetweenEvictionRunsMillis(600000L);
        ds.setMinEvictableIdleTimeMillis(60000L);
        ds.setMaxActive(-1);
        ds.setMaxIdle(18);
        ds.setValidationQuery(this.guessValidationQuery(url));
        ds.setAccessToUnderlyingConnectionAllowed(true);
        ds.setPoolPreparedStatements(true);
        ds.setMaxOpenPreparedStatements(-1);
        return ds;
    }

    private String guessValidationQuery(String url) {
        if (url.contains("derby")) {
            return "values(1)";
        }
        if (url.contains("mysql")) {
            return "select 1";
        }
        if (url.contains("sqlserver") || url.contains("jtds")) {
            return "select 1";
        }
        if (url.contains("oracle")) {
            return "select 'validationQuery' from dual";
        }
        if (url.contains("postgresql")) {
            return "select 1";
        }
        if (url.contains("h2")) {
            return "select 1";
        }
        if (url.contains("db2")) {
            return "values(1)";
        }
        log.warn("Failed to guess validation query for URL " + url);
        return null;
    }
}

