/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DecimalPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.GenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiGenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiStringPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStateValue;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertyValues {
    private PropertyValues() {
    }

    @Nullable
    public static PropertyValue create(@Nullable PropertyState property) {
        if (property == null) {
            return null;
        }
        return PropertyValues.newValue(property);
    }

    @NotNull
    private static PropertyValue newValue(@NotNull PropertyState property) {
        return new PropertyStateValue(property);
    }

    @Nullable
    public static PropertyState create(@Nullable PropertyValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof PropertyStateValue) {
            return ((PropertyStateValue)value).unwrap();
        }
        return null;
    }

    @NotNull
    public static PropertyValue newString(@NotNull String value) {
        return new PropertyStateValue(StringPropertyState.stringProperty("", value));
    }

    @NotNull
    public static PropertyValue newString(@NotNull Iterable<String> value) {
        return new PropertyStateValue(MultiStringPropertyState.stringProperty("", value));
    }

    @NotNull
    public static PropertyValue newLong(@NotNull Long value) {
        return new PropertyStateValue(LongPropertyState.createLongProperty("", value));
    }

    @NotNull
    public static PropertyValue newDouble(@NotNull Double value) {
        return new PropertyStateValue(DoublePropertyState.doubleProperty("", value));
    }

    @NotNull
    public static PropertyValue newDecimal(@NotNull BigDecimal value) {
        return new PropertyStateValue(DecimalPropertyState.decimalProperty("", value));
    }

    @NotNull
    public static PropertyValue newBoolean(boolean value) {
        return new PropertyStateValue(BooleanPropertyState.booleanProperty("", value));
    }

    @NotNull
    public static PropertyValue newDate(@NotNull String value) {
        return new PropertyStateValue(GenericPropertyState.dateProperty("", value));
    }

    @NotNull
    public static PropertyValue newName(@NotNull String value) {
        return new PropertyStateValue(GenericPropertyState.nameProperty("", value));
    }

    @NotNull
    public static PropertyValue newName(@NotNull Iterable<String> value) {
        return new PropertyStateValue(MultiGenericPropertyState.nameProperty("", value));
    }

    @NotNull
    public static PropertyValue newPath(@NotNull String value) {
        return new PropertyStateValue(GenericPropertyState.pathProperty("", value));
    }

    @NotNull
    public static PropertyValue newReference(@NotNull String value) {
        return new PropertyStateValue(GenericPropertyState.referenceProperty("", value));
    }

    @NotNull
    public static PropertyValue newWeakReference(@NotNull String value) {
        return new PropertyStateValue(GenericPropertyState.weakreferenceProperty("", value));
    }

    @NotNull
    public static PropertyValue newUri(@NotNull String value) {
        return new PropertyStateValue(GenericPropertyState.uriProperty("", value));
    }

    @NotNull
    public static PropertyValue newBinary(@NotNull byte[] value) {
        return new PropertyStateValue(BinaryPropertyState.binaryProperty("", value));
    }

    @NotNull
    public static PropertyValue newBinary(@NotNull Blob value) {
        return new PropertyStateValue(BinaryPropertyState.binaryProperty("", value));
    }

    public static boolean match(@NotNull PropertyValue p1, @NotNull PropertyState p2) {
        return PropertyValues.match(p1, PropertyValues.newValue(p2));
    }

    public static boolean match(@NotNull PropertyState p1, @NotNull PropertyValue p2) {
        return PropertyValues.match(PropertyValues.newValue(p1), p2);
    }

    public static boolean match(@NotNull PropertyValue p1, @NotNull PropertyValue p2) {
        if (p1.getType().tag() != p2.getType().tag()) {
            return false;
        }
        switch (p1.getType().tag()) {
            case 2: {
                if (p1.isArray() && !p2.isArray()) {
                    return Iterables.contains(p1.getValue(Type.BINARIES), p2.getValue(Type.BINARY));
                }
                if (p1.isArray() || !p2.isArray()) break;
                return Iterables.contains(p2.getValue(Type.BINARIES), p1.getValue(Type.BINARY));
            }
            default: {
                if (p1.isArray() && !p2.isArray()) {
                    return Iterables.contains(p1.getValue(Type.STRINGS), p2.getValue(Type.STRING));
                }
                if (p1.isArray() || !p2.isArray()) break;
                return Iterables.contains(p2.getValue(Type.STRINGS), p1.getValue(Type.STRING));
            }
        }
        return p1.compareTo(p2) == 0;
    }

    public static boolean notMatch(@NotNull PropertyValue p1, @NotNull PropertyValue p2) {
        if (p1.getType().tag() != p2.getType().tag()) {
            return true;
        }
        switch (p1.getType().tag()) {
            case 2: {
                if (p1.isArray() && !p2.isArray()) {
                    if (p1.count() > 1) {
                        return true;
                    }
                    return !Iterables.contains(p1.getValue(Type.BINARIES), p2.getValue(Type.BINARY));
                }
                if (p1.isArray() || !p2.isArray()) break;
                if (p2.count() > 1) {
                    return true;
                }
                return !Iterables.contains(p2.getValue(Type.BINARIES), p1.getValue(Type.BINARY));
            }
            default: {
                if (p1.isArray() && !p2.isArray()) {
                    if (p1.count() > 1) {
                        return true;
                    }
                    return !Iterables.contains(p1.getValue(Type.STRINGS), p2.getValue(Type.STRING));
                }
                if (p1.isArray() || !p2.isArray()) break;
                if (p2.count() > 1) {
                    return true;
                }
                return !Iterables.contains(p2.getValue(Type.STRINGS), p1.getValue(Type.STRING));
            }
        }
        return p1.compareTo(p2) != 0;
    }
}

