/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.observation.filter.UniversalFilter;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativePathSelector
implements UniversalFilter.Selector {
    private final Iterable<String> path;
    private final UniversalFilter.Selector selector;

    public RelativePathSelector(@NotNull String path, @NotNull UniversalFilter.Selector selector) {
        this.path = PathUtils.elements(Preconditions.checkNotNull(path));
        this.selector = Preconditions.checkNotNull(selector);
    }

    @Override
    @NotNull
    public NodeState select(@NotNull UniversalFilter filter, @Nullable PropertyState before, @Nullable PropertyState after) {
        return this.select(this.selector.select(filter, before, after));
    }

    @Override
    @NotNull
    public NodeState select(@NotNull UniversalFilter filter, @NotNull String name, @NotNull NodeState before, @NotNull NodeState after) {
        return this.select(this.selector.select(filter, name, before, after));
    }

    private NodeState select(NodeState node) {
        for (String name : this.path) {
            node = node.getChildNode(name);
        }
        return node;
    }
}

