/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp4;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.Container;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.MetaBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.UserDataBox;
import com.coremedia.iso.boxes.apple.AppleItemListBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.googlecode.mp4parser.DataSource;
import com.googlecode.mp4parser.boxes.apple.AppleAlbumBox;
import com.googlecode.mp4parser.boxes.apple.AppleArtist2Box;
import com.googlecode.mp4parser.boxes.apple.AppleArtistBox;
import com.googlecode.mp4parser.boxes.apple.AppleCommentBox;
import com.googlecode.mp4parser.boxes.apple.AppleCompilationBox;
import com.googlecode.mp4parser.boxes.apple.AppleDiskNumberBox;
import com.googlecode.mp4parser.boxes.apple.AppleEncoderBox;
import com.googlecode.mp4parser.boxes.apple.AppleGPSCoordinatesBox;
import com.googlecode.mp4parser.boxes.apple.AppleGenreBox;
import com.googlecode.mp4parser.boxes.apple.AppleNameBox;
import com.googlecode.mp4parser.boxes.apple.AppleRecordingYear2Box;
import com.googlecode.mp4parser.boxes.apple.AppleTrackAuthorBox;
import com.googlecode.mp4parser.boxes.apple.AppleTrackNumberBox;
import com.googlecode.mp4parser.boxes.apple.Utf8AppleDataBox;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMP;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.mp4.DirectFileReadDataSource;
import org.apache.tika.parser.mp4.ISO6709Extractor;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MP4Parser
extends AbstractParser {
    private static final long serialVersionUID = 84011216792285L;
    private static final DecimalFormat DURATION_FORMAT = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ROOT);
    private static final Map<MediaType, List<String>> typesMap;
    private static final Set<MediaType> SUPPORTED_TYPES;
    private ISO6709Extractor iso6709Extractor = new ISO6709Extractor();

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        TemporaryResources tmp = new TemporaryResources();
        TikaInputStream tstream = TikaInputStream.get(stream, tmp);
        try (DirectFileReadDataSource dataSource = new DirectFileReadDataSource(tstream.getFile());
             IsoFile isoFile = new IsoFile((DataSource)dataSource);){
            UserDataBox userData;
            List tb;
            tmp.addResource((Closeable)isoFile);
            FileTypeBox fileType = MP4Parser.getOrNull((Container)isoFile, FileTypeBox.class);
            if (fileType != null) {
                MediaType type = MediaType.application("mp4");
                for (Map.Entry<MediaType, List<String>> e : typesMap.entrySet()) {
                    if (!e.getValue().contains(fileType.getMajorBrand())) continue;
                    type = e.getKey();
                    break;
                }
                metadata.set("Content-Type", type.toString());
                if (type.getType().equals("audio")) {
                    metadata.set(XMPDM.AUDIO_COMPRESSOR, fileType.getMajorBrand().trim());
                }
            } else {
                metadata.set("Content-Type", "video/quicktime");
            }
            MovieBox moov = MP4Parser.getOrNull((Container)isoFile, MovieBox.class);
            if (moov == null) {
                return;
            }
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            MovieHeaderBox mHeader = MP4Parser.getOrNull((Container)moov, MovieHeaderBox.class);
            if (mHeader != null) {
                metadata.set(Metadata.CREATION_DATE, mHeader.getCreationTime());
                metadata.set(TikaCoreProperties.MODIFIED, mHeader.getModificationTime());
                double durationSeconds = (double)mHeader.getDuration() / (double)mHeader.getTimescale();
                metadata.set(XMPDM.DURATION, DURATION_FORMAT.format(durationSeconds));
                metadata.set(XMPDM.AUDIO_SAMPLE_RATE, (int)mHeader.getTimescale());
            }
            if ((tb = moov.getBoxes(TrackBox.class)).size() > 0) {
                AudioSampleEntry sample;
                TrackBox track = (TrackBox)tb.get(0);
                TrackHeaderBox header = track.getTrackHeaderBox();
                metadata.set(TikaCoreProperties.CREATED, header.getCreationTime());
                metadata.set(TikaCoreProperties.MODIFIED, header.getModificationTime());
                metadata.set(Metadata.IMAGE_WIDTH, (int)header.getWidth());
                metadata.set(Metadata.IMAGE_LENGTH, (int)header.getHeight());
                SampleTableBox samples = track.getSampleTableBox();
                SampleDescriptionBox sampleDesc = samples.getSampleDescriptionBox();
                if (sampleDesc != null && (sample = MP4Parser.getOrNull((Container)sampleDesc, AudioSampleEntry.class)) != null) {
                    XMPDM.ChannelTypePropertyConverter.convertAndSet(metadata, sample.getChannelCount());
                    metadata.set(XMPDM.AUDIO_SAMPLE_RATE, (int)sample.getSampleRate());
                }
            }
            if ((userData = MP4Parser.getOrNull((Container)moov, UserDataBox.class)) != null) {
                this.extractGPS(userData, metadata);
                MetaBox meta = MP4Parser.getOrNull((Container)userData, MetaBox.class);
                AppleItemListBox apple = MP4Parser.getOrNull((Container)meta, AppleItemListBox.class);
                if (apple != null) {
                    AppleCompilationBox compilation;
                    AppleDiskNumberBox discNum;
                    AppleTrackNumberBox trackNum;
                    AppleNameBox title = MP4Parser.getOrNull((Container)apple, AppleNameBox.class);
                    MP4Parser.addMetadata(TikaCoreProperties.TITLE, metadata, (Utf8AppleDataBox)title);
                    AppleArtistBox artist = MP4Parser.getOrNull((Container)apple, AppleArtistBox.class);
                    MP4Parser.addMetadata(TikaCoreProperties.CREATOR, metadata, (Utf8AppleDataBox)artist);
                    MP4Parser.addMetadata(XMPDM.ARTIST, metadata, (Utf8AppleDataBox)artist);
                    AppleArtist2Box artist2 = MP4Parser.getOrNull((Container)apple, AppleArtist2Box.class);
                    MP4Parser.addMetadata(XMPDM.ALBUM_ARTIST, metadata, (Utf8AppleDataBox)artist2);
                    AppleAlbumBox album = MP4Parser.getOrNull((Container)apple, AppleAlbumBox.class);
                    MP4Parser.addMetadata(XMPDM.ALBUM, metadata, (Utf8AppleDataBox)album);
                    AppleTrackAuthorBox composer = MP4Parser.getOrNull((Container)apple, AppleTrackAuthorBox.class);
                    MP4Parser.addMetadata(XMPDM.COMPOSER, metadata, (Utf8AppleDataBox)composer);
                    AppleGenreBox genre = MP4Parser.getOrNull((Container)apple, AppleGenreBox.class);
                    MP4Parser.addMetadata(XMPDM.GENRE, metadata, (Utf8AppleDataBox)genre);
                    AppleRecordingYear2Box year = MP4Parser.getOrNull((Container)apple, AppleRecordingYear2Box.class);
                    if (year != null) {
                        metadata.set(XMPDM.RELEASE_DATE, year.getValue());
                    }
                    if ((trackNum = MP4Parser.getOrNull((Container)apple, AppleTrackNumberBox.class)) != null) {
                        metadata.set(XMPDM.TRACK_NUMBER, trackNum.getA());
                    }
                    if ((discNum = MP4Parser.getOrNull((Container)apple, AppleDiskNumberBox.class)) != null) {
                        metadata.set(XMPDM.DISC_NUMBER, discNum.getA());
                    }
                    if ((compilation = MP4Parser.getOrNull((Container)apple, AppleCompilationBox.class)) != null) {
                        metadata.set(XMPDM.COMPILATION, (int)compilation.getValue());
                    }
                    AppleCommentBox comment = MP4Parser.getOrNull((Container)apple, AppleCommentBox.class);
                    MP4Parser.addMetadata(XMPDM.LOG_COMMENT, metadata, (Utf8AppleDataBox)comment);
                    AppleEncoderBox encoder = MP4Parser.getOrNull((Container)apple, AppleEncoderBox.class);
                    if (encoder != null) {
                        metadata.set(XMP.CREATOR_TOOL, encoder.getValue());
                    }
                    for (Box box : apple.getBoxes()) {
                        if (!(box instanceof Utf8AppleDataBox)) continue;
                        xhtml.element("p", ((Utf8AppleDataBox)box).getValue());
                    }
                }
            }
            xhtml.endDocument();
        }
        finally {
            tmp.dispose();
        }
    }

    private void extractGPS(UserDataBox userData, Metadata metadata) {
        AppleGPSCoordinatesBox coordBox = MP4Parser.getOrNull((Container)userData, AppleGPSCoordinatesBox.class);
        if (coordBox == null) {
            return;
        }
        String iso6709 = coordBox.getValue();
        this.iso6709Extractor.extract(iso6709, metadata);
    }

    private static void addMetadata(Property prop, Metadata m, Utf8AppleDataBox metadata) {
        if (metadata != null) {
            m.set(prop, metadata.getValue());
        }
    }

    private static <T extends Box> T getOrNull(Container box, Class<T> clazz) {
        if (box == null) {
            return null;
        }
        List boxes = box.getBoxes(clazz);
        if (boxes.size() == 0) {
            return null;
        }
        return (T)((Box)boxes.get(0));
    }

    static {
        DURATION_FORMAT.applyPattern("0.0#");
        typesMap = new HashMap<MediaType, List<String>>();
        typesMap.put(MediaType.audio("mp4"), Arrays.asList("M4A ", "M4B ", "F4A ", "F4B "));
        typesMap.put(MediaType.video("3gpp"), Arrays.asList("3ge6", "3ge7", "3gg6", "3gp1", "3gp2", "3gp3", "3gp4", "3gp5", "3gp6", "3gs7"));
        typesMap.put(MediaType.video("3gpp2"), Arrays.asList("3g2a", "3g2b", "3g2c"));
        typesMap.put(MediaType.video("mp4"), Arrays.asList("mp41", "mp42"));
        typesMap.put(MediaType.video("x-m4v"), Arrays.asList("M4V ", "M4VH", "M4VP"));
        typesMap.put(MediaType.video("quicktime"), Collections.emptyList());
        typesMap.put(MediaType.application("mp4"), Collections.emptyList());
        SUPPORTED_TYPES = Collections.unmodifiableSet(typesMap.keySet());
    }
}

