/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.exm.expeval;

import com.adobe.aemfd.expeditor.service.ToJspElCompilerService;
import com.adobe.exm.exception.LogLevels;
import com.adobe.exm.exception.MessageLogger;
import com.adobe.exm.expeval.functionutil.SampleFunctionUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.el.FunctionMapper;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.osgi.service.component.ComponentContext;

@Component(immediate=true)
@Service(value={FunctionMapper.class})
public class DefaultFunctionMapper
implements FunctionMapper {
    @Reference
    private ToJspElCompilerService toJspElCompilerService;
    private Map<String, Object> expressionUtils;
    private Map<String, Method> methods;

    public Map<String, Object> getExpressionUtils() {
        return this.expressionUtils;
    }

    public void setExpressionUtils(Map<String, Object> expressionUtils) {
        this.expressionUtils = expressionUtils;
        if (this.methods == null) {
            Map.Entry[] euIterator;
            this.methods = new HashMap<String, Method>();
            for (Map.Entry expressionUtil : euIterator = expressionUtils.entrySet().toArray(new Map.Entry[1])) {
                String prefix = (String)expressionUtil.getKey();
                Object functionContainer = expressionUtil.getValue();
                for (Method method : functionContainer.getClass().getDeclaredMethods()) {
                    this.methods.put(prefix + ":" + method.getName(), method);
                }
            }
        }
    }

    public Method resolveFunction(String prefix, String localName) {
        Method method = null;
        if (prefix != null && prefix.trim().length() > 0 && localName != null && localName.trim().length() > 0 && (method = "exp".equals(prefix) ? this.toJspElCompilerService.getDefaultFunctionMapper().resolveFunction(prefix, localName) : this.methods.get(prefix + ":" + localName)) == null) {
            MessageLogger.logMessage(this.getClass(), LogLevels.LOG_ERROR, "ALC-EXP-001-005", new String[]{localName});
        }
        return method;
    }

    protected void activate(ComponentContext context) {
        HashMap<String, Object> expressionUtils = new HashMap<String, Object>();
        expressionUtils.put("fm1", new SampleFunctionUtil());
        this.setExpressionUtils(expressionUtils);
    }

    public void setToJspElCompilerService(ToJspElCompilerService toJspElCompilerService) {
        this.toJspElCompilerService = toJspElCompilerService;
    }

    protected void bindToJspElCompilerService(ToJspElCompilerService toJspElCompilerService) {
        this.toJspElCompilerService = toJspElCompilerService;
    }

    protected void unbindToJspElCompilerService(ToJspElCompilerService toJspElCompilerService) {
        if (this.toJspElCompilerService == toJspElCompilerService) {
            this.toJspElCompilerService = null;
        }
    }
}

