/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.util;

import com.adobe.aem.dermis.util.ValueUtil;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

public class SlingJSONWriter {
    private final JSONWriter writer;

    public SlingJSONWriter(Writer writer) {
        this.writer = new JSONWriter(writer);
    }

    public void write(Object value) {
        try {
            if (value instanceof Map) {
                this.writeProperties((Map)value);
            } else if (value instanceof List) {
                this.writeStream((List)value);
            } else {
                this.writeValue(value);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeProperties(Map map) throws JSONException {
        this.writer.object();
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            this.writer.key((String)entry.getKey());
            this.write(entry.getValue());
        }
        this.writer.endObject();
    }

    private void writeStream(List<?> valueList) throws JSONException {
        this.writer.array();
        for (Object object : valueList) {
            this.write(object);
        }
        this.writer.endArray();
    }

    private void writeValue(Object value) throws JSONException {
        this.writer.value(ValueUtil.getFormattedValue(value));
    }

    private void writeObject(String type, Object value) throws JSONException {
        this.writer.object();
        this.writer.key("$" + type);
        this.writer.value(value);
        this.writer.endObject();
    }
}

