/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.util;

import com.adobe.aem.dermis.exception.DermisException;
import com.adobe.aem.dermis.model.DataModel;
import com.adobe.aem.dermis.model.IDataModel;
import com.adobe.aem.dermis.model.IProperty;
import com.adobe.aem.dermis.model.JSONRenderer;
import com.adobe.aem.dermis.model.Property;
import com.adobe.aem.dermis.model.PropertyFormatType;
import com.adobe.aem.dermis.model.PropertyType;
import com.adobe.aem.dermis.model.value.CustomDate;
import com.adobe.aem.dermis.model.value.ITypeValue;
import com.adobe.aem.dermis.model.value.IValue;
import com.adobe.aem.dermis.model.value.IValueList;
import com.adobe.aem.dermis.model.value.IValueMap;
import com.adobe.aem.dermis.model.value.TypeValue;
import com.adobe.aem.dermis.model.value.ValueList;
import com.adobe.aem.dermis.model.value.ValueMap;
import com.adobe.aem.dermis.usc.model.Binary;
import com.adobe.aem.dermis.util.DermisUtils;
import com.adobe.aem.dermis.util.JsonUtils;
import com.adobe.aemfd.dermis.authentication.exception.DermisLogger;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean2;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueUtil {
    private static ConvertUtilsBean2 convertUtilsBean2 = new ConvertUtilsBean2();
    private static JSONRenderer renderer = new JSONRenderer();
    private static final Logger logger = LoggerFactory.getLogger(ValueUtil.class);

    public static IValue generateValue(IProperty property, Object data, boolean autoCoerce) throws DermisException {
        return ValueUtil.generateValue(property, data, autoCoerce, true);
    }

    public static IValue generateValue(IProperty property, Object data, List<? extends IDataModel> datamodels, boolean autoCoerce) throws DermisException {
        return ValueUtil.generateValue(property, data, datamodels, autoCoerce, true);
    }

    public static IValue generateValue(IProperty property, Object data, boolean autoCoerce, boolean generateNullForPropsNotInData) throws DermisException {
        return ValueUtil.generateValue(property, data, autoCoerce, generateNullForPropsNotInData, false);
    }

    public static IValue generateValue(IProperty property, Object data, List<? extends IDataModel> dataModels, boolean autoCoerce, boolean generateNullForPropsNotInData) throws DermisException {
        return ValueUtil.generateValue(property, data, dataModels, autoCoerce, generateNullForPropsNotInData, false);
    }

    public static IValue generateValue(IProperty property, Object data, boolean autoCoerce, boolean generateNullForPropsNotInData, boolean removeComputedAttributes) throws DermisException {
        return ValueUtil.generateValue(property, data, null, autoCoerce, generateNullForPropsNotInData, removeComputedAttributes);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IValue generateValue(IProperty property, Object data, List<? extends IDataModel> dataModels, boolean autoCoerce, boolean generateNullForPropsNotInData, boolean removeComputedAttributes) throws DermisException {
        void var6_10;
        Object var6_6 = null;
        if (property == null) return var6_10;
        if (data == null) return var6_10;
        PropertyType type = property.getType();
        PropertyType subType = property.getSubType();
        PropertyFormatType formatType = property.getFormatType();
        if (PropertyType.ARRAY == type) {
            List dataList;
            Class subTypeClass = DermisUtils.getJavaClassForTypeAndFormat(subType, formatType);
            if (subTypeClass.isInstance(data) && !(data instanceof List)) {
                dataList = new ArrayList();
                dataList.add(data);
                data = dataList;
            }
            if (!(data instanceof List)) throw new DermisException("Excepted list data in case of property type array");
            IValueList iValueList = ValueList.of(null);
            dataList = (List)data;
            Iterator iterator = dataList.iterator();
            boolean isObjectType = PropertyType.OBJECT == subType;
            Property prop = new Property(property.getName(), property.getSubType(), null);
            while (iterator.hasNext()) {
                IValue childValue;
                Object nextObject = iterator.next();
                if (isObjectType) {
                    IDataModel dataModel = DermisUtils.resolveType(dataModels, (Map)nextObject);
                    if (dataModel == null) {
                        IDataModel refDatamodel = DermisUtils.getRefDatamodel(dataModels, property);
                        dataModel = refDatamodel != null ? refDatamodel : property.getChildDataModel();
                    }
                    childValue = ValueUtil.generateValue(dataModel, (Map)nextObject, dataModels, autoCoerce, generateNullForPropsNotInData, removeComputedAttributes);
                } else {
                    prop.setFormatType(property.getFormatType());
                    childValue = ValueUtil.generateValue(prop, nextObject, dataModels, autoCoerce, generateNullForPropsNotInData, removeComputedAttributes);
                }
                iValueList.add(childValue);
            }
            return var6_10;
        } else if (PropertyType.OBJECT == type) {
            if (!(data instanceof Map)) throw new DermisException("Excepted map data in case of property type object");
            IDataModel dataModel = DermisUtils.resolveType(dataModels, (Map)data);
            if (dataModel == null) {
                IDataModel refDatamodel = DermisUtils.getRefDatamodel(dataModels, property);
                if (refDatamodel != null) {
                    dataModel = refDatamodel;
                } else {
                    dataModel = new DataModel();
                    ((DataModel)dataModel).addProperties(property.getProperties());
                }
            }
            IValueMap iValueMap = ValueUtil.generateValue(dataModel, (Map)data, dataModels, autoCoerce, generateNullForPropsNotInData, removeComputedAttributes);
            return var6_10;
        } else {
            if (autoCoerce && data != null) {
                List actualData = data;
                if (data instanceof ITypeValue) {
                    actualData = ((ITypeValue)data).get();
                }
                ConvertUtilsBean2 convertUtilsBean2 = (ConvertUtilsBean2)ValueUtil.getConversionUtil();
                data = convertUtilsBean2.convert(actualData, DermisUtils.getJavaClassForTypeAndFormat(type, formatType));
            }
            TypeValue typeValue = TypeValue.of(type, formatType, data);
        }
        return var6_10;
    }

    public static IValueMap generateValue(IDataModel dataModel, Map<String, Object> data, boolean autoCoerce) throws DermisException {
        return ValueUtil.generateValue(dataModel, data, autoCoerce, true);
    }

    public static IValueMap generateValue(IDataModel dataModel, Map<String, Object> data, List<? extends IDataModel> datamodels, boolean autoCoerce) throws DermisException {
        return ValueUtil.generateValue(dataModel, data, datamodels, autoCoerce, true);
    }

    public static IValueMap generateValue(IDataModel dataModel, Map<String, Object> data, boolean autoCoerce, boolean generateNullForPropsNotInData) throws DermisException {
        return ValueUtil.generateValue(dataModel, data, autoCoerce, generateNullForPropsNotInData, false);
    }

    public static IValueMap generateValue(IDataModel dataModel, Map<String, Object> data, List<? extends IDataModel> datamodels, boolean autoCoerce, boolean generateNullForPropsNotInData) throws DermisException {
        return ValueUtil.generateValue(dataModel, data, datamodels, autoCoerce, generateNullForPropsNotInData, false);
    }

    public static IValueMap generateValue(IDataModel dataModel, Map<String, Object> data, boolean autoCoerce, boolean generateNullForPropsNotInData, boolean removeComputedAttributes) throws DermisException {
        return ValueUtil.generateValue(dataModel, data, null, autoCoerce, generateNullForPropsNotInData, removeComputedAttributes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IValueMap generateValue(IDataModel dataModel, Map<String, Object> data, List<? extends IDataModel> datamodels, boolean autoCoerce, boolean generateNullForPropsNotInData, boolean removeComputedAttributes) throws DermisException {
        IValueMap value = ValueMap.of(null);
        IValue childValue = null;
        if (data != null & dataModel != null && dataModel.getProperties() != null && dataModel.getProperties().size() > 0) {
            if (data.containsKey("_fdm_additionalData")) {
                IValueMap additionalData = ValueMap.of(null);
                Map fdmAdditionalData = (Map)data.get("_fdm_additionalData");
                if (fdmAdditionalData != null && fdmAdditionalData.size() > 0) {
                    Iterator iterator = fdmAdditionalData.keySet().iterator();
                    String key = null;
                    Property property = null;
                    while (iterator.hasNext()) {
                        key = (String)iterator.next();
                        if (key.equals("_attributes")) {
                            if (fdmAdditionalData.get("_attributes") instanceof ValueMap) {
                                IValueMap attributeMap = ValueMap.of((ValueMap)fdmAdditionalData.get("_attributes"));
                                additionalData.put(key, attributeMap);
                                continue;
                            }
                            if (fdmAdditionalData.get("_attributes") instanceof HashMap) {
                                IValueMap attributeData = ValueMap.of(null);
                                Map attributeMap = (Map)fdmAdditionalData.get("_attributes");
                                for (Map.Entry attribute : attributeMap.entrySet()) {
                                    if (attribute.getValue() instanceof String) {
                                        attributeData.put((String)attribute.getKey(), TypeValue.of(PropertyType.STRING, null, attribute.getValue()));
                                    } else if (attribute.getValue() instanceof HashMap) {
                                        IValueMap innerAttributeMap = ValueMap.of(null);
                                        Map innerAttributeData = (Map)((Map)fdmAdditionalData.get("_attributes")).get(attribute.getKey());
                                        for (Map.Entry innerAttribute : innerAttributeData.entrySet()) {
                                            if (!(innerAttribute.getValue() instanceof String)) continue;
                                            innerAttributeMap.put((String)innerAttribute.getKey(), TypeValue.of(PropertyType.STRING, null, innerAttribute.getValue()));
                                        }
                                        attributeData.put((String)attribute.getKey(), innerAttributeMap);
                                    }
                                    additionalData.put(key, attributeData);
                                }
                                continue;
                            }
                            DermisLogger.logErrorAndDebug(ValueUtil.class, "Attribute instance not defined", fdmAdditionalData.get("_attributes").getClass().toString());
                            continue;
                        }
                        property = new Property(key, null, PropertyType.STRING);
                        childValue = ValueUtil.generateValue(property, fdmAdditionalData.get(property.getName()), autoCoerce);
                        additionalData.put(key, childValue);
                    }
                    value.put("_fdm_additionalData", additionalData);
                }
            }
            List<? extends IProperty> properties = dataModel.getProperties();
            for (IProperty iProperty : properties) {
                if (iProperty == null || iProperty.isComputed() && removeComputedAttributes || !data.containsKey(iProperty.getName()) && !generateNullForPropsNotInData) continue;
                childValue = ValueUtil.generateValue(iProperty, data.get(iProperty.getName()), datamodels, autoCoerce, generateNullForPropsNotInData);
                value.put(iProperty.getName(), childValue);
            }
            return value;
        }
        if (data == null || dataModel == null || !data.containsKey("_fdm_additionalData")) return value;
        try {
            if (!((Map)data.get("_fdm_additionalData")).containsKey("_attributes")) return value;
            IValueMap additionalData = ValueMap.of(null);
            Map fdmAdditionalData = (Map)data.get("_fdm_additionalData");
            if (fdmAdditionalData == null || fdmAdditionalData.size() <= 0) return value;
            if (fdmAdditionalData.get("_attributes") instanceof ValueMap) {
                IValueMap iValueMap = ValueMap.of((ValueMap)fdmAdditionalData.get("_attributes"));
                additionalData.put("_attributes", iValueMap);
            } else if (fdmAdditionalData.get("_attributes") instanceof HashMap) {
                IValueMap iValueMap = ValueMap.of(null);
                Map attributeMap = (Map)fdmAdditionalData.get("_attributes");
                for (Map.Entry attribute : attributeMap.entrySet()) {
                    if (!(attribute.getValue() instanceof String)) continue;
                    iValueMap.put((String)attribute.getKey(), TypeValue.of(PropertyType.STRING, null, attribute.getValue()));
                }
                additionalData.put("_attributes", iValueMap);
            } else {
                DermisLogger.logErrorAndDebug(ValueUtil.class, "Attribute instance not defined for empty elements", fdmAdditionalData.get("_attributes").getClass().toString());
            }
            value.put("_fdm_additionalData", additionalData);
            return value;
        }
        catch (Exception e) {
            logger.error("error occurred while adding attributes for elements which does not have values : " + e.getStackTrace());
        }
        return value;
    }

    public static ConvertUtilsBean getConversionUtil() {
        return convertUtilsBean2;
    }

    public static IValue jsonToValue(String jsonString, IProperty property) throws DermisException, JSONException {
        IValue value = null;
        if (StringUtils.isNotEmpty((String)jsonString)) {
            Object json = new JSONTokener(jsonString).nextValue();
            if (json instanceof JSONArray) {
                value = ValueUtil.jsonListToValue((JSONArray)json);
            } else if (json instanceof JSONObject) {
                value = ValueUtil.jsonObjectToValue((JSONObject)json);
            } else if (property.isPrimitiveType()) {
                value = TypeValue.of(property.getType(), property.getFormatType(), json);
            } else {
                DermisLogger.logErrorAndDebug(ValueUtil.class, "Unexpected value found for property " + property.getName(), "Unexpected value " + value + " found for property " + property.getName());
            }
        }
        return value;
    }

    public static IValue jsonToValue(Object data) throws DermisException, JSONException {
        IValue value = null;
        if (data != null && data != JSONObject.NULL) {
            if (data instanceof JSONArray) {
                value = ValueUtil.jsonListToValue((JSONArray)data);
            } else if (data instanceof JSONObject) {
                value = ValueUtil.jsonObjectToValue((JSONObject)data);
            } else {
                PropertyType propertyType = PropertyType.getPropertyType(data.getClass());
                PropertyFormatType formatType = PropertyFormatType.getFormatType(data.getClass());
                value = TypeValue.of(propertyType, formatType, data);
            }
        }
        return value;
    }

    public static IValueMap jsonObjectToValue(JSONObject data) throws DermisException, JSONException {
        IValueMap valueMap = ValueMap.of(null);
        if (data != null && data != JSONObject.NULL) {
            Iterator keysItr = data.keys();
            IValue childValue = null;
            while (keysItr.hasNext()) {
                String key = (String)keysItr.next();
                Object childData = JsonUtils.getValue(data, key);
                childValue = ValueUtil.jsonToValue(childData);
                valueMap.put(key, childValue);
            }
        }
        return valueMap;
    }

    public static IValueList jsonListToValue(JSONArray array) throws DermisException, JSONException {
        IValueList valueList = ValueList.of(null);
        if (array != null) {
            for (int i = 0; i < array.length(); ++i) {
                Object data = array.get(i);
                IValue childValue = ValueUtil.jsonToValue(data);
                valueList.add(childValue);
            }
        }
        return valueList;
    }

    public static Object getFormattedValue(Object value) {
        Object result = value;
        if (value != null) {
            Object actualValue = value;
            if (value instanceof ITypeValue) {
                result = actualValue = ((ITypeValue)value).get();
            }
            if (actualValue instanceof CustomDate) {
                result = actualValue.toString();
            } else if (actualValue instanceof Date) {
                result = ISO8601Utils.format((Date)((Date)actualValue), (boolean)true);
            } else if (actualValue instanceof byte[]) {
                result = Base64.encodeBase64String((byte[])((byte[])actualValue));
            } else if (actualValue instanceof Binary) {
                result = ((Binary)actualValue).toJson();
            } else if (value instanceof JSONObject) {
                result = renderer.toString((JSONObject)value);
            } else if (value instanceof JSONArray) {
                result = renderer.toString((JSONArray)value);
            } else if (value instanceof IValueMap || value instanceof IValueList) {
                try {
                    Object json = JsonUtils.getJSON((IValue)value);
                    result = ValueUtil.getFormattedValue(json);
                }
                catch (DermisException e) {
                    DermisLogger.logErrorAndDebug(ValueUtil.class, "Unexpected exception occurred while converting IValue to JSON", e);
                }
            }
        }
        return result;
    }

    public static IValue getValue(IValueMap valueMap, String name) {
        IValue result = null;
        if (valueMap != null && valueMap.containsKey(name)) {
            result = valueMap.get(name);
        }
        return result;
    }

    static {
        convertUtilsBean2.register(new Converter(){

            public Object convert(Class aClass, Object object) {
                Object value = null;
                if (object instanceof Binary) {
                    value = object;
                } else if (object instanceof ValueMap) {
                    try {
                        ValueMap valueMap = (ValueMap)object;
                        String contentType = valueMap.get("contentType") != null ? valueMap.get("contentType").toString() : null;
                        String name = valueMap.get("name") != null ? valueMap.get("name").toString() : null;
                        String uri = valueMap.get("uri") != null ? valueMap.get("uri").toString() : null;
                        Binary binary = new Binary(contentType, uri, name);
                        value = binary;
                    }
                    catch (Exception e) {
                        DermisLogger.logErrorAndDebug(ValueUtil.class, "Parse exception while parsing value map input to custom format file", e);
                    }
                } else if (object instanceof String) {
                    try {
                        byte[] fileBytes = null;
                        ObjectMapper mapper = new ObjectMapper();
                        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                        JsonNode jsonNode = mapper.readTree((String)object);
                        if (jsonNode.has("bytes") && jsonNode.get("bytes") instanceof TextNode) {
                            String bytesInBase64Format = jsonNode.get("bytes").asText();
                            fileBytes = Base64.decodeBase64((String)bytesInBase64Format);
                            ((ObjectNode)jsonNode).remove("bytes");
                        }
                        Binary binary = (Binary)mapper.readValue(mapper.writeValueAsString((Object)jsonNode), Binary.class);
                        binary.setBytes(fileBytes);
                        value = binary;
                    }
                    catch (Exception e) {
                        DermisLogger.logErrorAndDebug(ValueUtil.class, "Parse exception while parsing string input to custom format file", e);
                    }
                } else {
                    DermisLogger.logMessage(ValueUtil.class, 1, "Unexpected value found for format file", null);
                }
                return value;
            }
        }, Binary.class);
        convertUtilsBean2.register(new Converter(){

            public Object convert(Class aClass, Object object) {
                Object value = null;
                if (object instanceof byte[]) {
                    value = object;
                } else if (object instanceof String) {
                    try {
                        value = Base64.decodeBase64((String)((String)object));
                    }
                    catch (IllegalArgumentException e) {
                        DermisLogger.logErrorAndDebug(ValueUtil.class, "Parse exception while parsing string input to binary", e);
                    }
                } else {
                    DermisLogger.logMessage(ValueUtil.class, 1, "Unexpected value found for type binary", null);
                }
                return value;
            }
        }, byte[].class);
        convertUtilsBean2.register(new Converter(){

            public Object convert(Class aClass, Object object) {
                Object value = null;
                if (object instanceof UUID) {
                    value = object;
                } else if (object instanceof String) {
                    try {
                        value = UUID.fromString((String)object);
                    }
                    catch (IllegalArgumentException e) {
                        DermisLogger.logErrorAndDebug(ValueUtil.class, "Parse exception while parsing string input to uuid", e);
                    }
                } else {
                    DermisLogger.logMessage(ValueUtil.class, 1, "Unexpected value found for type UUID", null);
                }
                return value;
            }
        }, UUID.class);
        convertUtilsBean2.register(new Converter(){

            public Object convert(Class aClass, Object input) {
                CustomDate value = null;
                if (input != null) {
                    if (input instanceof ITypeValue) {
                        input = ((ITypeValue)input).get();
                    } else if (input instanceof Date) {
                        value = CustomDate.convertToCustomDate((Date)input);
                    } else if (input instanceof String && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)input))) {
                        value = CustomDate.parseInput((String)input);
                    } else {
                        DermisLogger.logErrorAndDebug(ValueUtil.class, "Unexpected value found for type Date", "Unexpected value found for type Date " + input);
                    }
                }
                return value;
            }
        }, CustomDate.class);
        convertUtilsBean2.register(new Converter(){

            public Object convert(Class aClass, Object input) {
                Object value = null;
                if (input != null) {
                    if (input instanceof ITypeValue) {
                        input = ((ITypeValue)input).get();
                    }
                    if (input instanceof Timestamp) {
                        value = new Date(((Timestamp)input).getTime());
                    } else if (input instanceof Date) {
                        value = input;
                    } else if (input instanceof Calendar) {
                        value = ((Calendar)input).getTime();
                    } else if (input instanceof String && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((String)input))) {
                        try {
                            value = ISO8601Utils.parse((String)input.toString(), (ParsePosition)new ParsePosition(0));
                        }
                        catch (ParseException e) {
                            DermisLogger.logErrorAndDebug(ValueUtil.class, "Parse exception while parsing string input to date", e);
                        }
                    } else {
                        DermisLogger.logErrorAndDebug(ValueUtil.class, "Unexpected value found for type Date", "Unexpected value found for type Date " + input);
                    }
                }
                return value;
            }
        }, Date.class);
    }
}

