/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.service.GuideSchemaType;
import com.adobe.aemds.guide.utils.XMLUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.w3c.dom.Document;

public class GuideModelUtils {
    public static String getDataForDORMerge(Document dorDoc, Document dataDocument, JSONObject guideContainerJson) throws JSONException {
        String xdpRef = guideContainerJson.has("xdpRef") ? guideContainerJson.getString("xdpRef") : null;
        String xsdRef = guideContainerJson.has("xsdRef") ? guideContainerJson.getString("xsdRef") : null;
        String excludeFromDorIfHidden = guideContainerJson.has("excludeFromDoRIfHidden") ? guideContainerJson.getString("excludeFromDoRIfHidden") : null;
        return GuideModelUtils.getDataForDORMerge(dorDoc, dataDocument, xdpRef, xsdRef, excludeFromDorIfHidden, guideContainerJson);
    }

    @Deprecated
    public static String getDataForDORMerge(Document dorDoc, Document dataDocument, Resource guideContainerResource) {
        GuideContainer guideContainerBean = GuideContainer.from(guideContainerResource);
        ValueMap guideContainerProps = (ValueMap)guideContainerBean.getResource().adaptTo(ValueMap.class);
        String schemaRef = guideContainerBean.getSchemaRef();
        GuideSchemaType schemaType = guideContainerBean.getSchema();
        String xdpRef = GuideSchemaType.XDP.equals((Object)schemaType) ? schemaRef : null;
        String xsdRef = GuideSchemaType.XSD.equals((Object)schemaType) ? schemaRef : null;
        String excludeFromDorIfHidden = (String)guideContainerProps.get("excludeFromDoRIfHidden", String.class);
        return GuideModelUtils.getDataForDORMerge(dorDoc, dataDocument, xdpRef, xsdRef, excludeFromDorIfHidden, new JSONObject());
    }

    private static String getDataForDORMerge(Document dorDoc, Document dataDocument, String xdpRef, String xsdRef, String excludeFromDorIfHidden, JSONObject guideJson) {
        return XMLUtils.getDorDataXmlPart(dorDoc, dataDocument, excludeFromDorIfHidden, StringUtils.isEmpty((String)xdpRef), guideJson);
    }
}

