/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.dor.PaginationService;
import com.adobe.aemds.guide.model.FormMetaData;
import com.adobe.aemds.guide.model.ReCaptchaConfiguration;
import com.adobe.aemds.guide.model.ReCaptchaConfigurationModel;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.GuideLCServiceConnector;
import com.adobe.aemds.guide.service.GuideProgressiveStrategyManager;
import com.adobe.aemds.guide.service.external.FormDataModelService;
import com.adobe.aemds.guide.service.internal.AdobeSignConfigurationService;
import com.adobe.aemds.guide.service.internal.ReCaptchaConfigService;
import com.adobe.aemds.guide.service.internal.ReCaptchaConfigurationService;
import com.adobe.aemds.guide.service.internal.TypekitConfigurationService;
import com.adobe.aemds.guide.utils.DoRConstants;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideThemeUtils;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.JSONArrayIterator;
import com.adobe.aemds.guide.utils.NodeStructureUtils;
import com.adobe.forms.common.service.FormDataProviderRegistry;
import com.adobe.forms.foundation.cloudconfig.ICloudConfigurationResourceProvider;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.Value;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.foundation.forms.FormsManager;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={GuidePropertyProviderUtils.class})
@Component(immediate=true, metatype=false)
public class GuidePropertyProviderUtils {
    private static final String COMPONENT_PATH = "component-path";
    private final Logger logger = LoggerFactory.getLogger(GuidePropertyProviderUtils.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private volatile GuideLCServiceConnector guideLCServiceConnector;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY_UNARY)
    private volatile GuideProgressiveStrategyManager guideProgressiveStrategyManager;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    protected volatile FormDataModelService formDataModelService;
    @Reference
    private HtmlLibraryManager htmlLibraryManager;
    @Reference
    ResourceResolverHelper resourceResolverHelper;
    @Reference
    ResourceResolverFactory resourceResolverFactory;
    @Reference
    FormDataProviderRegistry prefillRegistry;
    @Reference
    PaginationService paginationService;
    @Reference
    private ReCaptchaConfigService reCaptchaConfigService;
    @Reference
    private ReCaptchaConfigurationService reCaptchaConfigurationService;
    @Reference
    private TypekitConfigurationService typekitConfigurationService;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private volatile AdobeSignConfigurationService adobeSignConfigurationService;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    public volatile ICloudConfigurationResourceProvider configurationResourceProvider;
    private static String SUBMITACTION = "submitAction";
    private static String CAPTCHA_SERVICE = "CaptchaService";
    private static String GRANITE_DATA = "granite:data";
    private static String VALUE = "value";
    private static String TEXT = "text";
    private static String DESCRIPTION = "description";
    private static String JCR_SQL2 = "JCR-SQL2";
    private static String TITLE = "title";
    private static String DAM_METADATA = "jcr:content/metadata";
    private static String CLOUD_CONFIG_LISTING_ERROR = "[AF][Captcha] Unexpected error while listing cloud service configurations from /conf";

    public JSONArray queryAppearance(String[] searchPaths, Map<String, String> options) {
        try {
            String guideNodeClass = options.get("guideNodeClass");
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            JSONObject firstObj = new JSONObject();
            firstObj.put(TEXT, (Object)"none");
            firstObj.put(VALUE, JSONObject.NULL);
            response.put((Object)firstObj);
            if (guideNodeClass != null && !guideNodeClass.isEmpty() && GuideUtils.listContains(GuideConstants.GUIDE_FIELDS_CLASS_NAMES, guideNodeClass, Boolean.TRUE).booleanValue()) {
                for (int i = 0; i < searchPaths.length; ++i) {
                    String query = "SELECT * FROM nt:base WHERE guideComponentType= 'fd/af/components/appearance/" + guideNodeClass + "' AND jcr:path LIKE '" + searchPaths[i] + "%'";
                    Iterator appearances = resolver.findResources(query, "sql");
                    if (appearances == null) continue;
                    while (appearances.hasNext()) {
                        String qtip;
                        Resource r = (Resource)appearances.next();
                        String path = r.getPath();
                        if (path.startsWith("/libs/") || path.startsWith("/apps/")) {
                            path = path.substring(6);
                        }
                        if (StringUtils.isEmpty((String)path)) continue;
                        String text = NodeStructureUtils.getLayoutDescription(r);
                        if (StringUtils.isEmpty((String)text)) {
                            text = path;
                        }
                        if (StringUtils.isEmpty((String)(qtip = NodeStructureUtils.getLayoutQtip(r)))) {
                            qtip = text;
                        }
                        JSONObject respObj = new JSONObject();
                        respObj.put(TEXT, (Object)text);
                        respObj.put(VALUE, (Object)path);
                        respObj.put("qtip", (Object)qtip);
                        response.put((Object)respObj);
                    }
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    public JSONObject queryFragFinder(String formType, String resourceType, Map<String, String> options) {
        String[] searchPathsForFragments = new String[10];
        ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
        String QUERY = "query";
        String START = "start";
        String LIMIT = "limit";
        String QUERY_LANG = "xpath";
        String QUERY_ROOT = "/jcr:root";
        String QUERY_ELEMENT_TYPE = "//element(*, dam:Asset)";
        String SORT_BY_LAST_MODIFIED = " order by jcr:content/@jcr:lastModified descending";
        String TYPE_PREDICATE = "jcr:content/metadata/@formmodel=";
        String TAG_PREDICATE = "jcr:content/metadata/@cq:tags=";
        String FORM_PREDICATE = "jcr:content/@type='" + formType + "'";
        String ASSET_TYPE_NONE = "'none'";
        String ASSET_TYPE_XSD = "'xmlschema'";
        String ASSET_TYPE_JSON = "'jsonschema'";
        String ASSET_TYPE_SCHEMA = "'schema'";
        String ASSET_TYPE_FORM_DATA_MODEL = "'formdatamodel'";
        String ASSET_TYPE_XFA = "'formtemplates'";
        try {
            JSONArray fragRefs = new JSONArray();
            String nameOrTitle = options.get("query");
            String alreadySentNodesString = options.get("start");
            String filterPath = options.get("filterPath");
            String maxLimitToSendString = options.get("limit");
            ArrayList<String> typePredicates = new ArrayList<String>();
            ArrayList<String> tagPredicates = new ArrayList<String>();
            String assetTypeParam = options.get("assetType");
            String tagParam = options.get("tags");
            String afVersion = options.get("afVersion");
            String combinedTypePredicates = "";
            if (StringUtils.isNotBlank((String)assetTypeParam)) {
                for (String assetType : StringUtils.remove((String)assetTypeParam, (char)' ').split(",")) {
                    String filterType = null;
                    switch (assetType) {
                        case "none": {
                            filterType = "'none'";
                            break;
                        }
                        case "xfa": {
                            filterType = "'formtemplates'";
                            break;
                        }
                        case "schema": {
                            filterType = "'schema'";
                            break;
                        }
                        case "formdatamodel": {
                            filterType = "'formdatamodel'";
                        }
                    }
                    if (filterType == null) continue;
                    if (filterType.equals("'schema'")) {
                        typePredicates.add("jcr:content/metadata/@formmodel='xmlschema'");
                        typePredicates.add("jcr:content/metadata/@formmodel='jsonschema'");
                        continue;
                    }
                    typePredicates.add("jcr:content/metadata/@formmodel=" + filterType);
                }
            }
            if (StringUtils.isNotBlank((String)tagParam)) {
                for (String tag : StringUtils.remove((String)tagParam, (char)' ').split(",")) {
                    tagPredicates.add("jcr:content/metadata/@cq:tags='" + tag + "'");
                }
            }
            if (typePredicates.size() > 0) {
                combinedTypePredicates = combinedTypePredicates + " and ( " + StringUtils.join(typePredicates, (String)" or ") + " )";
            }
            if (tagPredicates.size() > 0) {
                combinedTypePredicates = combinedTypePredicates + " and ( " + StringUtils.join(tagPredicates, (String)" or ") + " )";
            }
            searchPathsForFragments[0] = StringUtils.isNotBlank((String)filterPath) ? filterPath : "/content/dam/formsanddocuments";
            for (String searchPathsForFragment : searchPathsForFragments) {
                String query = "/jcr:root" + searchPathsForFragment + "//element(*, dam:Asset)" + "[" + FORM_PREDICATE + combinedTypePredicates + "]" + " order by jcr:content/@jcr:lastModified descending";
                Iterator fragmentNodes = resolver.findResources(query, "xpath");
                int alreadySentNodes = -1;
                int maxLimitToSend = -1;
                int nodesLeft = -1;
                if (maxLimitToSendString != null && maxLimitToSendString.length() > 0) {
                    maxLimitToSend = Integer.parseInt(maxLimitToSendString);
                }
                if (alreadySentNodesString != null && alreadySentNodesString.length() > 0) {
                    alreadySentNodes = Integer.parseInt(alreadySentNodesString);
                    nodesLeft = maxLimitToSend - alreadySentNodes;
                }
                if (fragmentNodes == null) continue;
                if (alreadySentNodes != -1) {
                    for (int node = 0; node < alreadySentNodes; ++node) {
                        if (!fragmentNodes.hasNext()) continue;
                        fragmentNodes.next();
                    }
                }
                while (fragmentNodes.hasNext() && (nodesLeft == -1 || nodesLeft-- != 0)) {
                    Resource r = (Resource)fragmentNodes.next();
                    ValueMap properties = r.getChild("jcr:content").getChild("metadata").getValueMap();
                    boolean titleOrNameMatches = false;
                    if (nameOrTitle != null && nameOrTitle.length() > 0) {
                        boolean bl = titleOrNameMatches = StringUtils.containsIgnoreCase((String)((String)properties.get((Object)"name")), (String)nameOrTitle) || StringUtils.containsIgnoreCase((String)((String)properties.get((Object)"title")), (String)nameOrTitle);
                    }
                    if (nameOrTitle != null && !nameOrTitle.isEmpty() && !titleOrNameMatches || (!"1".equals(afVersion) || properties.get((Object)"fd:version") != null && GuideUtils.isCoreComponentBasedForm(properties)) && (!GuideUtils.isCoreComponentBasedForm(properties) || !"2".equals(afVersion))) continue;
                    JSONObject fragObj = new JSONObject();
                    String name = (String)properties.get("title", (Object)"");
                    if (name.length() == 0) {
                        name = r.getName();
                    }
                    String resourcePath = r.getPath();
                    String imageRef = resourcePath + "/jcr:content" + "/renditions/cq5dam.thumbnail.319.319.png";
                    String fragRef = resourcePath;
                    fragRef = StringUtils.substringBefore((String)fragRef, (String)"/jcr:content");
                    fragObj.put("name", (Object)name);
                    fragObj.put("jcr:primaryType", (Object)"nt:unstructured");
                    fragObj.put("sling:resourceType", (Object)resourceType);
                    Resource componentResource = resolver.getResource(resourceType);
                    fragObj.put(COMPONENT_PATH, (Object)componentResource.getPath());
                    fragObj.put("image", (Object)imageRef);
                    fragObj.put("path", (Object)fragRef);
                    fragRefs.put((Object)fragObj);
                }
            }
            JSONObject response = new JSONObject();
            response.put("fragRefs", (Object)fragRefs);
            return response;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONArray queryLayout(String[] searchPaths, Map<String, String> options, SlingHttpServletRequest request) {
        JSONArray response = new JSONArray();
        String layoutType = "";
        String isAfField = "";
        if (options.get("layoutType") != null && options.get("layoutType").length() > 0) {
            layoutType = options.get("layoutType");
            isAfField = options.get("isAfField");
        }
        if (layoutType.length() > 0) {
            try {
                if ("fd/af/layouts/field".equals(layoutType)) {
                    JSONObject firstObj = new JSONObject();
                    firstObj.put(TEXT, (Object)"");
                    firstObj.put(VALUE, (Object)"");
                    response.put((Object)firstObj);
                }
                ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
                ArrayList<String> listOfLayouts = new ArrayList<String>();
                for (int i = 0; i < searchPaths.length; ++i) {
                    String query = "SELECT * FROM nt:base WHERE guideComponentType='" + layoutType + "' AND jcr:path LIKE '" + searchPaths[i] + "%'";
                    Iterator layouts = resolver.findResources(query, "sql");
                    if (layouts == null) continue;
                    while (layouts.hasNext()) {
                        Resource r = (Resource)layouts.next();
                        String path = r.getPath();
                        if (path.startsWith("/libs/") || path.startsWith("/apps/")) {
                            path = path.substring(6);
                        }
                        String desc = NodeStructureUtils.getLayoutDescription(r);
                        if (listOfLayouts.contains(path)) continue;
                        JSONObject respObj = new JSONObject();
                        if ("fd/af/layouts/panel".equals(layoutType)) {
                            respObj.put("guideNavigatorTab", (Object)NodeStructureUtils.getGuideNavigatorTabProperty(r));
                        }
                        I18n i18n = new I18n(request.getResourceBundle(new Locale(request.getLocale().getLanguage())));
                        desc = "true".equals(isAfField) && path != null && path.indexOf("defaultFieldLayout") > 0 ? i18n.get("Inherit From Adaptive Form Configuration") : desc;
                        respObj.put(TEXT, (Object)(desc == null ? r.getPath() : desc));
                        String qtip = NodeStructureUtils.getLayoutQtip(r);
                        respObj.put(VALUE, (Object)path);
                        if ("fd/af/layouts/field".equals(layoutType)) {
                            XSSAPI xssapi = (XSSAPI)request.adaptTo(XSSAPI.class);
                            qtip = GuideUtils.encodeForHtml(qtip, xssapi);
                        }
                        respObj.put("qtip", (Object)qtip);
                        Resource graniteData = r.getChild(GRANITE_DATA);
                        JSONObject graniteDataJson = null;
                        if (graniteData != null) {
                            graniteDataJson = new JSONObject((Map)graniteData.getValueMap());
                        } else {
                            graniteDataJson = new JSONObject();
                            if (r.getValueMap().get((Object)"guideNavigatorTab") != null) {
                                graniteDataJson.put("guideNavigatorTab", r.getValueMap().get("guideNavigatorTab", (Object)"tab"));
                            }
                            if (r.getValueMap().get((Object)"nonNavigable") != null) {
                                graniteDataJson.put("nonNavigable", r.getValueMap().get("nonNavigable", (Object)false));
                            }
                            if (r.getValueMap().get((Object)"enableLayoutOptimization") != null) {
                                graniteDataJson.put("enableLayoutOptimization", r.getValueMap().get("enableLayoutOptimization", (Object)false));
                            }
                        }
                        respObj.put(GRANITE_DATA, (Object)graniteDataJson);
                        listOfLayouts.add(path);
                        response.put((Object)respObj);
                    }
                }
            }
            catch (JSONException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new GuideException((Exception)((Object)e));
            }
        } else {
            this.logger.warn("Request did not have layout type mentioned.So, not returning any layout types");
        }
        return response;
    }

    public JSONArray getBeforePaginationList(SlingHttpServletRequest request, I18n i18n) {
        String[] paginationList = DoRConstants.PAGINATION_BREAK_BEFORE_PROPERTIES;
        return this.evaluatePagination(request, paginationList, i18n);
    }

    public JSONArray getAfterPaginationList(SlingHttpServletRequest request, I18n i18n) {
        String[] paginationList = DoRConstants.PAGINATION_BREAK_AFTER_PROPERTIES;
        return this.evaluatePagination(request, paginationList, i18n);
    }

    public JSONArray getOverflowPaginationList(SlingHttpServletRequest request, I18n i18n) {
        String[] paginationList = DoRConstants.PAGINATION_OVERFLOW_PROPERTIES;
        return this.evaluatePagination(request, paginationList, i18n);
    }

    private JSONArray evaluatePagination(SlingHttpServletRequest request, String[] paginationList, I18n i18n) {
        JSONArray jsonArrResponse = new JSONArray();
        try {
            String[] paginationWithChilds = DoRConstants.PAGINATION_WITH_CHILD_PROPERTIES;
            if (StringUtils.isNotEmpty((String)request.getRequestPathInfo().getSuffix()) && Arrays.asList(paginationWithChilds).contains(request.getRequestPathInfo().getSuffix().substring(1))) {
                return this.getChildPaginationList(request, request.getRequestPathInfo().getSuffix().substring(1));
            }
            for (int i = 0; i < paginationList.length; ++i) {
                JSONObject a = new JSONObject();
                a.put(TEXT, (Object)GuidePropertyProviderUtils.translateVar(paginationList[i], i18n));
                a.put(VALUE, (Object)paginationList[i]);
                if (Arrays.asList(paginationWithChilds).contains(paginationList[i])) {
                    a.put("hasChild", true);
                }
                jsonArrResponse.put(i, (Object)a);
            }
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return jsonArrResponse;
    }

    private static String translateVar(String text, I18n i18n) {
        return i18n != null ? i18n.getVar(text) : text;
    }

    public JSONArray getChildPaginationList(SlingHttpServletRequest request, String areaType) {
        JSONArray jsonArrResponse = new JSONArray();
        try {
            Resource resource = request.getResourceResolver().getResource(request.getParameter("resourcePath"));
            String guideContainerPath = GuideUtils.getGuideContainerPath(request, resource);
            String metaTemplateRef = null;
            if (StringUtils.isNotEmpty((String)guideContainerPath)) {
                Resource resource1 = request.getResourceResolver().getResource(guideContainerPath);
                metaTemplateRef = GuideContainer.from(resource1).getMetaTemplateRef();
            }
            Map list = this.paginationService.getPageAndContentAreaList(request.getResourceResolver(), metaTemplateRef);
            String[] pageArea = DoRConstants.PAGINATION_PAGE_AREA_PROPERTIES;
            JSONArray areaArray = Arrays.asList(pageArea).contains(areaType) ? new JSONArray((Collection)list.get("masterPages")) : new JSONArray((Collection)list.get("contentAreas"));
            for (int i = 0; i < areaArray.length(); ++i) {
                JSONObject a = new JSONObject();
                a.put(TEXT, areaArray.get(i));
                a.put(VALUE, (Object)(areaType + "  \"" + areaArray.get(i) + "\""));
                jsonArrResponse.put(i, (Object)a);
            }
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
        return jsonArrResponse;
    }

    public JSONArray queryPrefillServiceProviders() {
        JSONArray result = new JSONArray();
        try {
            JSONObject firstObj = new JSONObject();
            firstObj.put(TEXT, (Object)"");
            firstObj.put(VALUE, (Object)"");
            firstObj.put("qtip", (Object)"");
            result.put((Object)firstObj);
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            FormMetaData formMetaData = (FormMetaData)resolver.adaptTo(FormMetaData.class);
            if (formMetaData != null) {
                Iterator<FormsManager.ComponentDescription> prefillServices = formMetaData.getPrefillActions();
                while (prefillServices.hasNext()) {
                    FormsManager.ComponentDescription prefillService = prefillServices.next();
                    if (!StringUtils.isNotBlank((String)prefillService.getResourceType())) continue;
                    JSONObject obj = new JSONObject();
                    obj.put(TEXT, (Object)prefillService.getTitle());
                    obj.put(VALUE, (Object)prefillService.getResourceType());
                    obj.put("qtip", (Object)prefillService.getTitle());
                    result.put((Object)obj);
                }
            }
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
        return result;
    }

    public JSONArray queryTheme() {
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            String[] searchPathsForThemes = new String[]{"/content/dam/formsanddocuments-themes"};
            JSONArray response = new JSONArray();
            JSONObject firstObj = new JSONObject();
            firstObj.put(TEXT, (Object)"");
            firstObj.put(VALUE, (Object)"");
            firstObj.put("name", (Object)"");
            response.put((Object)firstObj);
            for (int i = 0; i < searchPathsForThemes.length; ++i) {
                Iterator themes = resolver.findResources("SELECT * FROM [dam:Asset] as t WHERE ISDESCENDANTNODE(t, '" + searchPathsForThemes[i] + "')", JCR_SQL2);
                if (themes == null) continue;
                while (themes.hasNext()) {
                    Resource r = (Resource)themes.next();
                    Resource metadataResource = r.getChild(DAM_METADATA);
                    Node node = (Node)metadataResource.adaptTo(Node.class);
                    try {
                        Node themeNode = node.getParent().getParent();
                        String themeName = node.hasProperty(TITLE) ? node.getProperty(TITLE).getString() : themeNode.getName();
                        String themeNodePath = themeNode.getPath();
                        JSONObject respObj = new JSONObject();
                        respObj.put(TEXT, (Object)themeName);
                        respObj.put(VALUE, (Object)themeNodePath);
                        respObj.put("name", (Object)themeName);
                        response.put((Object)respObj);
                    }
                    catch (RepositoryException e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        throw new GuideException((Exception)((Object)e));
                    }
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    public JSONArray queryAction(String[] searchPaths) {
        try {
            JSONArray response = new JSONArray();
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            FormMetaData formMetaData = (FormMetaData)resolver.adaptTo(FormMetaData.class);
            if (formMetaData != null) {
                Iterator actions = formMetaData.getActions();
                while (actions.hasNext()) {
                    FormsManager.ComponentDescription action = (FormsManager.ComponentDescription)actions.next();
                    Resource actionResource = resolver.getResource(action.getResourceType());
                    JSONObject respObj = new JSONObject();
                    respObj.put(TEXT, (Object)action.getTitle());
                    respObj.put(VALUE, (Object)action.getResourceType());
                    respObj.put("name", (Object)actionResource.getName());
                    respObj.put("path", (Object)actionResource.getPath());
                    if (actionResource.getResourceSuperType() != null) {
                        respObj.put("sling:resourceSuperType", (Object)actionResource.getResourceSuperType());
                    }
                    respObj.put("templatePath", (Object)this.getComponentTemplatePath(actionResource));
                    response.put((Object)respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    public JSONArray queryProgressiveStrategies(String[] searchPaths) {
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            for (String searchPath : searchPaths) {
                Iterator services = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = '/libs/fd/af/components/progressiveDataCapture' AND jcr:path LIKE '" + searchPath + "%'", "sql");
                if (services == null) continue;
                while (services.hasNext()) {
                    Resource r = (Resource)services.next();
                    String value = r.getPath();
                    ValueMap properties = r.getValueMap();
                    String displayName = NodeStructureUtils.getLayoutDescription(r);
                    String strategyName = (String)properties.get("strategyName", (Object)"");
                    JSONObject respObj = new JSONObject();
                    respObj.put(TEXT, (Object)displayName);
                    respObj.put("qtip", (Object)displayName);
                    respObj.put(VALUE, (Object)value);
                    respObj.put("strategyName", (Object)strategyName);
                    respObj.put("type", (Object)"service");
                    response.put((Object)respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    public JSONArray queryProgressiveLayout(String[] searchPaths) {
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            for (int i = 0; i < searchPaths.length; ++i) {
                Iterator layouts = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/af/layouts/progressive' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                if (layouts == null) continue;
                while (layouts.hasNext()) {
                    Resource r = (Resource)layouts.next();
                    String desc = NodeStructureUtils.getLayoutDescription(r);
                    JSONObject respObj = new JSONObject();
                    respObj.put(TEXT, (Object)(desc == null ? r.getPath() : desc));
                    String qtip = NodeStructureUtils.getLayoutQtip(r);
                    respObj.put("qtip", (Object)qtip);
                    String path = r.getPath();
                    respObj.put(VALUE, (Object)(path + "/layout.html"));
                    response.put((Object)respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    public JSONArray queryValidators(String guideNodeClass, String[] searchPaths) {
        return this.queryType(guideNodeClass, searchPaths, "validator");
    }

    public JSONArray queryFormatters(String guideNodeClass, String[] searchPaths) {
        return this.queryType(guideNodeClass, searchPaths, "formatter");
    }

    private JSONArray queryType(String guideNodeClass, String[] searchPaths, String type) {
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            JSONObject firstObj = new JSONObject();
            if (!GuideUtils.listContains(GuideConstants.GUIDE_HTML5_INPUT_TYPES, guideNodeClass, Boolean.TRUE).booleanValue()) {
                firstObj.put(TEXT, (Object)"Select");
                firstObj.put(VALUE, (Object)"");
            } else {
                firstObj.put(TEXT, (Object)"Default");
                firstObj.put(VALUE, (Object)GuideUtils.getDefaultPattern(guideNodeClass));
            }
            response.put((Object)firstObj);
            if (guideNodeClass != null && !guideNodeClass.isEmpty() && (GuideUtils.listContains(GuideConstants.GUIDE_FIELDS_CLASS_NAMES, guideNodeClass, Boolean.TRUE).booleanValue() || GuideUtils.listContains(GuideConstants.GUIDE_HTML5_INPUT_TYPES, guideNodeClass, Boolean.TRUE).booleanValue())) {
                for (int i = 0; i < searchPaths.length; ++i) {
                    Resource format;
                    String query = "SELECT * FROM nt:base WHERE guideComponentType= 'fd/af/components/" + type + "/" + guideNodeClass + "' AND jcr:path LIKE '" + searchPaths[i] + "%'";
                    Iterator formats = resolver.findResources(query, "sql");
                    if (!formats.hasNext() || (format = (Resource)formats.next()) == null) continue;
                    ValueMap properties = format.getValueMap();
                    for (Map.Entry pairs : properties.entrySet()) {
                        String key = (String)pairs.getKey();
                        if (!key.startsWith("pattern")) continue;
                        JSONObject respObj = new JSONObject();
                        String value = (String)pairs.getValue();
                        String[] arr = value.split("=", 2);
                        respObj.put(TEXT, (Object)arr[0]);
                        respObj.put(VALUE, (Object)arr[1]);
                        response.put((Object)respObj);
                    }
                }
            }
            JSONObject lastObj = new JSONObject();
            lastObj.put(TEXT, (Object)"Custom");
            lastObj.put(VALUE, (Object)"custom");
            response.put((Object)lastObj);
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    public JSONArray queryCaptchaService(String[] searchPaths) {
        String guideComponentType = "fd/af/components/guideCaptchaServiceType";
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            ArrayList<String> listOfCaptchaServices = new ArrayList<String>();
            JSONArray response = new JSONArray();
            for (String searchPath : searchPaths) {
                Iterator actions = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = '" + guideComponentType + "' AND jcr:path LIKE '" + searchPath + "%'", "sql");
                if (actions == null) continue;
                while (actions.hasNext()) {
                    Resource r = (Resource)actions.next();
                    String value = r.getPath();
                    if (value.startsWith("/libs/") || value.startsWith("/apps/")) {
                        value = value.substring(6);
                    }
                    ValueMap properties = r.getValueMap();
                    String text = (String)properties.get("jcr:description", (Object)"");
                    Resource graniteData = r.getChild(GRANITE_DATA);
                    JSONObject graniteDataJson = null;
                    String captchaServiceProvider = "";
                    if (graniteData == null) continue;
                    graniteDataJson = new JSONObject((Map)graniteData.getValueMap());
                    try {
                        captchaServiceProvider = (String)graniteDataJson.get("captcha.service.provider");
                    }
                    catch (Exception e) {
                        this.logger.error("captcha.service.provider property not found for " + r.getPath() + ". skipping this.", (Throwable)e);
                    }
                    if (StringUtils.isEmpty((String)captchaServiceProvider) || listOfCaptchaServices.contains(value)) continue;
                    JSONObject respObj = new JSONObject();
                    respObj.put(TEXT, (Object)text);
                    listOfCaptchaServices.add(value);
                    respObj.put(VALUE, (Object)captchaServiceProvider);
                    graniteDataJson.put("captcha-path", (Object)value);
                    respObj.put(GRANITE_DATA, (Object)graniteDataJson);
                    response.put((Object)respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            throw new GuideException((Exception)((Object)e));
        }
    }

    public JSONArray querySubmitOrAutoSaveAction(String[] searchPaths, Map<String, String> options) {
        String type = options.get("type");
        String requestedDataModel = options.get("guideDataModel");
        try {
            ArrayList<String> listOfSubmitAction = new ArrayList<String>();
            JSONArray response = new JSONArray();
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            FormMetaData formMetaData = (FormMetaData)resolver.adaptTo(FormMetaData.class);
            if (formMetaData != null) {
                Iterator<FormsManager.ComponentDescription> submitOrSaveActions = null;
                submitOrSaveActions = type.equalsIgnoreCase(SUBMITACTION) ? formMetaData.getSubmitActions() : formMetaData.getAutoSaveActions();
                while (submitOrSaveActions.hasNext()) {
                    FormsManager.ComponentDescription action = submitOrSaveActions.next();
                    Resource actionResource = resolver.getResource(action.getResourceType());
                    ValueMap properties = actionResource.getValueMap();
                    Resource graniteData = actionResource.getChild(GRANITE_DATA);
                    JSONObject graniteDataJson = new JSONObject();
                    String submitService = (String)properties.get("submitService", (Object)"");
                    if (graniteData != null) {
                        graniteDataJson = new JSONObject((Map)graniteData.getValueMap());
                    }
                    graniteDataJson.append("submitService", (Object)submitService);
                    Boolean addOption = true;
                    if (requestedDataModel != null) {
                        String dataModel = (String)properties.get("guideDataModel", (Object)"");
                        addOption = dataModel.toLowerCase().contains(requestedDataModel.toLowerCase()) ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (!addOption.booleanValue() || listOfSubmitAction.contains(action.getResourceType())) continue;
                    JSONObject respObj = new JSONObject();
                    respObj.put(TEXT, (Object)action.getTitle());
                    listOfSubmitAction.add(action.getResourceType());
                    respObj.put(VALUE, (Object)action.getResourceType());
                    if (graniteDataJson != null) {
                        respObj.put(GRANITE_DATA, (Object)graniteDataJson);
                    }
                    respObj.put("qtip", (Object)action.getHint());
                    response.put((Object)respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    public JSONArray queryLcProcess() {
        try {
            JSONArray response = new JSONArray();
            List<String> services = this.guideLCServiceConnector.getServices();
            for (String s : services) {
                JSONObject respObj = new JSONObject();
                respObj.put(TEXT, (Object)s);
                respObj.put(VALUE, (Object)s);
                response.put((Object)respObj);
            }
            return response;
        }
        catch (Exception e) {
            this.logger.error("Cannot fetch LCServices", (Throwable)e);
            throw new GuideException(e);
        }
    }

    public JSONArray queryMobileLayout(String[] searchPaths) {
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            ArrayList<String> listOfMobileLayoutPath = new ArrayList<String>();
            for (int i = 0; i < searchPaths.length; ++i) {
                Iterator layouts = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/af/layouts/mobile' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                if (layouts == null) continue;
                while (layouts.hasNext()) {
                    Resource r = (Resource)layouts.next();
                    String path = r.getPath();
                    String desc = NodeStructureUtils.getLayoutDescription(r);
                    if (path.startsWith("/libs/") || path.startsWith("/apps/")) {
                        path = path.substring(6);
                    }
                    if (listOfMobileLayoutPath.contains(path)) continue;
                    JSONObject respObj = new JSONObject();
                    respObj.put(TEXT, (Object)(desc == null ? r.getPath() : desc));
                    String qtip = NodeStructureUtils.getLayoutQtip(r);
                    respObj.put("qtip", (Object)qtip);
                    listOfMobileLayoutPath.add(path);
                    respObj.put(VALUE, (Object)path);
                    response.put((Object)respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    public JSONArray queryChartReducer(String[] searchPaths) {
        JSONArray response = new JSONArray();
        try {
            JSONObject firstObj = new JSONObject();
            firstObj.put(TEXT, (Object)"None");
            firstObj.put(VALUE, (Object)"none");
            firstObj.put("qtip", (Object)"None");
            response.put((Object)firstObj);
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            for (int i = 0; i < searchPaths.length; ++i) {
                Iterator reducerFunctions = resolver.findResources("SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/af/reducer' AND jcr:path LIKE '" + searchPaths[i] + "%'", "sql");
                if (reducerFunctions == null) continue;
                while (reducerFunctions.hasNext()) {
                    String qtip;
                    Resource r = (Resource)reducerFunctions.next();
                    ValueMap properties = r.getValueMap();
                    String val = (String)properties.get((Object)VALUE);
                    if (StringUtils.isEmpty((String)val)) continue;
                    String text = NodeStructureUtils.getLayoutDescription(r);
                    if (StringUtils.isEmpty((String)text)) {
                        text = val;
                    }
                    if (StringUtils.isEmpty((String)(qtip = NodeStructureUtils.getLayoutQtip(r)))) {
                        qtip = text;
                    }
                    JSONObject respObj = new JSONObject();
                    respObj.put(TEXT, (Object)text);
                    respObj.put(VALUE, (Object)val);
                    respObj.put("qtip", (Object)qtip);
                    response.put((Object)respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    public JSONArray fetchRecaptchaCloudServiceConfiguration(Resource captchaResource) {
        JSONArray response = new JSONArray();
        try {
            Collection cloudConfigs = this.reCaptchaConfigurationService.getConfigurationCollection(captchaResource);
            Iterator iterator = cloudConfigs.iterator();
            JSONObject emptyObject = new JSONObject();
            emptyObject.put(TEXT, (Object)"");
            emptyObject.put(VALUE, (Object)"");
            response.put((Object)emptyObject);
            while (iterator.hasNext()) {
                ReCaptchaConfiguration reCaptchaConfiguration = (ReCaptchaConfiguration)iterator.next();
                JSONObject responseObject = new JSONObject();
                responseObject.put(TEXT, (Object)(StringUtils.isNotEmpty((String)reCaptchaConfiguration.title()) ? reCaptchaConfiguration.title() : reCaptchaConfiguration.name()));
                responseObject.put(VALUE, (Object)reCaptchaConfiguration.name());
                responseObject.put("icon", (Object)reCaptchaConfiguration.thumbnailPath());
                responseObject.put(DESCRIPTION, (Object)reCaptchaConfiguration.description());
                JSONObject graniteDataJson = new JSONObject();
                graniteDataJson.put("version", (Object)reCaptchaConfiguration.version());
                graniteDataJson.put("key.type", (Object)reCaptchaConfiguration.keyType());
                responseObject.put(GRANITE_DATA, (Object)graniteDataJson);
                response.put((Object)responseObject);
            }
        }
        catch (Exception e) {
            this.logger.error(CLOUD_CONFIG_LISTING_ERROR, (Throwable)e);
        }
        return response;
    }

    public JSONArray fetchRecaptchaCloudServiceConfiguration(String rootPath, Resource captchaResource) {
        JSONArray configurations = new JSONArray();
        JSONArray responseFromConf = this.fetchRecaptchaCloudServiceConfiguration(captchaResource);
        JSONArray responseFromEtc = this.fetchRecaptchaCloudServiceConfiguration(rootPath);
        try {
            configurations = GuideUtils.getMergedJSONArray(responseFromConf, responseFromEtc);
        }
        catch (JSONException e) {
            this.logger.error("Error while retrieving recaptcha cloud configurations", (Throwable)e);
        }
        return configurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public JSONArray fetchRecaptchaCloudServiceConfiguration(String rootPath) {
        JSONArray response = new JSONArray();
        try (ResourceResolver serviceResourceResolver = null;){
            serviceResourceResolver = GuideUtils.getServiceResourceResolver(this.resourceResolverFactory);
            ConfigurationManager configManager = (ConfigurationManager)serviceResourceResolver.adaptTo(ConfigurationManager.class);
            if (rootPath != null) {
                com.day.cq.wcm.webservicesupport.Service service = configManager.getService(configManager.getServiceName(rootPath));
                Iterator iter = configManager.getConfigurations(rootPath);
                JSONObject graniteDataJson = null;
                HashMap<String, String> graniteMap = null;
                while (iter.hasNext()) {
                    Configuration cfg = (Configuration)iter.next();
                    graniteMap = new HashMap<String, String>();
                    graniteMap.put("site.key", this.reCaptchaConfigService.getSiteKey(cfg.getPath()));
                    graniteDataJson = new JSONObject(graniteMap);
                    Template template = cfg.getTemplate();
                    if (template == null || service == null || !service.isSelectableChild(template.getPath()).booleanValue()) continue;
                    String description = cfg.getDescription() != null ? cfg.getDescription() : template.getDescription();
                    JSONObject respObj = new JSONObject();
                    respObj.put(TEXT, (Object)cfg.getTitle());
                    respObj.put(VALUE, (Object)cfg.getPath());
                    respObj.put("icon", (Object)cfg.getIconPath());
                    respObj.put("description", (Object)description);
                    respObj.put(GRANITE_DATA, (Object)graniteDataJson);
                    response.put((Object)respObj);
                }
            } else {
                this.logger.warn("Missing parameter for 'rootPath'");
            }
        }
        return response;
    }

    public JSONArray fetchCoreRecaptchaCloudServiceConfiguration(Resource captchaResource) {
        JSONArray response = new JSONArray();
        ArrayList<String> recaptchaGroup = new ArrayList<String>();
        recaptchaGroup.add("recaptcha");
        try {
            Iterator cloudConfigsIterator = this.configurationResourceProvider.getResourceAwareCloudConfigs(captchaResource, recaptchaGroup, null);
            ArrayList<ReCaptchaConfigurationModel> adaptedCloudConfigs = new ArrayList<ReCaptchaConfigurationModel>();
            while (cloudConfigsIterator.hasNext()) {
                Resource resource = (Resource)cloudConfigsIterator.next();
                ReCaptchaConfigurationModel reCaptchaConfig = (ReCaptchaConfigurationModel)resource.adaptTo(ReCaptchaConfigurationModel.class);
                adaptedCloudConfigs.add(reCaptchaConfig);
            }
            Iterator iterator = adaptedCloudConfigs.iterator();
            JSONObject emptyObject = new JSONObject();
            emptyObject.put("text", (Object)"");
            emptyObject.put("value", (Object)"");
            response.put((Object)emptyObject);
            while (iterator.hasNext()) {
                ReCaptchaConfigurationModel reCaptchaConfiguration = (ReCaptchaConfigurationModel)iterator.next();
                JSONObject responseObject = new JSONObject();
                responseObject.put(TEXT, (Object)(StringUtils.isNotEmpty((String)reCaptchaConfiguration.title()) ? reCaptchaConfiguration.title() : reCaptchaConfiguration.name()));
                responseObject.put(VALUE, (Object)reCaptchaConfiguration.name());
                responseObject.put("icon", (Object)reCaptchaConfiguration.thumbnailPath());
                responseObject.put(DESCRIPTION, (Object)reCaptchaConfiguration.description());
                JSONObject graniteDataJson = new JSONObject();
                graniteDataJson.put("version", (Object)reCaptchaConfiguration.version());
                graniteDataJson.put("key.type", (Object)reCaptchaConfiguration.keyType());
                graniteDataJson.put("site.key", (Object)reCaptchaConfiguration.siteKey());
                responseObject.put(GRANITE_DATA, (Object)graniteDataJson);
                response.put((Object)responseObject);
            }
        }
        catch (Exception e) {
            this.logger.error(CLOUD_CONFIG_LISTING_ERROR, (Throwable)e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray fetchEsignCloudServiceConfigurations() {
        JSONArray response = new JSONArray();
        try (ResourceResolver serviceResourceResolver = null;){
            String[] echoSignGroup = new String[]{"echosign"};
            serviceResourceResolver = GuideUtils.getCloudServiceUserResourceResolver(this.resourceResolverFactory);
            Iterator iterator = this.configurationResourceProvider.getAllCloudConfigs(serviceResourceResolver, echoSignGroup);
            while (iterator.hasNext()) {
                Resource configuration = ((Resource)iterator.next()).getChild("jcr:content");
                ValueMap properties = configuration.getValueMap();
                JSONObject responseObject = new JSONObject();
                responseObject.put(TEXT, properties.get("jcr:title", properties.get("name", (Object)"")));
                responseObject.put(VALUE, (Object)configuration.getParent().getPath());
                responseObject.put("icon", properties.get("thumbnailPath", (Object)""));
                response.put((Object)responseObject);
            }
        }
        return response;
    }

    public JSONArray fetchEsignCloudServiceConfiguration(Resource guideContainer) {
        JSONArray response = new JSONArray();
        try {
            if (this.adobeSignConfigurationService != null) {
                List cloudConfigs = this.adobeSignConfigurationService.getConfigurationCollection(guideContainer);
                Iterator iterator = cloudConfigs.iterator();
                while (iterator.hasNext()) {
                    Resource configuration = ((Resource)iterator.next()).getChild("jcr:content");
                    ValueMap properties = configuration.getValueMap();
                    JSONObject responseObject = new JSONObject();
                    responseObject.put(TEXT, properties.get("jcr:title", properties.get("name", (Object)"")));
                    responseObject.put(VALUE, (Object)configuration.getParent().getPath());
                    responseObject.put("icon", properties.get("thumbnailPath", (Object)""));
                    response.put((Object)responseObject);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Unexpected error while listing cloud service configurations from /conf", (Throwable)e);
        }
        return response;
    }

    public JSONArray fetchEsignCloudServiceConfiguration(String rootPath, Resource guideContainer) {
        JSONArray configurations = new JSONArray();
        JSONArray responseFromConf = this.fetchEsignCloudServiceConfiguration(guideContainer);
        JSONArray responseFromEtc = this.fetchEsignCloudServiceConfiguration(rootPath);
        try {
            configurations = GuideUtils.getMergedJSONArray(responseFromConf, responseFromEtc);
        }
        catch (JSONException e) {
            this.logger.error("Error while retrieving Adobe Sign cloud configurations", (Throwable)e);
        }
        return configurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public JSONArray fetchEsignCloudServiceConfiguration(String rootPath) {
        JSONArray response = new JSONArray();
        try (ResourceResolver serviceResourceResolver = null;){
            serviceResourceResolver = GuideUtils.getServiceResourceResolver(this.resourceResolverFactory);
            ConfigurationManager configManager = (ConfigurationManager)serviceResourceResolver.adaptTo(ConfigurationManager.class);
            if (rootPath != null) {
                com.day.cq.wcm.webservicesupport.Service service = configManager.getService(configManager.getServiceName(rootPath));
                Iterator iter = configManager.getConfigurations(rootPath);
                while (iter.hasNext()) {
                    Configuration cfg = (Configuration)iter.next();
                    Template template = cfg.getTemplate();
                    if (template == null || service == null || !service.isSelectableChild(template.getPath()).booleanValue()) continue;
                    String description = cfg.getDescription() != null ? cfg.getDescription() : template.getDescription();
                    JSONObject respObj = new JSONObject();
                    respObj.put(TEXT, (Object)cfg.getTitle());
                    respObj.put(VALUE, (Object)cfg.getPath());
                    respObj.put("icon", (Object)cfg.getIconPath());
                    respObj.put("description", (Object)description);
                    response.put((Object)respObj);
                }
            } else {
                this.logger.warn("Missing parameter for 'rootPath'");
            }
        }
        return response;
    }

    private String getComponentTemplatePath(Resource componentResource) {
        try {
            Node componentNode = (Node)componentResource.adaptTo(Node.class);
            ValueMap componentProperties = (ValueMap)componentResource.adaptTo(ValueMap.class);
            String templatePath = (String)componentProperties.get((Object)"cq:templatePath");
            if (templatePath == null && componentNode.hasNode("cq:template")) {
                templatePath = componentNode.getNode("cq:template").getPath();
            }
            return templatePath;
        }
        catch (Exception e) {
            throw new GuideException(e);
        }
    }

    public Iterator<JSONObject> getJSONIterator(JSONArray arr) {
        return new JSONArrayIterator(arr);
    }

    public Map<String, Object> getMapFromJSONObject(JSONObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Object jsonObject = null;
        try {
            Iterator keys = object.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = object.get(key);
                if (value instanceof JSONObject) {
                    map.put(key, this.getMapFromJSONObject((JSONObject)value));
                    continue;
                }
                if (value instanceof JSONArray) {
                    JSONArray array = (JSONArray)value;
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < array.length(); ++i) {
                        jsonObject = array.get(i);
                        if (jsonObject instanceof JSONObject) {
                            list.add(this.getMapFromJSONObject((JSONObject)jsonObject));
                            continue;
                        }
                        list.add(jsonObject);
                    }
                    map.put(key, list);
                    continue;
                }
                map.put(key, value);
            }
            return map;
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
    }

    public JSONArray queryDocumentFragmentLayout(String[] searchPaths) {
        try {
            JSONArray response = new JSONArray();
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONObject firstObj = new JSONObject();
            firstObj.put(TEXT, (Object)"");
            firstObj.put(VALUE, (Object)"");
            response.put((Object)firstObj);
            for (int i = 0; i < searchPaths.length; ++i) {
                String query = "SELECT *  FROM nt:base  WHERE guideComponentType = 'fd/adaddon/documentFragmentLayout' AND jcr:path LIKE '" + searchPaths[i] + "%'";
                Iterator layouts = resolver.findResources(query, "sql");
                if (layouts == null) continue;
                while (layouts.hasNext()) {
                    Resource r = (Resource)layouts.next();
                    ValueMap properties = r.getValueMap();
                    String desc = NodeStructureUtils.getLayoutDescription(r);
                    JSONObject respObj = new JSONObject();
                    respObj.put(TEXT, (Object)(desc == null ? r.getPath() : desc));
                    respObj.put(VALUE, properties.get("layout", (Object)""));
                    response.put((Object)respObj);
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    public JSONArray fetchTypekitCloudServiceConfiguration(SlingHttpServletRequest slingRequest) {
        JSONArray response = new JSONArray();
        I18n i18n = new I18n(slingRequest.getResourceBundle(slingRequest.getLocale()));
        ResourceResolver resourceResolver = this.resourceResolverHelper.getResourceResolver();
        if (resourceResolver == null) {
            this.logger.error("Null value returned by resourcResolverHelper.getResourceResolver. See Documentation of ResourceResolverHelper for debugging.");
            return response;
        }
        Resource theme = resourceResolver.getResource(slingRequest.getParameter("item"));
        try {
            response.put((Object)new JSONObject().put("text", (Object)i18n.get("Select")).put(VALUE, (Object)""));
            GuideThemeUtils.addTypekitConfigurations(response, theme, resourceResolver, this.typekitConfigurationService);
        }
        catch (JSONException e) {
            this.logger.error("JsonException while creating JSON from list of Adobe Fonts configurations.", (Throwable)e);
            return response;
        }
        return response;
    }

    public JSONArray queryFormModelSchema(SlingHttpServletRequest request) {
        String QUERY = GuideUtils.isCoreComponentBasedForm(request.getRequestPathInfo().getSuffixResource()) ? "SELECT * FROM [dam:Asset] as t WHERE ISDESCENDANTNODE(t, '/content/dam/formsanddocuments') AND (NAME() LIKE '%.schema.json')" : "SELECT * FROM [dam:Asset] as t WHERE ISDESCENDANTNODE(t, '/content/dam/formsanddocuments') AND (NAME() LIKE '%.schema.json' OR NAME() LIKE '%.xsd')";
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            JSONObject firstObj = new JSONObject();
            Resource resource = request.getResource();
            Config cfg = new Config(resource);
            String name = "./schemaType";
            Value val = new Value(request, cfg);
            String value = val.get(name);
            if (StringUtils.isEmpty((String)value) || "formdatamodel".equals(value)) {
                firstObj.put("text", (Object)"");
                firstObj.put(VALUE, (Object)"");
                firstObj.put("name", (Object)"");
                response.put((Object)firstObj);
            }
            Iterator schemaIterator = resolver.findResources(QUERY, JCR_SQL2);
            while (schemaIterator.hasNext()) {
                Node node;
                Resource schemaResource = (Resource)schemaIterator.next();
                Resource metadataResource = schemaResource.getChild(DAM_METADATA);
                if (metadataResource == null || (node = (Node)metadataResource.adaptTo(Node.class)) == null) continue;
                try {
                    Node schemaNode = node.getParent().getParent();
                    String schemaName = node.hasProperty(TITLE) ? node.getProperty(TITLE).getString() : schemaNode.getName();
                    String schemaNodePath = schemaNode.getPath();
                    JSONObject respObj = new JSONObject();
                    respObj.put("text", (Object)schemaName);
                    respObj.put(VALUE, (Object)schemaNodePath);
                    respObj.put("name", (Object)schemaName);
                    response.put((Object)respObj);
                }
                catch (RepositoryException e) {
                    this.logger.error("[AF] Exception occurred while querying for Form Schema: " + e.getMessage(), (Throwable)e);
                    throw new GuideException((Exception)((Object)e));
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    public JSONArray queryFormDataModel(SlingHttpServletRequest request) {
        try {
            ResourceResolver resolver = this.resourceResolverHelper.getResourceResolver();
            JSONArray response = new JSONArray();
            JSONObject firstObj = new JSONObject();
            Resource resource = request.getResource();
            Config cfg = new Config(resource);
            String name = "./schemaType";
            Value val = new Value(request, cfg);
            String value = val.get(name);
            if (StringUtils.isEmpty((String)value) || !"formdatamodel".equals(value)) {
                firstObj.put("text", (Object)"");
                firstObj.put(VALUE, (Object)"");
                firstObj.put("name", (Object)"");
                response.put((Object)firstObj);
            }
            Iterator fdmIterator = resolver.findResources("SELECT * FROM [dam:Asset] as t WHERE ISDESCENDANTNODE(t, '/content/dam/formsanddocuments-fdm')", JCR_SQL2);
            while (fdmIterator.hasNext()) {
                Resource fdmResource = (Resource)fdmIterator.next();
                Resource metadataResource = fdmResource.getChild(DAM_METADATA);
                if (metadataResource == null) continue;
                Node node = (Node)metadataResource.adaptTo(Node.class);
                try {
                    if (node == null) continue;
                    Node fdmNode = node.getParent().getParent();
                    String fdmName = node.hasProperty(TITLE) ? node.getProperty(TITLE).getString() : fdmNode.getName();
                    String fdmNodePath = fdmNode.getPath();
                    JSONObject respObj = new JSONObject();
                    respObj.put("text", (Object)fdmName);
                    respObj.put(VALUE, (Object)fdmNodePath);
                    respObj.put("name", (Object)fdmName);
                    response.put((Object)respObj);
                }
                catch (RepositoryException e) {
                    this.logger.error("[AF] Exception occurred while querying for Form Data Model: " + e.getMessage(), (Throwable)e);
                    throw new GuideException((Exception)((Object)e));
                }
            }
            return response;
        }
        catch (JSONException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    protected void bindGuideLCServiceConnector(GuideLCServiceConnector guideLCServiceConnector) {
        this.guideLCServiceConnector = guideLCServiceConnector;
    }

    protected void unbindGuideLCServiceConnector(GuideLCServiceConnector guideLCServiceConnector) {
        if (this.guideLCServiceConnector == guideLCServiceConnector) {
            this.guideLCServiceConnector = null;
        }
    }

    protected void bindGuideProgressiveStrategyManager(GuideProgressiveStrategyManager guideProgressiveStrategyManager) {
        this.guideProgressiveStrategyManager = guideProgressiveStrategyManager;
    }

    protected void unbindGuideProgressiveStrategyManager(GuideProgressiveStrategyManager guideProgressiveStrategyManager) {
        if (this.guideProgressiveStrategyManager == guideProgressiveStrategyManager) {
            this.guideProgressiveStrategyManager = null;
        }
    }

    protected void bindFormDataModelService(FormDataModelService formDataModelService) {
        this.formDataModelService = formDataModelService;
    }

    protected void unbindFormDataModelService(FormDataModelService formDataModelService) {
        if (this.formDataModelService == formDataModelService) {
            this.formDataModelService = null;
        }
    }

    protected void bindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.htmlLibraryManager = htmlLibraryManager;
    }

    protected void unbindHtmlLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.htmlLibraryManager == htmlLibraryManager) {
            this.htmlLibraryManager = null;
        }
    }

    protected void bindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        this.resourceResolverHelper = resourceResolverHelper;
    }

    protected void unbindResourceResolverHelper(ResourceResolverHelper resourceResolverHelper) {
        if (this.resourceResolverHelper == resourceResolverHelper) {
            this.resourceResolverHelper = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindPrefillRegistry(FormDataProviderRegistry formDataProviderRegistry) {
        this.prefillRegistry = formDataProviderRegistry;
    }

    protected void unbindPrefillRegistry(FormDataProviderRegistry formDataProviderRegistry) {
        if (this.prefillRegistry == formDataProviderRegistry) {
            this.prefillRegistry = null;
        }
    }

    protected void bindPaginationService(PaginationService paginationService) {
        this.paginationService = paginationService;
    }

    protected void unbindPaginationService(PaginationService paginationService) {
        if (this.paginationService == paginationService) {
            this.paginationService = null;
        }
    }

    protected void bindReCaptchaConfigService(ReCaptchaConfigService reCaptchaConfigService) {
        this.reCaptchaConfigService = reCaptchaConfigService;
    }

    protected void unbindReCaptchaConfigService(ReCaptchaConfigService reCaptchaConfigService) {
        if (this.reCaptchaConfigService == reCaptchaConfigService) {
            this.reCaptchaConfigService = null;
        }
    }

    protected void bindReCaptchaConfigurationService(ReCaptchaConfigurationService reCaptchaConfigurationService) {
        this.reCaptchaConfigurationService = reCaptchaConfigurationService;
    }

    protected void unbindReCaptchaConfigurationService(ReCaptchaConfigurationService reCaptchaConfigurationService) {
        if (this.reCaptchaConfigurationService == reCaptchaConfigurationService) {
            this.reCaptchaConfigurationService = null;
        }
    }

    protected void bindTypekitConfigurationService(TypekitConfigurationService typekitConfigurationService) {
        this.typekitConfigurationService = typekitConfigurationService;
    }

    protected void unbindTypekitConfigurationService(TypekitConfigurationService typekitConfigurationService) {
        if (this.typekitConfigurationService == typekitConfigurationService) {
            this.typekitConfigurationService = null;
        }
    }

    protected void bindAdobeSignConfigurationService(AdobeSignConfigurationService adobeSignConfigurationService) {
        this.adobeSignConfigurationService = adobeSignConfigurationService;
    }

    protected void unbindAdobeSignConfigurationService(AdobeSignConfigurationService adobeSignConfigurationService) {
        if (this.adobeSignConfigurationService == adobeSignConfigurationService) {
            this.adobeSignConfigurationService = null;
        }
    }

    protected void bindConfigurationResourceProvider(ICloudConfigurationResourceProvider iCloudConfigurationResourceProvider) {
        this.configurationResourceProvider = iCloudConfigurationResourceProvider;
    }

    protected void unbindConfigurationResourceProvider(ICloudConfigurationResourceProvider iCloudConfigurationResourceProvider) {
        if (this.configurationResourceProvider == iCloudConfigurationResourceProvider) {
            this.configurationResourceProvider = null;
        }
    }
}

