/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.utils.GuideFragmentHolder;
import com.day.cq.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideContainerThreadLocal {
    private static final Logger logger = LoggerFactory.getLogger(GuideContainerThreadLocal.class);
    private static ThreadLocal<GuideFragmentHolder> tl = new ThreadLocal();
    private static ThreadLocal<String> guideContainerThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Boolean> submissionContextThreadLocal = new ThreadLocal();

    public static GuideFragmentHolder getGuideFragmentHolder() {
        return tl.get();
    }

    public static void setGuideFragmentHolder(String fragPrefixID, String bindRefPrefixForFragment, String fragmentModelRoot, I18n i18n) {
        GuideFragmentHolder guideFragmentHolder = new GuideFragmentHolder(fragPrefixID, bindRefPrefixForFragment, fragmentModelRoot, i18n);
        tl.set(guideFragmentHolder);
    }

    public static String getGuideContainerName() {
        String containerName = guideContainerThreadLocal.get();
        if (containerName != null && containerName.contains("/") && (containerName = containerName.substring(containerName.lastIndexOf("/") + 1)).contains(".")) {
            containerName = containerName.substring(0, containerName.lastIndexOf("."));
        }
        return containerName;
    }

    public static String getGuideContainerPath() {
        return guideContainerThreadLocal.get();
    }

    public static void setGuideContainerPath(String guideContainerPath) {
        guideContainerThreadLocal.set(guideContainerPath);
    }

    public static void setSubmissionContextFlag(Boolean value) {
        submissionContextThreadLocal.set(value);
    }

    public static Boolean getSubmissionContextFlag() {
        try {
            return submissionContextThreadLocal.get();
        }
        catch (Exception e) {
            logger.warn("Failed to get SubmissionContextFlag");
            return false;
        }
    }

    public static void removeSubmissionContext() {
        submissionContextThreadLocal.remove();
    }
}

