/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.dct.util;

import com.adobe.dct.exception.DCTException;
import com.adobe.dct.util.OSGIUtils;
import com.adobe.livecycle.content.sling.ResourceResolverHolder;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Dictionary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.osgi.service.cm.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFunctions {
    private static final Logger logger = LoggerFactory.getLogger(CustomFunctions.class);

    public static String getConfigProperty(String serviceName, String propertyName) throws IOException, DCTException {
        try {
            String cmUserRootPath = OSGIUtils.getCmUserRootPath();
            if (StringUtils.isNotBlank((String)cmUserRootPath)) {
                return cmUserRootPath;
            }
            Configuration[] config = OSGIUtils.getConfigurationAdmin().listConfigurations("(service.pid=com.adobe.icc.services.core.ACMConfigurationServiceImpl)");
            if ((config == null || config.length == 0) && propertyName.equals("acm.cmuserroot")) {
                return "/content/cmUserRoot";
            }
            Configuration configuration = OSGIUtils.getConfigurationAdmin().getConfiguration(serviceName);
            Dictionary dict = configuration.getProperties();
            Object propertyValue = dict.get(propertyName);
            if (propertyValue == null) {
                return "";
            }
            if (propertyValue instanceof String) {
                return (String)propertyValue;
            }
            throw new DCTException("ALC-DCT-003-018");
        }
        catch (Exception e) {
            logger.debug("Exception error due to interuption while getting configuration property.", (Throwable)e);
            return "";
        }
    }

    public static String getAgentId() {
        ResourceResolver resourceResolver = ResourceResolverHolder.getResourceResolver();
        String agentId = resourceResolver.getUserID();
        if (agentId.startsWith("lcu::")) {
            String[] agentIdParts = agentId.split("::");
            return agentIdParts[agentIdParts.length - 1];
        }
        return agentId;
    }

    public static String getAgentName() throws DCTException {
        String userName = "";
        try {
            ResourceResolver resourceResolver = ResourceResolverHolder.getResourceResolver();
            Session userSession = (Session)resourceResolver.adaptTo(Session.class);
            UserManager userManager = AccessControlUtil.getUserManager((Session)userSession);
            String userId = resourceResolver.getUserID();
            Authorizable authorizable = userManager.getAuthorizable(userId);
            if (authorizable instanceof User) {
                User user = (User)authorizable;
                userName = user.getPrincipal().getName();
            }
        }
        catch (Exception e) {
            throw new DCTException("ALC-DCT-003-018", e);
        }
        return userName;
    }

    public static String getUserProperty(String propertyName) throws DCTException {
        try {
            User user;
            Value[] propertyValues;
            ResourceResolver resourceResolver = ResourceResolverHolder.getResourceResolver();
            Session userSession = (Session)resourceResolver.adaptTo(Session.class);
            UserManager userManager = AccessControlUtil.getUserManager((Session)userSession);
            String userId = resourceResolver.getUserID();
            Authorizable authorizable = userManager.getAuthorizable(userId);
            if (authorizable instanceof User && (propertyValues = (user = (User)authorizable).getProperty(propertyName)) != null && propertyValues.length > 0) {
                return propertyValues[0].getString();
            }
        }
        catch (Exception e) {
            throw new DCTException("ALC-DCT-003-018", e);
        }
        return "";
    }

    public static byte[] getAgentSignatureImage(String serviceName, String propertyName) throws DCTException, IOException {
        String userId = CustomFunctions.getAgentId();
        String imageRootURI = CustomFunctions.getConfigProperty(serviceName, propertyName);
        byte[] imageContent = CustomFunctions.retrieveContentFromJCRRepository(imageRootURI + "/" + userId);
        if (imageContent == null) {
            logger.warn("Unable to fetch image content for user:" + userId);
            return new byte[0];
        }
        Base64 base64 = new Base64();
        imageContent = base64.encode(imageContent);
        return imageContent;
    }

    public static String getCurrentTimestamp() {
        return new Date().toString();
    }

    private static byte[] retrieveContentFromJCRRepository(String absPath) throws DCTException, IOException {
        if (absPath == null || absPath.trim().equals("")) {
            return null;
        }
        if (!CustomFunctions.nodeExists(absPath)) {
            return null;
        }
        if (CustomFunctions.isFolder(absPath)) {
            return null;
        }
        byte[] result = null;
        try {
            Session session = CustomFunctions.getSession();
            Node ntFileNode = session.getNode(absPath);
            Node ntResourceNode = ntFileNode.getNode("jcr:content");
            InputStream is = ntResourceNode.getProperty("jcr:data").getBinary().getStream();
            BufferedInputStream bin = new BufferedInputStream(is);
            result = IOUtils.toByteArray((InputStream)bin);
            bin.close();
            is.close();
        }
        catch (Exception ex) {
            logger.error("Error reading file from JCR Repository : " + ex.getCause().getMessage());
            throw new DCTException("ALC-DCT-003-018", ex);
        }
        return result;
    }

    private static Session getSession() throws RepositoryException {
        ResourceResolver resolver = ResourceResolverHolder.getResourceResolver();
        return (Session)resolver.adaptTo(Session.class);
    }

    public static boolean nodeExists(String absPath) throws DCTException {
        try {
            return CustomFunctions.getSession().nodeExists(absPath);
        }
        catch (RepositoryException ex) {
            logger.error("Error reading file from JCR Repository : " + ex.getCause().getMessage());
            throw new DCTException("ALC-DCT-003-018", ex);
        }
    }

    private static boolean isFolder(String absPath) throws DCTException {
        try {
            Node node = CustomFunctions.getSession().getNode(absPath);
            String defaultPrimaryTypeName = node.getPrimaryNodeType().getName();
            return "nt:folder".equals(defaultPrimaryTypeName);
        }
        catch (RepositoryException ex) {
            logger.error("Error reading file from JCR Repository :" + ex.getCause().getMessage());
            throw new DCTException("ALC-DCT-003-018", ex);
        }
    }
}

