/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.addon.dor;

import com.adobe.aemds.guide.addon.dor.DoROptions;
import com.adobe.aemds.guide.addon.dor.DoRThreadLocal;
import com.adobe.aemds.guide.addon.dor.GuideType;
import com.adobe.aemds.guide.addon.dor.MetaTemplate;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.forms.common.service.DoRTemplateParsingException;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import com.adobe.forms.common.submitutils.ParameterMap;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.content.BooleanValue;
import com.adobe.xfa.content.Content;
import com.adobe.xfa.content.DateTimeValue;
import com.adobe.xfa.content.DateValue;
import com.adobe.xfa.content.DecimalValue;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.content.FloatValue;
import com.adobe.xfa.content.ImageValue;
import com.adobe.xfa.content.IntegerValue;
import com.adobe.xfa.content.TextValue;
import com.adobe.xfa.content.TimeValue;
import com.adobe.xfa.template.Items;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.Value;
import com.adobe.xfa.template.containers.AreaContainer;
import com.adobe.xfa.template.containers.Draw;
import com.adobe.xfa.template.containers.ExclGroup;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.Subform;
import com.adobe.xfa.template.containers.SubformSet;
import com.adobe.xfa.ut.ExFull;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.foundation.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoRUtils {
    private static final Logger logger = LoggerFactory.getLogger(DoRUtils.class);

    public static MetaTemplate getMetaTemplate(String metaTemplateReference) throws IOException {
        ResourceResolver resourceResolver;
        Resource resource;
        byte[] metaTemplateBytes = null;
        if (StringUtils.isNotEmpty((CharSequence)metaTemplateReference) && (resource = (resourceResolver = DoRThreadLocal.getResourceResolver()).getResource(metaTemplateReference + "/jcr:content/renditions/original/jcr:content")) != null) {
            InputStream inputStream = (InputStream)resource.adaptTo(InputStream.class);
            metaTemplateBytes = IOUtils.toByteArray((InputStream)inputStream);
            inputStream.close();
        }
        MetaTemplate metaTemplate = new MetaTemplate(metaTemplateBytes, metaTemplateReference);
        return metaTemplate;
    }

    public static String convertToPlainText(String htmlString) {
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)htmlString)) {
            result = htmlString.replaceAll("<[^>]+>", "").replaceAll("&nbsp;", " ");
        }
        return result;
    }

    public static String convertToXfaCompliantHTML(String htmlString) {
        String result = "";
        if (StringUtils.isNotEmpty((CharSequence)htmlString)) {
            result = htmlString.replaceAll("<br>", "<br> </br>");
            result = result.replaceAll("&nbsp;", "&#160;");
        }
        return result;
    }

    public static Properties resolveImage(ResourceResolver resourceResolver, String jcrPath) throws RepositoryException, IOException {
        Properties properties = new Properties();
        if (StringUtils.isNotEmpty((CharSequence)jcrPath) && resourceResolver != null) {
            Resource resource = resourceResolver.resolve(jcrPath);
            Image image = new Image(resource);
            Property property = image.getData();
            if (property == null) {
                return properties;
            }
            InputStream inputStream = property.getBinary().getStream();
            byte[] imageBytes = IOUtils.toByteArray((InputStream)inputStream);
            inputStream.close();
            String imageData = Base64.encodeBase64String((byte[])imageBytes);
            properties.put("imageData", imageData);
            String mimeType = image.getMimeType();
            properties.setProperty("jcr:mimeType", mimeType);
            properties.setProperty("imageHref", "");
        }
        return properties;
    }

    public static String getValue(Content value) {
        String string = "";
        if (value instanceof BooleanValue) {
            string = ((BooleanValue)value).getStrValue();
        } else if (value instanceof DateValue) {
            string = ((DateValue)value).getValue();
        } else if (value instanceof DateTimeValue) {
            string = ((DateTimeValue)value).getValue();
        } else if (value instanceof DecimalValue) {
            string = ((DecimalValue)value).getFormattedValue();
        } else if (value instanceof ExDataValue) {
            string = ((ExDataValue)value).getValue(true, true, true);
        } else if (value instanceof FloatValue) {
            string = ((FloatValue)value).getStrValue();
        } else if (value instanceof ImageValue) {
            string = ((ImageValue)value).getValue();
        } else if (value instanceof IntegerValue) {
            string = ((IntegerValue)value).getStrValue();
        } else if (value instanceof TextValue) {
            string = ((TextValue)value).getValue();
        } else if (value instanceof TimeValue) {
            string = ((TimeValue)value).getValue();
        }
        return string;
    }

    public static DoROptions createDoROptions(ParameterMap params, String data, ResourceResolver resourceResolver, String userXciContent) throws IOException {
        return DoRUtils.createDoROptions(params, data, resourceResolver, userXciContent, null);
    }

    public static DoROptions createDoROptions(ParameterMap params, String data, ResourceResolver resourceResolver, String userXciContent, Resource guideContainerResource) throws IOException {
        DoROptions options = new DoROptions();
        String guideContainerPath = params.getStringValue("guideContainerPath");
        Resource guideContainerPathResource = guideContainerResource;
        if (guideContainerPathResource == null) {
            guideContainerPathResource = resourceResolver.getResource(guideContainerPath);
        }
        String locale = params.getStringValue("runtimeLocale");
        locale = (String)StringUtils.defaultIfBlank((CharSequence)locale, (CharSequence)"en");
        Locale local = new Locale(locale);
        options.setLocale(local);
        options.setFormResource(guideContainerPathResource);
        options.setData(data);
        options.setUserXci(userXciContent);
        List<FileAttachmentWrapper> fileAttachments = GuideUtils.getFileAttachmentWrapperList(params);
        if (fileAttachments != null && fileAttachments.size() > 0) {
            options.setFileAttachments(fileAttachments);
            options.setIncludeAttachments(true);
        }
        return options;
    }

    public static void setRichTextValue(Value valueNode, String value) throws NumberFormatException, DoRTemplateParsingException {
        if (value != null && valueNode != null) {
            DoRUtils.enableRichText(valueNode);
            String text = DoRUtils.convertToXfaCompliantHTML(value);
            DoRUtils.setValue((Content)valueNode.getOneOfChild(), text, "text/html");
        }
    }

    public static void setValue(Content content, String text, String contentType) throws DoRTemplateParsingException {
        DoRUtils.setValue(content, text, contentType, true);
    }

    public static void setValue(Content content, String text, String contentType, boolean isExceptionThrowable) throws NumberFormatException, DoRTemplateParsingException {
        if (StringUtils.equals((CharSequence)"text/html", (CharSequence)contentType)) {
            Value value = (Value)content.getXFAParent();
            DoRUtils.enableRichText(value);
            content = (Content)value.getOneOfChild();
        }
        if (content instanceof BooleanValue) {
            ((BooleanValue)content).setValue(Boolean.parseBoolean(text));
        } else if (content instanceof DateValue) {
            ((DateValue)content).setValue(text);
        } else if (content instanceof DateTimeValue) {
            ((DateTimeValue)content).setValue(text);
        } else if (content instanceof DecimalValue) {
            ((DecimalValue)content).setValue(Double.parseDouble(text), true, false, false);
        } else if (content instanceof ExDataValue) {
            if ("text/html".equals(contentType)) {
                DoRUtils.setContentForHtml(content, text, isExceptionThrowable);
            } else {
                ((ExDataValue)content).setValue(text);
            }
        } else if (content instanceof FloatValue) {
            ((FloatValue)content).setValue((double)Float.parseFloat(text), false, true);
        } else if (content instanceof ImageValue) {
            ((ImageValue)content).setValue(text, contentType);
        } else if (content instanceof IntegerValue) {
            ((IntegerValue)content).setValue(Integer.parseInt(text));
        } else if (content instanceof TextValue) {
            ((TextValue)content).setValue(text);
        } else if (content instanceof TimeValue) {
            ((TimeValue)content).setValue(text);
        }
    }

    private static void setContentForHtml(Content content, String text, boolean isExceptionThrowable) throws DoRTemplateParsingException {
        try {
            ExDataValue exDataValue = (ExDataValue)content;
            TemplateModel templateModel = TemplateModel.getTemplateModel((AppModel)content.getAppModel(), (boolean)true);
            Element body = templateModel.createElement("body");
            body.setModel(exDataValue.getModel());
            body.setNS("http://www.w3.org/1999/xhtml");
            body.setAttribute("", "xmlns:xfa", "xfa", "http://www.xfa.org/schema/xfa-data/1.0/");
            String richText = "<body xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\" xmlns=\"http://www.w3.org/1999/xhtml\">" + text + "</" + "body" + ">";
            ByteArrayInputStream is = new ByteArrayInputStream(richText.getBytes("UTF-8"));
            body.loadXML((InputStream)is, true, true);
            exDataValue.setContent((Node)body, false);
            is.close();
        }
        catch (ExFull e) {
            logger.error("[AF] [DoR] Error while parsing template xml", (Throwable)e);
            logger.debug("[AF] [DoR] Error while parsing string present in form: {}", (Object)text);
            if (isExceptionThrowable) {
                throw new DoRTemplateParsingException("Error while parsing template xml", e);
            }
        }
        catch (Exception e) {
            logger.error("[AF] [DoR] Error in setting text/html content", (Throwable)e);
        }
    }

    public static JSONObject getItems(Field field) throws JSONException {
        JSONObject slingItems = new JSONObject();
        Field.ItemPair items = new Field.ItemPair();
        field.getItemLists(true, items, false);
        Items displayItems = items.mDisplayItems;
        Items saveItems = items.mSaveItems;
        Node displayOption = displayItems.getFirstXFAChild();
        Node saveOption = saveItems.getFirstXFAChild();
        while (displayOption != null && saveItems != null) {
            JSONObject slingItem = new JSONObject();
            String saveValue = "";
            String displayValue = "";
            if (displayOption instanceof TextValue) {
                saveValue = ((TextValue)saveOption).getStrValue();
                displayValue = ((TextValue)displayOption).getStrValue();
            } else if (displayOption instanceof IntegerValue) {
                saveValue = ((IntegerValue)saveOption).getStrValue();
                displayValue = ((IntegerValue)displayOption).getStrValue();
            }
            slingItem.put("text", (Object)displayValue);
            slingItem.put("value", (Object)saveValue);
            slingItems.put(saveValue, (Object)slingItem);
            displayOption = displayOption.getNextXFASibling();
            saveOption = saveOption.getNextXFASibling();
        }
        return slingItems;
    }

    public static void translate(Node element, I18n i18n) throws DoRTemplateParsingException {
        for (Node child = element.getFirstXFAChild(); child != null; child = child.getNextXMLSibling()) {
            if (child instanceof Field) {
                String translatedText;
                Content captionTextNode = (Content)((Value)child.resolveNode("caption.value")).getOneOfChild(false, true);
                String captionText = DoRUtils.getValue(captionTextNode);
                if (!StringUtils.equals((CharSequence)captionText, (CharSequence)(translatedText = GuideUtils.translateOrReturnOriginal(captionText, null, i18n, ValueMap.EMPTY)))) {
                    DoRUtils.setValue(captionTextNode, translatedText, null);
                }
                Field.ItemPair items = new Field.ItemPair();
                ((Field)child).getItemLists(true, items, true);
                Items displayItems = items.mDisplayItems;
                if (displayItems == null) continue;
                for (Node displayOption = displayItems.getFirstXFAChild(); displayOption != null; displayOption = displayOption.getNextXFASibling()) {
                    Content displayTextNode = (Content)displayOption;
                    String displayText = DoRUtils.getValue(displayTextNode);
                    if (StringUtils.equals((CharSequence)displayText, (CharSequence)(translatedText = GuideUtils.translateOrReturnOriginal(displayText, null, i18n, ValueMap.EMPTY)))) continue;
                    DoRUtils.setValue(displayTextNode, translatedText, null);
                }
                continue;
            }
            if (child instanceof Draw) {
                String translatedText;
                Content staticTextNode;
                String staticText;
                Value value = (Value)child.resolveNode("value");
                Node valueNode = value.getOneOfChild(false, true);
                if (!(valueNode instanceof TextValue) && !(valueNode instanceof ExDataValue) || StringUtils.equals((CharSequence)(staticText = DoRUtils.getValue(staticTextNode = (Content)valueNode)), (CharSequence)(translatedText = GuideUtils.translateOrReturnOriginal(staticText, null, i18n, ValueMap.EMPTY)))) continue;
                DoRUtils.setValue(staticTextNode, translatedText, null);
                continue;
            }
            if (child instanceof ExclGroup) {
                DoRUtils.translate(child, i18n);
                continue;
            }
            if (child instanceof Subform) {
                DoRUtils.translate(child, i18n);
                continue;
            }
            if (child instanceof SubformSet) {
                DoRUtils.translate(child, i18n);
                continue;
            }
            if (!(child instanceof AreaContainer)) continue;
            DoRUtils.translate(child, i18n);
        }
    }

    public static void enableRichText(Value value) {
        if (value == null) {
            return;
        }
        Node child = value.getOneOfChild(false, true);
        if (child instanceof TextValue) {
            child.remove();
            ExDataValue exDataValue = new ExDataValue((Element)value, null);
            exDataValue.setAttribute((Attribute)new StringAttr("contentType", "text/html"), XFA.CONTENTTYPETAG);
            value.appendChild((Node)exDataValue);
        }
    }

    public static void enablePlainText(Value value) {
        if (value == null) {
            return;
        }
        Node child = value.getOneOfChild(false, true);
        if (child instanceof ExDataValue) {
            child.remove();
            TextValue textValue = new TextValue((Element)value, null);
            value.appendChild((Node)textValue);
        }
    }

    public static String convertColorToRGB(String color) {
        String rgbColor = "";
        if (StringUtils.startsWith((CharSequence)color, (CharSequence)"#")) {
            rgbColor = Integer.parseInt(color.substring(1, 3), 16) + "," + Integer.parseInt(color.substring(3, 5), 16) + "," + Integer.parseInt(color.substring(5, 7), 16);
        } else if (StringUtils.startsWith((CharSequence)color, (CharSequence)"rgba")) {
            rgbColor = StringUtils.substringBeforeLast((String)color.substring(5), (String)",");
        } else if (StringUtils.startsWith((CharSequence)color, (CharSequence)"rgb")) {
            rgbColor = color.substring(4, color.length() - 1);
        }
        return rgbColor;
    }

    public static String convertColorToHEX(String color) {
        String[] hexComponents;
        String hexColor = "#";
        for (String hexComponent : hexComponents = StringUtils.split((String)color, (String)", ")) {
            String hexValue = Integer.toHexString(Integer.parseInt(hexComponent));
            if (StringUtils.length((CharSequence)hexValue) == 1) {
                hexValue = "0" + hexValue;
            }
            hexColor = hexColor + hexValue;
        }
        return hexColor;
    }

    public static Boolean isSchemaBasedForm(GuideType guideType) {
        return GuideType.XSD_BASED.equals((Object)guideType) || GuideType.JSON_BASED.equals((Object)guideType);
    }

    public static String getValueMatch(String pattern, String input) {
        Pattern widthpattern = Pattern.compile(pattern);
        Matcher matchWidthValue = widthpattern.matcher(input);
        if (matchWidthValue.find()) {
            return matchWidthValue.group();
        }
        return null;
    }

    public static Element getSpaceFillerElement(Element parent) {
        Draw space = new Draw(parent, null);
        space.setAttribute("name", "name", "name", "dorSpacer");
        space.setAttribute("usehref", "usehref", "usehref", ".#som($template.#subform.spaceFiller)");
        return space;
    }
}

