/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.common.FDVersion;
import com.adobe.aemds.guide.model.TypekitConfiguration;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.service.ThemeConfigurationService;
import com.adobe.aemds.guide.service.internal.TypekitConfigurationService;
import com.adobe.aemds.guide.themes.model.BreakpointInfo;
import com.adobe.aemds.guide.themes.model.Component;
import com.adobe.aemds.guide.themes.model.DefaultBreakpointInfo;
import com.adobe.aemds.guide.themes.model.Selector;
import com.adobe.aemds.guide.themes.model.Theme;
import com.adobe.aemds.guide.themes.model.ThemeClientLib;
import com.adobe.aemds.guide.themes.model.ThemeMetadata;
import com.adobe.aemds.guide.utils.GuideStyleMigrationUtils;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.ThemeClientLibData;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.resourcemerger.api.ResourceMergerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideThemeUtils {
    private static Logger logger = LoggerFactory.getLogger(GuideThemeUtils.class);

    public static String getConfiguredFormPagePath(ResourceResolver resourceResolver, String themeContentPath) {
        if (resourceResolver == null) {
            throw new GuideException("Invalid user session.");
        }
        Resource themeResource = resourceResolver.resolve(themeContentPath);
        ThemeMetadata themeMetadata = (ThemeMetadata)themeResource.getChild("metadata").adaptTo(ThemeMetadata.class);
        return themeMetadata.getFormPagePath();
    }

    public static String getConfiguredFormPath(ResourceResolver resourceResolver, String themeContentPath) {
        if (resourceResolver == null) {
            throw new GuideException("Invalid user session.");
        }
        String formAssetPath = null;
        try {
            Node themeContentNode;
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (themeContentPath != null && session.nodeExists(themeContentPath) && (themeContentNode = session.getNode(themeContentPath)).hasProperty("metadata/formRef")) {
                formAssetPath = themeContentNode.getProperty("metadata/formRef").getString();
            }
        }
        catch (RepositoryException e) {
            throw new GuideException((Exception)((Object)e));
        }
        return formAssetPath;
    }

    public static String getThemeClientlibCategory(ResourceResolver resourceResolver, String themeContentPath) {
        if (resourceResolver == null) {
            throw new GuideException("Invalid user session.");
        }
        String themeClientlibCategory = null;
        try {
            Node themeContentNode;
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (themeContentPath != null && session.nodeExists(themeContentPath) && (themeContentNode = session.getNode(themeContentPath)).hasProperty("metadata/clientlibCategory")) {
                themeClientlibCategory = themeContentNode.getProperty("metadata/clientlibCategory").getString();
            }
        }
        catch (RepositoryException e) {
            throw new GuideException((Exception)((Object)e));
        }
        return themeClientlibCategory;
    }

    public static String getBaseClientlibCategory(ResourceResolver resourceResolver, String themeContentPath) {
        if (resourceResolver == null) {
            throw new GuideException("Invalid user session.");
        }
        String baseClientlibCategory = null;
        try {
            String clientlibLoc;
            Node clientlibNode;
            Node themeContentNode;
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (themeContentPath != null && session.nodeExists(themeContentPath) && (themeContentNode = session.getNode(themeContentPath)).hasProperty("metadata/clientlibRef") && (clientlibNode = session.getNode((clientlibLoc = themeContentNode.getProperty("metadata/clientlibRef").getString()) + "/" + themeContentNode.getParent().getName())).hasProperty("dependencies")) {
                Value[] values = clientlibNode.getProperty("dependencies").getValues();
                baseClientlibCategory = values[0].getString();
            }
        }
        catch (RepositoryException e) {
            throw new GuideException((Exception)((Object)e));
        }
        return baseClientlibCategory;
    }

    public static void saveThemeCSS(Theme theme, ResourceResolver resolver, ResourceMergerService resourceMergerService, ThemeConfigurationService themeConfigurationService) throws GuideException {
        try {
            String cSSString = GuideThemeUtils.getThemeCSS(theme, resolver, resourceMergerService, themeConfigurationService);
            GuideThemeUtils.updateClientLibForTheme(resolver, theme.getThemeNodeName(), cSSString, theme.getMetadata().getClientlibRef());
        }
        catch (RepositoryException e) {
            logger.error("Unable to save the Theme Css", (Throwable)e);
            throw new GuideException((Exception)((Object)e));
        }
    }

    public static String getThemeCSS(Theme theme, ResourceResolver resolver, ResourceMergerService resourceMergerService, ThemeConfigurationService themeConfigurationService) {
        String themeCss = "";
        ArrayList<BreakpointInfo> themeFormBreakpointList = new ArrayList<BreakpointInfo>();
        ThemeMetadata themeMetadata = theme.getMetadata();
        List breakpoints = themeMetadata.getBreakpoints();
        String themeFormPath = themeMetadata.getFormPagePath();
        Resource breakpointNodeResource = GuideUtils.getFormBreakpointResource(resolver, themeFormPath);
        if (breakpointNodeResource != null) {
            for (Resource childResource : breakpointNodeResource.getChildren()) {
                BreakpointInfo breakpointInfo = (BreakpointInfo)childResource.adaptTo(BreakpointInfo.class);
                themeFormBreakpointList.add(breakpointInfo);
            }
        }
        if (!GuideThemeUtils.containsDefaultBreakpoint(breakpoints)) {
            DefaultBreakpointInfo defaultBreakpoint = new DefaultBreakpointInfo();
            breakpoints.add(defaultBreakpoint);
        }
        List<BreakpointInfo> sortedBreakpoints = GuideThemeUtils.sortBreakpoints(breakpoints);
        List<BreakpointInfo> currentFormBreakpointList = GuideThemeUtils.sortBreakpoints(themeFormBreakpointList);
        for (Component component : theme.getComponents()) {
            Map selectorMap = GuideStyleMigrationUtils.getSelectorMap(component.getComponentPath(), resolver, resourceMergerService, "cq:themeConfig");
            themeCss = themeCss + GuideThemeUtils.getComponentCssString(component, resolver, sortedBreakpoints, currentFormBreakpointList, selectorMap, themeMetadata, themeConfigurationService);
        }
        themeCss = themeCss + theme.getRawCss();
        return themeCss;
    }

    private static boolean containsDefaultBreakpoint(List<BreakpointInfo> breakpoints) {
        for (BreakpointInfo breakpoint : breakpoints) {
            if (!breakpoint.getId().equals("default")) continue;
            return true;
        }
        return false;
    }

    public static String getComponentCssString(Component component, ResourceResolver resolver, List<BreakpointInfo> sortedBreakpoints, List<BreakpointInfo> additionalBreakpointList, Map<String, String> selectorMap, ThemeMetadata themeMetadata, ThemeConfigurationService themeConfigurationService) {
        String themeCss = "";
        for (Selector selector : component.getSelectors()) {
            Set selectorBreakpointIdSet;
            ValueMap selectorProperties = selector.getSelectorAllProperties();
            Iterator<BreakpointInfo> breakpointIterator = sortedBreakpoints.iterator();
            Set set = selectorBreakpointIdSet = additionalBreakpointList.isEmpty() ? new HashSet() : selector.getBreakpointsIdSet();
            while (breakpointIterator.hasNext()) {
                BreakpointInfo breakpoint = breakpointIterator.next();
                themeCss = themeCss + GuideThemeUtils.getSelectorCssString(breakpoint, selector, selectorProperties, resolver, selectorMap, component.getInlineClass(), themeConfigurationService);
                String currentBreakpointId = breakpoint.getId();
                if (!selectorBreakpointIdSet.contains(currentBreakpointId)) continue;
                selectorBreakpointIdSet.remove(currentBreakpointId);
            }
            Iterator<BreakpointInfo> additionalBreakpointListIterator = additionalBreakpointList.iterator();
            while (additionalBreakpointListIterator.hasNext() && !selectorBreakpointIdSet.isEmpty()) {
                BreakpointInfo breakpoint = additionalBreakpointListIterator.next();
                String breakpointId = breakpoint.getId();
                if (!selectorBreakpointIdSet.contains(breakpointId)) continue;
                GuideThemeUtils.addBreakpointToTheme(breakpoint, themeMetadata);
                sortedBreakpoints.add(breakpoint);
                GuideThemeUtils.sortBreakpoints(sortedBreakpoints);
                themeCss = themeCss + GuideThemeUtils.getSelectorCssString(breakpoint, selector, selectorProperties, resolver, selectorMap, component.getInlineClass(), themeConfigurationService);
            }
        }
        return themeCss;
    }

    private static void addBreakpointToTheme(BreakpointInfo breakpoint, ThemeMetadata themeMetadata) {
        try {
            Resource breakpointResource = themeMetadata.getResource().getChild("breakpoints");
            Node themeBreakpointNode = (Node)breakpointResource.adaptTo(Node.class);
            Node newBreakpointNode = themeBreakpointNode.addNode(breakpoint.getId(), "nt:unstructured");
            newBreakpointNode.setProperty("title", breakpoint.getName());
            newBreakpointNode.setProperty("width", (long)breakpoint.getMax().intValue());
        }
        catch (Exception e) {
            logger.error("Unable to add breakpoint to theme", (Throwable)e);
        }
    }

    private static String getSelectorCssString(BreakpointInfo breakpoint, Selector selector, ValueMap selectorProperties, ResourceResolver resolver, Map<String, String> selectorMap, String inlineClass, ThemeConfigurationService themeConfigurationService) {
        String selectorCss = "";
        String breakpointId = breakpoint.getId();
        List stylePropertyNames = selector.getStylePropertyNames(breakpointId);
        if (stylePropertyNames.size() > 0) {
            if (!breakpointId.equals("default")) {
                selectorCss = selectorCss + "@media (max-width : " + breakpoint.getMax() + "px){\n";
            }
            for (String propertyName : stylePropertyNames) {
                if (selectorProperties.get((Object)propertyName) == null) continue;
                String stateName = propertyName.substring(propertyName.indexOf("#") + 1);
                HashSet maskedPropertiesSet = selector.getMaskedPropertiesSet(breakpointId, stateName);
                String[] cssProperties = selector.getCssPropertiesList(breakpointId, stateName).toArray(new String[0]);
                String selectorPath = selectorMap.get(selector.getId());
                if (selectorPath != null) {
                    if (!stateName.equals("default")) {
                        selectorPath = selectorMap.get(selector.getId()) + "/states/" + stateName;
                    }
                    if (resolver.getResource(selectorPath) != null && resolver.getResource(selectorPath).getValueMap().containsKey((Object)"cssSelector")) {
                        ValueMap valueMap = resolver.getResource(selectorPath).getValueMap();
                        String cssOverride = "";
                        String beforeSelector = "";
                        String afterSelector = "";
                        String addonCss = "";
                        String inlinePrefix = "";
                        String cssSelector = GuideThemeUtils.generateSelectorString(inlineClass, valueMap.get((Object)"cssSelector").toString(), true);
                        selectorCss = selectorCss + cssSelector + "{\n";
                        for (String cssProperty : cssProperties) {
                            String key = cssProperty.substring(0, cssProperty.indexOf(58));
                            String value = cssProperty.substring(cssProperty.indexOf(58) + 1);
                            if (key.equals("cssOverride")) {
                                value = GuideThemeUtils.filterURLInAdvancedCSS(value, themeConfigurationService);
                                cssOverride = GuideThemeUtils.getCssPropertyValue("cssOverride", value, maskedPropertiesSet);
                                continue;
                            }
                            if (key.equals("afterPseudoElement")) {
                                value = GuideThemeUtils.filterURLInAdvancedCSS(value, themeConfigurationService);
                                afterSelector = GuideThemeUtils.getPseudoCSSString(cssSelector, "::after", GuideThemeUtils.getCssPropertyValue("afterPseudoElement", value, maskedPropertiesSet));
                                continue;
                            }
                            if (key.equals("beforePseudoElement")) {
                                value = GuideThemeUtils.filterURLInAdvancedCSS(value, themeConfigurationService);
                                beforeSelector = GuideThemeUtils.getPseudoCSSString(cssSelector, "::before", GuideThemeUtils.getCssPropertyValue("beforePseudoElement", value, maskedPropertiesSet));
                                continue;
                            }
                            if (key.equals("addonCss")) {
                                addonCss = GuideThemeUtils.getAddonCSSString(inlineClass, value);
                                continue;
                            }
                            String propertyValueCssString = key + ":" + value + ";\n";
                            selectorCss = selectorCss + GuideThemeUtils.getCssPropertyValue(key, propertyValueCssString, maskedPropertiesSet);
                        }
                        selectorCss = selectorCss + cssOverride + "\n";
                        selectorCss = selectorCss + "}\n";
                        selectorCss = selectorCss + beforeSelector;
                        selectorCss = selectorCss + afterSelector;
                        selectorCss = selectorCss + addonCss;
                        continue;
                    }
                    logger.error("CSS selector string not found for resource: " + selectorPath);
                    continue;
                }
                logger.error("CSS selector information not found for selector Id: " + selector.getId());
            }
            if (!breakpointId.equals("default")) {
                selectorCss = selectorCss + "}\n";
            }
        }
        return selectorCss;
    }

    public static String filterURLInAdvancedCSS(String value, ThemeConfigurationService themeConfigurationService) {
        List<Pattern> allowListURLs = themeConfigurationService.getAllowListURLForCustomCSS();
        String filteredValue = value;
        if (allowListURLs.size() != 0) {
            StringBuilder valueStringBuilder = new StringBuilder(value);
            Pattern urlPattern = Pattern.compile("url\\([^)]+\\)");
            Matcher urlMatcher = urlPattern.matcher(value);
            while (urlMatcher.find()) {
                String urlString = urlMatcher.group();
                int startIndexOfURL = 5;
                int endIndexOfURL = urlString.length() - 2;
                boolean isValid = false;
                for (Pattern regex : allowListURLs) {
                    Matcher matcher = regex.matcher(urlString.substring(startIndexOfURL, endIndexOfURL));
                    if (!matcher.matches()) continue;
                    if (!isValid) {
                        // empty if block
                    }
                    isValid = true;
                }
                if (isValid) continue;
                int length = urlString.length();
                valueStringBuilder.replace(urlMatcher.start(), urlMatcher.end(), StringUtils.repeat((String)" ", (int)length));
            }
            filteredValue = valueStringBuilder.toString();
        }
        return filteredValue;
    }

    public static void saveInlineCSS(Resource resource, String formPath, ResourceMergerService resourceMergerService, ThemeConfigurationService themeConfigurationService) {
        ResourceResolver resolver = resource.getResourceResolver();
        String resourceType = resource.getResourceType();
        ArrayList<BreakpointInfo> breakpointInfoList = new ArrayList<BreakpointInfo>();
        Resource breakpointNodeResource = GuideUtils.getFormBreakpointResource(resolver, formPath);
        if (breakpointNodeResource != null) {
            for (Resource childResource : breakpointNodeResource.getChildren()) {
                BreakpointInfo breakpointInfo = (BreakpointInfo)childResource.adaptTo(BreakpointInfo.class);
                breakpointInfoList.add(breakpointInfo);
            }
        }
        DefaultBreakpointInfo defaultBreakpoint = new DefaultBreakpointInfo();
        breakpointInfoList.add((BreakpointInfo)defaultBreakpoint);
        List<BreakpointInfo> sortedBreakpoints = GuideThemeUtils.sortBreakpoints(breakpointInfoList);
        Resource styleResource = resource.getChild("style");
        String overridePath = resolver.getResource(resourceType).getPath();
        Map selectorMap = GuideStyleMigrationUtils.getSelectorMap(overridePath, resolver, resourceMergerService, "cq:styleConfig");
        if (styleResource != null) {
            Component component = (Component)styleResource.adaptTo(Component.class);
            String cssString = GuideThemeUtils.getComponentCssString(component, resolver, sortedBreakpoints, new ArrayList<BreakpointInfo>(), selectorMap, null, themeConfigurationService);
            ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            properties.put((Object)"cssStyle", (Object)cssString);
        }
    }

    private static String getAddonCSSString(String inlineClass, String value) {
        String cssString = "";
        try {
            JSONObject addOnCSSObject = new JSONObject(value);
            JSONObject selectors = addOnCSSObject.getJSONObject("selectors");
            Iterator selectorKeys = selectors.keys();
            while (selectorKeys.hasNext()) {
                String key = (String)selectorKeys.next();
                JSONObject selector = selectors.getJSONObject(key);
                String cssSelectorString = GuideThemeUtils.generateSelectorString(inlineClass, selector.getString("cssSelector"), false);
                cssString = cssString + cssSelectorString + " {\n";
                JSONObject properties = selector.getJSONObject("properties");
                Iterator propertyKeys = properties.keys();
                while (propertyKeys.hasNext()) {
                    String propertyKey = (String)propertyKeys.next();
                    String propValue = properties.getString(propertyKey);
                    cssString = cssString + propertyKey + ":" + propValue + ";\n";
                }
                cssString = cssString + "}\n";
            }
        }
        catch (JSONException e) {
            logger.error("Unable to parse addonCss object", (Throwable)e);
        }
        return cssString;
    }

    private static Resource getTargetResource(Resource resource) {
        ValueMap values = resource.getValueMap();
        String target = (String)values.get("target", String.class);
        if (target != null) {
            ResourceResolver resolver = resource.getResourceResolver();
            return resolver.getResource(target);
        }
        return resource;
    }

    private static String getPseudoCSSString(String selectorString, String pseudoElementString, String value) {
        StringBuilder selectorValueBuilder = new StringBuilder();
        String cssString = "";
        StringTokenizer st = new StringTokenizer(selectorString, ",");
        while (st.hasMoreElements()) {
            selectorValueBuilder.append(st.nextElement()).append(pseudoElementString);
            if (!st.hasMoreElements()) continue;
            selectorValueBuilder.append(",");
        }
        cssString = cssString + selectorValueBuilder.toString();
        cssString = cssString + "{\n";
        cssString = cssString + value + "\n";
        cssString = cssString + "}\n";
        return cssString;
    }

    private static void updateClientLibForTheme(ResourceResolver resolver, String clientLibName, String cssString, String clientLibPath) throws RepositoryException {
        Session session = (Session)resolver.adaptTo(Session.class);
        String clientLibCompletePath = clientLibPath + "/" + clientLibName;
        Resource clientLibResource = resolver.getResource(clientLibCompletePath);
        if (clientLibResource != null) {
            Resource contentResource = clientLibResource.getChild("css/theme.css/jcr:content");
            ModifiableValueMap map = (ModifiableValueMap)contentResource.adaptTo(ModifiableValueMap.class);
            map.put((Object)"jcr:data", (Object)cssString);
            Resource cssTxtResource = clientLibResource.getChild("css.txt/jcr:content");
            ModifiableValueMap txtMap = (ModifiableValueMap)cssTxtResource.adaptTo(ModifiableValueMap.class);
            Calendar currentTime = Calendar.getInstance();
            txtMap.put((Object)"jcr:lastModified", (Object)currentTime);
        } else {
            logger.error("Unable to find clientLib at location {}", (Object)clientLibCompletePath);
        }
    }

    public static List<BreakpointInfo> sortBreakpoints(List<BreakpointInfo> breakpoints) {
        Collections.sort(breakpoints, new Comparator<BreakpointInfo>(){

            @Override
            public int compare(BreakpointInfo breakpoint2, BreakpointInfo breakpoint1) {
                if (breakpoint2.getMax() == -1) {
                    return -1;
                }
                if (breakpoint1.getMax() == -1) {
                    return 1;
                }
                return breakpoint1.getMax().compareTo(breakpoint2.getMax());
            }
        });
        return breakpoints;
    }

    public static String makeCssComment(String cssString) {
        return "/*" + cssString + "*/";
    }

    public static void copyAssets(Resource fromResource, Resource toResource, ResourceResolver resourceResolver) {
        try {
            String fromResourceAssetPath = fromResource.getPath() + "/" + "assets";
            Resource fromResourceAsset = resourceResolver.getResource(fromResourceAssetPath);
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            if (fromResourceAsset != null) {
                String toResourceAssetPath = toResource.getPath() + "/" + "assets";
                Resource toResourceAsset = resourceResolver.getResource(toResourceAssetPath);
                if (toResourceAsset == null) {
                    String toResourcePath = toResource.getPath();
                    Node fromResourceAssetNode = session.getNode(fromResourceAssetPath);
                    Node toResourceNode = session.getNode(toResourcePath);
                    JcrUtil.copy((Node)fromResourceAssetNode, (Node)toResourceNode, null);
                } else {
                    Iterator children = fromResourceAsset.listChildren();
                    Node toResourceAssetNode = session.getNode(toResourceAssetPath);
                    while (children.hasNext()) {
                        Resource imageResource = (Resource)children.next();
                        String imageResourceName = imageResource.getName();
                        String imageResourcePath = imageResource.getPath();
                        String oldImageResourcePath = toResourceAssetPath + "/" + imageResourceName;
                        if (session.itemExists(oldImageResourcePath)) {
                            session.removeItem(oldImageResourcePath);
                        }
                        Node imageNode = session.getNode(imageResourcePath);
                        JcrUtil.copy((Node)imageNode, (Node)toResourceAssetNode, null);
                    }
                }
                session.save();
            }
        }
        catch (PathNotFoundException e) {
            logger.error("Error in copying StyleAsset", (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error("Error in copying StyleAsset", (Throwable)e);
        }
    }

    public static void copyStyles(Resource fromResource, Resource toResource, ResourceResolver resourceResolver, String cssClass) {
        try {
            String fromResourcePath = fromResource.getPath();
            String fromResourceStylePath = fromResourcePath + "/" + "style";
            String toResourcePath = toResource.getPath();
            String toResourceStylePath = toResourcePath + "/" + "style";
            Session session = (Session)resourceResolver.adaptTo(Session.class);
            Resource fromResourceStyle = resourceResolver.getResource(fromResourceStylePath);
            Resource toResourceStyle = resourceResolver.getResource(toResourceStylePath);
            ModifiableValueMap toResourcePropertyMap = (ModifiableValueMap)toResource.adaptTo(ModifiableValueMap.class);
            ModifiableValueMap fromResourcePropertyMap = (ModifiableValueMap)fromResource.adaptTo(ModifiableValueMap.class);
            if (fromResourceStyle == null) {
                if (toResourcePropertyMap != null) {
                    if (toResourcePropertyMap.containsKey((Object)"cssStyle")) {
                        toResourcePropertyMap.remove((Object)"cssStyle");
                    }
                    if (toResourcePropertyMap.containsKey((Object)"cq:cssClass")) {
                        toResourcePropertyMap.remove((Object)"cq:cssClass");
                    }
                }
                if (toResourceStyle != null) {
                    resourceResolver.delete(toResourceStyle);
                }
            } else {
                if (!toResourcePropertyMap.containsKey((Object)"cq:cssClass")) {
                    toResourcePropertyMap.put((Object)"cq:cssClass", (Object)cssClass);
                }
                toResourcePropertyMap.put((Object)"cssStyle", fromResourcePropertyMap.get((Object)"cssStyle"));
                Node fromResourceStyleNode = session.getNode(fromResourceStylePath);
                Node toResourceNode = session.getNode(toResourcePath);
                JcrUtil.copy((Node)fromResourceStyleNode, (Node)toResourceNode, null);
            }
            session.save();
            resourceResolver.commit();
        }
        catch (PersistenceException e) {
            logger.error("Error in copying StyleNode", (Throwable)e);
        }
        catch (PathNotFoundException e) {
            logger.error("Error in copying StyleNode", (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error("Error in copying StyleNode", (Throwable)e);
        }
    }

    private static String getCssPropertyValue(String property, String value, HashSet<String> maskedPropertiesSet) {
        if (maskedPropertiesSet.contains(property)) {
            value = property.equals("afterPseudoElement") || property.equals("afterPseudoElement") || property.equals("beforePseudoElement") ? "" : GuideThemeUtils.makeCssComment(value);
        }
        return value;
    }

    public static String getClientLibCategory(Resource themeResource) {
        ThemeClientLib clientLib;
        String category = null;
        if (themeResource != null && (clientLib = GuideThemeUtils.getThemeClientLib(themeResource)) != null) {
            category = clientLib.getCategory();
        }
        return category;
    }

    public static String getClientLibPath(Resource themeResource) {
        ThemeClientLib clientLib;
        String path = null;
        if (themeResource != null && (clientLib = GuideThemeUtils.getThemeClientLib(themeResource)) != null) {
            path = clientLib.getPath();
        }
        return path;
    }

    private static ThemeClientLib getThemeClientLib(Resource themeResource) {
        ThemeClientLib clientLib = null;
        if (themeResource != null) {
            ValueMap themeMetaData;
            String path;
            String themeNodeName = themeResource.getParent().getName();
            ResourceResolver resolver = themeResource.getResourceResolver();
            Resource clientLibResource = resolver.getResource(path = (String)(themeMetaData = (ValueMap)themeResource.getChild("metadata").adaptTo(ValueMap.class)).get("clientlibRef", String.class) + "/" + themeNodeName);
            if (clientLibResource != null) {
                clientLib = (ThemeClientLib)clientLibResource.adaptTo(ThemeClientLib.class);
            } else {
                logger.info("Theme client library missing at {}. Falling back to the default client library", (Object)path);
            }
        }
        return clientLib;
    }

    public static String getWebFontConfig(ResourceResolver resourceResolver, String themeContentPath) {
        Resource themeResource = resourceResolver.getResource(themeContentPath);
        if (GuideThemeUtils.isResourceTheme(themeResource)) {
            ValueMap themeMetaData = (ValueMap)themeResource.getChild("metadata").adaptTo(ValueMap.class);
            return (String)themeMetaData.get("webFontConfigRef", String.class);
        }
        return null;
    }

    public static String getCommonClientLibName(Resource themeContentResource) {
        Resource themeMetadataResource = themeContentResource.getChild("metadata");
        ValueMap metadata = (ValueMap)themeMetadataResource.adaptTo(ValueMap.class);
        String targetSpec = (String)metadata.get("fd:targetVersion", String.class);
        if (targetSpec == null) {
            targetSpec = "1.0";
        }
        if (FDVersion.compare("1.0", targetSpec) == 0) {
            return "guide.theme2.common.legacy620";
        }
        return "guide.theme2.common";
    }

    public static ThemeClientLibData getClientLibNames(Resource formResource, String themeOverride, String pageFallbackClientlib) {
        ResourceResolver resourceResolver;
        Resource themeContentResource = null;
        String themeClientLibName = null;
        String commonClientLibName = null;
        if (StringUtils.isNotBlank((CharSequence)themeOverride) && GuideThemeUtils.isResourceTheme(themeContentResource = (resourceResolver = formResource.getResourceResolver()).getResource(themeOverride))) {
            commonClientLibName = GuideThemeUtils.getCommonClientLibName(themeContentResource);
            themeClientLibName = GuideThemeUtils.getClientLibCategory(themeContentResource);
        }
        if (themeClientLibName == null && (themeContentResource = GuideUtils.getThemeResource(formResource)) != null) {
            commonClientLibName = GuideThemeUtils.getCommonClientLibName(themeContentResource);
            themeClientLibName = GuideThemeUtils.getClientLibCategory(themeContentResource);
        }
        if (themeClientLibName == null && StringUtils.isNotBlank((CharSequence)pageFallbackClientlib)) {
            themeClientLibName = pageFallbackClientlib;
            commonClientLibName = "guide.theme2.common";
        }
        ThemeClientLibData clientLibData = new ThemeClientLibData();
        clientLibData.setCommonClientLib(commonClientLibName);
        if (themeClientLibName != null) {
            clientLibData.setThemeClientLib(themeClientLibName);
        }
        return clientLibData;
    }

    public static boolean isResourceTheme(Resource themeContentResource) {
        boolean isResourceTheme = false;
        if (themeContentResource != null) {
            isResourceTheme = themeContentResource.isResourceType("fd/fm/theme/render");
        }
        return isResourceTheme;
    }

    public static String generateSelectorString(String className, String cssSelector, Boolean makeDescendantSelector) {
        if (StringUtils.isEmpty((CharSequence)className)) {
            return cssSelector;
        }
        String selectorString = "";
        String[] selectorArray = cssSelector.split(",");
        for (int i = 0; i < selectorArray.length; ++i) {
            if (i != 0) {
                selectorString = selectorString + ",";
            }
            selectorString = makeDescendantSelector != false ? selectorString + "." + className + " " + selectorArray[i] : selectorString + "." + className + selectorArray[i];
        }
        return selectorString;
    }

    public static void addTypekitConfigurations(JSONArray response, Resource theme, TypekitConfigurationService typekitConfigurationService) throws JSONException {
        Collection collection = typekitConfigurationService.getConfigurationCollection(theme);
        for (TypekitConfiguration configuration : collection) {
            JSONObject responseObject = new JSONObject();
            responseObject.put("text", (Object)(StringUtils.isNotEmpty((CharSequence)configuration.title()) ? configuration.title() : configuration.name()));
            responseObject.put("value", (Object)configuration.name());
            response.put((Object)responseObject);
        }
    }

    public static void addTypekitConfigurations(JSONArray response, Resource theme, ResourceResolver resourceResolver, TypekitConfigurationService typekitConfigurationService) throws JSONException {
        GuideThemeUtils.addTypekitConfigurations(response, resourceResolver);
        GuideThemeUtils.addTypekitConfigurations(response, theme, typekitConfigurationService);
    }

    @Deprecated
    public static void addTypekitConfigurations(JSONArray response, ResourceResolver resourceResolver) throws JSONException {
        ConfigurationManager configManager = (ConfigurationManager)resourceResolver.adaptTo(ConfigurationManager.class);
        Iterator it = configManager.getConfigurations("/etc/cloudservices/typekit");
        while (it.hasNext()) {
            Configuration configuration = (Configuration)it.next();
            JSONObject responseObject = new JSONObject();
            responseObject.put("text", (Object)configuration.getTitle());
            responseObject.put("value", (Object)configuration.getPath());
            response.put((Object)responseObject);
        }
    }
}

