/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfg.exception;

import com.adobe.pdfg.exception.ExceptionStackTrace;
import com.adobe.pdfg.exception.PDFGError;
import java.io.Serializable;

public class PDFGBaseException
extends Exception
implements Serializable {
    private static final int ERRORCODE_PADDING_LENGTH = 3;
    private static final String nl = System.getProperty("line.separator");
    private static final long serialVersionUID = 6464316886653262389L;
    private PDFGBaseException fallbackConverterException;
    private PDFGError m_error;
    private String m_causeStackTrace;

    public PDFGBaseException(PDFGError error, ExceptionStackTrace arg1) {
        super(error != null ? error.getMessage() : null);
        this.m_error = error;
        this.m_causeStackTrace = arg1.getStackTrace();
    }

    public PDFGBaseException(PDFGError error, Throwable cause) {
        super(error != null ? error.getMessage() : null, cause);
        this.m_error = error;
    }

    public PDFGBaseException(PDFGError error) {
        super(error != null ? error.getMessage() : null);
        this.m_error = error;
    }

    public void setFallbackConversionException(PDFGBaseException fallbackConverterException) {
        this.fallbackConverterException = fallbackConverterException;
        this.m_error.setFallbackConverterException(fallbackConverterException);
    }

    public String toString() {
        if (this.m_error != null) {
            StringBuilder buf = new StringBuilder("ALC-").append(this.m_error.getComponentUID()).append("-").append(PDFGBaseException.paddingString(Integer.toString(this.m_error.getErrorCode()), 3, '0', true));
            int minorCode = 0;
            buf.append("-").append(PDFGBaseException.paddingString(Integer.toString(minorCode), 3, '0', true));
            buf.append(": ").append(this.getClass().getName());
            String msg = this.getLocalizedMessage();
            if (msg != null) {
                buf.append(": ").append(msg);
            }
            if (this.m_causeStackTrace != null) {
                buf.append(nl).append("Caused by: ");
                buf.append(this.m_causeStackTrace);
            }
            return buf.toString();
        }
        return super.toString();
    }

    private static String paddingString(String s, int n, char c, boolean paddingLeft) {
        StringBuilder str = new StringBuilder(s);
        int strLength = str.length();
        if (n > 0 && n > strLength) {
            for (int i = 0; i <= n; ++i) {
                if (paddingLeft) {
                    if (i >= n - strLength) continue;
                    str.insert(0, c);
                    continue;
                }
                if (i <= strLength) continue;
                str.append(c);
            }
        }
        return str.toString();
    }

    public int getErrorCode() {
        return this.m_error.getErrorCode();
    }
}

