/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.event.osgimapping.eventhandler;

import com.adobe.aio.aem.event.osgimapping.eventhandler.EventUtil;
import com.adobe.aio.aem.event.osgimapping.eventhandler.OsgiEventMapping;
import com.adobe.aio.aem.event.xdm.aem.XdmUtil;
import com.adobe.aio.aem.util.ResourceResolverWrapper;
import com.adobe.aio.aem.util.ResourceResolverWrapperFactory;
import com.adobe.xdm.XdmObject;
import com.adobe.xdm.common.XdmEvent;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdobeIoEventHandler<T extends XdmObject>
implements EventHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final JobManager jobManager;
    private final URL rootUrl;
    private final String imsOrgId;
    private final OsgiEventMapping osgiEventMapping;
    private final ResourceResolverWrapperFactory resourceResolverWrapperFactory;

    protected AdobeIoEventHandler(JobManager jobManager, URL rootUrl, String imsOrgId, OsgiEventMapping osgiEventMapping, ResourceResolverWrapperFactory resourceResolverWrapperFactory) {
        this.jobManager = jobManager;
        this.rootUrl = rootUrl;
        this.imsOrgId = imsOrgId;
        this.osgiEventMapping = osgiEventMapping;
        this.resourceResolverWrapperFactory = resourceResolverWrapperFactory;
    }

    abstract List<Triple<T, String, Date>> getXdmObjectActorDateTriples(Event var1, ResourceResolverWrapper var2);

    public void handleEvent(Event event) {
        try (ResourceResolverWrapper resourceResolverWrapper = this.resourceResolverWrapperFactory.getWrapper();){
            if (!EventUtil.isEventLocal(event)) {
                this.logger.info("This Event `{}` is not local: Adobe I/O will ignore it, please consider using the `osgiFilter` configuration for better performance", (Object)event);
                return;
            }
            List<XdmEvent> xdmEvents = this.getXdmEvents(event, resourceResolverWrapper);
            if (xdmEvents != null && !xdmEvents.isEmpty()) {
                for (XdmEvent xdmEvent : xdmEvents) {
                    HashMap<String, String> jobProperties = new HashMap<String, String>();
                    jobProperties.put("event_code", this.osgiEventMapping.getEventCode());
                    jobProperties.put("event", this.OBJECT_MAPPER.writeValueAsString((Object)xdmEvent));
                    this.jobManager.addJob("aio/events", jobProperties);
                    this.logger.debug("Adobe I/O Event Job {} added.", jobProperties);
                }
            } else {
                this.logger.debug("No Adobe I/O Event match, ignoring this Event {}", (Object)event);
            }
        }
        catch (Exception e) {
            this.logger.debug("Error `{}`: while processing (event: `{})", new Object[]{e.getMessage(), event, e});
            this.logger.error("Adobe I/O Event Handler processing failed (event: `{}) due to `{}`", (Object)event, (Object)e.getMessage());
        }
    }

    List<XdmEvent> getXdmEvents(Event event, ResourceResolverWrapper resourceResolverWrapper) {
        return this.getXdmObjectActorDateTriples(event, resourceResolverWrapper).stream().map(triple -> XdmUtil.getXdmEvent((XdmObject)triple.getLeft(), (XdmObject)XdmUtil.getAemUser((String)triple.getMiddle()), (Date)triple.getRight(), this.imsOrgId, this.rootUrl.toString(), this.osgiEventMapping.getXdmEventType())).collect(Collectors.toList());
    }

    public <V> Optional<V> getXdmObjectFromResource(Resource resource, Function<Resource, Optional<V>> converter) {
        return XdmUtil.getXdmObjectFromResource(resource, this::isPathOfInterest, converter);
    }

    protected boolean isPathOfInterest(String path) {
        String observedPath = this.osgiEventMapping.getPathFilter();
        return null == observedPath || observedPath.isEmpty() || path.startsWith(observedPath);
    }
}

