/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.event.osgimapping.eventhandler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.osgi.service.event.Event;

public class EventUtil {
    private EventUtil() {
    }

    public static Optional<Date> getEventPropertyAsDate(Event event, String propertyKey) {
        if (propertyKey == null || propertyKey.isEmpty()) {
            return Optional.empty();
        }
        Object datePropertyValue = event.getProperty(propertyKey);
        if (datePropertyValue == null) {
            return Optional.empty();
        }
        if (datePropertyValue instanceof Date) {
            return Optional.of((Date)datePropertyValue);
        }
        if (datePropertyValue instanceof Calendar) {
            Calendar calendar = (Calendar)datePropertyValue;
            return Optional.of(calendar.getTime());
        }
        return Optional.empty();
    }

    public static Optional<String> getEventPropertyAsString(Event event, String propertyKey) {
        if (event.getProperty(propertyKey) != null) {
            return Optional.of(event.getProperty(propertyKey).toString());
        }
        return Optional.empty();
    }

    public static List<String> getEventPropertyAsListOfString(Event event, String propertyKey) {
        if (event.getProperty(propertyKey) == null) {
            return new ArrayList<String>();
        }
        String[] paths = (String[])event.getProperty(propertyKey);
        return Arrays.asList(paths);
    }

    public static boolean isEventProperty(Event event, String key, String expectedValue) {
        return event.getProperty(key) != null && event.getProperty(key).toString().equals(expectedValue);
    }

    public static boolean isEventLocal(Event event) {
        return event.getProperty("event.application") == null;
    }
}

