/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.event.osgimapping.eventhandler;

import com.adobe.aio.aem.event.osgimapping.eventhandler.AdobeIoEventHandler;
import com.adobe.aio.aem.event.osgimapping.eventhandler.OsgiEventMapping;
import com.adobe.aio.aem.event.xdm.aem.PageModification;
import com.adobe.aio.aem.event.xdm.aem.XdmUtil;
import com.adobe.aio.aem.util.ResourceResolverWrapper;
import com.adobe.aio.aem.util.ResourceResolverWrapperFactory;
import com.adobe.aio.exception.AIOException;
import com.adobe.xdm.content.Page;
import com.day.cq.wcm.api.PageEvent;
import com.day.cq.wcm.api.PageModification;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.event.Event;

public class PageModificationEventHandler
extends AdobeIoEventHandler<PageModification> {
    private final PageModification.ModificationType modificationType;

    public PageModificationEventHandler(PageModification.ModificationType modificationType, JobManager jobManager, URL rootUrl, String imsOrgId, OsgiEventMapping osgiEventMapping, ResourceResolverWrapperFactory resourceResolverWrapperFactory) {
        super(jobManager, rootUrl, imsOrgId, osgiEventMapping, resourceResolverWrapperFactory);
        this.modificationType = modificationType;
    }

    @Override
    public List<Triple<PageModification, String, Date>> getXdmObjectActorDateTriples(Event event, ResourceResolverWrapper resourceResolverWrapper) {
        ArrayList<Triple<PageModification, String, Date>> triples = new ArrayList<Triple<PageModification, String, Date>>();
        Iterator<com.day.cq.wcm.api.PageModification> pageModificationIterator = this.getPageModifications(event);
        while (pageModificationIterator.hasNext()) {
            com.day.cq.wcm.api.PageModification pageModification = pageModificationIterator.next();
            if (pageModification.getType().equals((Object)this.modificationType)) {
                Optional<PageModification> xdmPageModification = PageModification.of(this.getXdmPage(pageModification, resourceResolverWrapper).orElse(null), pageModification);
                if (xdmPageModification.isPresent()) {
                    triples.add((Triple<PageModification, String, Date>)Triple.of((Object)((Object)xdmPageModification.get()), (Object)pageModification.getUserId(), (Object)pageModification.getModificationDate()));
                    continue;
                }
                this.logger.debug("Ignoring event `{}` as its Page Modification is not of interest: `{}`.", (Object)event, (Object)pageModification);
                continue;
            }
            this.logger.debug("Ignoring event `{}` as its Page Modification is not of interest: `{}`.", (Object)event, (Object)pageModification);
        }
        return triples;
    }

    private Optional<Page> getXdmPage(com.day.cq.wcm.api.PageModification pageModification, ResourceResolverWrapper resourceResolverWrapper) {
        if (pageModification.getType().equals((Object)PageModification.ModificationType.MOVED)) {
            Resource res = resourceResolverWrapper.getResolver().getResource(pageModification.getDestination());
            return this.getXdmObjectFromResource(res, XdmUtil::getPage);
        }
        if (pageModification.getType().equals((Object)PageModification.ModificationType.DELETED)) {
            return XdmUtil.getDeletedPage(pageModification.getPath(), this::isPathOfInterest);
        }
        Resource res = resourceResolverWrapper.getResolver().getResource(pageModification.getPath());
        return this.getXdmObjectFromResource(res, XdmUtil::getPage);
    }

    private Iterator<com.day.cq.wcm.api.PageModification> getPageModifications(Event event) {
        PageEvent pageEvent = PageEvent.fromEvent((Event)event);
        if (pageEvent != null) {
            if (pageEvent.isLocal()) {
                return pageEvent.getModifications();
            }
            this.logger.debug("Ignoring non-local/cluster PageModification event");
            return Collections.emptyIterator();
        }
        throw new AIOException("This Event " + event + "should be a PageEvent but is not... wrong topic ?");
    }
}

