/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.event.osgimapping.internal;

import com.adobe.aio.aem.event.management.EventMetadataRegistrationService;
import com.adobe.aio.aem.event.management.EventProviderConfigSupplier;
import com.adobe.aio.aem.event.management.EventProviderRegistrationService;
import com.adobe.aio.aem.event.osgimapping.OsgiEventMappingRegistrationService;
import com.adobe.aio.aem.event.osgimapping.OsgiEventMappingStatus;
import com.adobe.aio.aem.event.osgimapping.OsgiEventMappingSupplier;
import com.adobe.aio.aem.event.osgimapping.eventhandler.AdobeIOEventHandlerFactory;
import com.adobe.aio.aem.event.osgimapping.eventhandler.AdobeIoEventHandler;
import com.adobe.aio.aem.event.osgimapping.eventhandler.OsgiEventMapping;
import com.adobe.aio.aem.status.Status;
import com.adobe.aio.aem.util.ResourceResolverWrapperFactory;
import com.adobe.aio.aem.workspace.WorkspaceSupplier;
import java.time.Instant;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={OsgiEventMappingRegistrationService.class}, property={"label = Adobe I/O Events' Osgi Event Mapping Status Supplier Service", "description = Adobe I/O Events'  Osgi Event Mapping Status Supplier Service"})
public class OsgiEventMappingRegistrationServiceImpl
implements OsgiEventMappingRegistrationService {
    private static final int TIME_OUT_MILLISECONDS = 60000;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(12);
    private final Map<String, OsgiEventMappingStatus> osgiEventMappingStatusByEventCode = new ConcurrentHashMap<String, OsgiEventMappingStatus>();
    @Reference(service=OsgiEventMappingSupplier.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, bind="bindEventMetadataSupplier", unbind="unbindEventMetadataSupplier")
    private volatile List<OsgiEventMappingSupplier> osgiEventMappingSuppliers;
    @Reference
    private EventMetadataRegistrationService eventMetadataStatusSupplier;
    @Reference
    private WorkspaceSupplier workspaceSupplier;
    @Reference
    private EventProviderRegistrationService eventProviderRegistrationService;
    @Reference
    private EventProviderConfigSupplier eventProviderConfigSupplier;
    @Reference
    private ResourceResolverWrapperFactory resourceResolverWrapperFactory;
    @Reference
    private JobManager jobManager;
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext context, Map<String, Object> config) {
        this.log.info("activating");
        this.bundleContext = context;
    }

    protected synchronized void bindEventMetadataSupplier(OsgiEventMappingSupplier osgiEventMappingSupplier) {
        this.eventMetadataStatusSupplier.registerEventMetadata(osgiEventMappingSupplier.getConfiguredEventMetadata());
        this.scheduledExecutorService.schedule(() -> this.registerSlingEventHandlerWithRetry(osgiEventMappingSupplier.getOsgiEventMapping()), (long)ThreadLocalRandom.current().nextInt(500, 1000), TimeUnit.MILLISECONDS);
        this.log.debug("binding Adobe I/O Events' Osgi Event Mapping : {} ", (Object)osgiEventMappingSupplier.getConfiguredEventMetadata());
    }

    protected synchronized void unbindEventMetadataSupplier(OsgiEventMappingSupplier osgiEventMappingSupplier) {
        this.log.debug("unbinding Adobe I/O Events' Osgi Event Mapping : {} ", (Object)osgiEventMappingSupplier.getConfiguredEventMetadata());
    }

    public void registerSlingEventHandlerWithRetry(OsgiEventMapping osgiEventMapping) {
        long start = Instant.now().toEpochMilli();
        boolean isUp = false;
        try {
            while (!isUp && Instant.now().toEpochMilli() - start < 60000L) {
                OsgiEventMappingStatus osgiEventMappingStatus = this.registerSlingEventHandler(osgiEventMapping);
                this.osgiEventMappingStatusByEventCode.put(osgiEventMapping.getEventCode(), osgiEventMappingStatus);
                isUp = osgiEventMappingStatus.isUp();
                Thread.sleep(ThreadLocalRandom.current().nextInt(1000, 2000));
            }
        }
        catch (InterruptedException e) {
            this.log.error("Adobe I/O Events' OSGI Handler Registration got interrupted : `{}", (Object)e.getMessage(), (Object)e);
            this.osgiEventMappingStatusByEventCode.put(osgiEventMapping.getEventCode(), new OsgiEventMappingStatus(osgiEventMapping, e));
        }
    }

    private OsgiEventMappingStatus registerSlingEventHandler(OsgiEventMapping osgiEventMapping) {
        try {
            this.workspaceSupplier.getWorkspace().validateAll();
            this.eventProviderRegistrationService.getRegisteredProvider();
            AdobeIoEventHandler eventHandler = this.getEventHandler(osgiEventMapping);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            String[] eventTopics = new String[]{osgiEventMapping.getOsgiTopic()};
            ((Dictionary)props).put("event.topics", eventTopics);
            ((Dictionary)props).put("aio.event.code", osgiEventMapping.getEventCode());
            ((Dictionary)props).put("aio.event.handler", osgiEventMapping.getEventHandlerType());
            ((Dictionary)props).put("aio.event.path.filter", osgiEventMapping.getPathFilter());
            ((Dictionary)props).put("aio.event.xdm.type", osgiEventMapping.getXdmEventType());
            String osgiFilter = osgiEventMapping.getOsgiFilter();
            if (null != osgiFilter && !osgiFilter.isEmpty()) {
                ((Dictionary)props).put("event.filter", osgiFilter);
            }
            ServiceRegistration serviceRegistration = this.bundleContext.registerService(EventHandler.class.getName(), (Object)eventHandler, props);
            this.log.info("Registered a new Adobe I/O Events' OSGI Event Handler ({}) with Adobe I/O Event Metadata: {}", (Object)eventHandler.getClass().getName(), (Object)osgiEventMapping);
            return new OsgiEventMappingStatus(osgiEventMapping, null);
        }
        catch (Exception e) {
            this.log.error("Adobe I/O Events' OSGI Handler Registration failed: `{}", (Object)e.getMessage(), (Object)e);
            return new OsgiEventMappingStatus(osgiEventMapping, e);
        }
    }

    private AdobeIoEventHandler getEventHandler(OsgiEventMapping osgiEventMapping) {
        return AdobeIOEventHandlerFactory.getEventHandler(this.jobManager, this.eventProviderConfigSupplier.getRootUrl(), this.workspaceSupplier.getWorkspace().getImsOrgId(), osgiEventMapping, this.resourceResolverWrapperFactory);
    }

    private void addStatus(String eventCode, OsgiEventMappingStatus eventMetadataStatus) {
        this.osgiEventMappingStatusByEventCode.put(eventCode, eventMetadataStatus);
    }

    public Status getStatus() {
        HashMap<String, Object> details = new HashMap<String, Object>(1);
        try {
            if (this.osgiEventMappingStatusByEventCode.isEmpty()) {
                return new Status("down", null, "No Osgi Event Mapping configuration found (yet?)");
            }
            details.put("size", "" + this.osgiEventMappingStatusByEventCode.size());
            details.put("osgi_event_mappings", this.osgiEventMappingStatusByEventCode);
            boolean isUp = this.osgiEventMappingStatusByEventCode.values().stream().allMatch(OsgiEventMappingStatus::isUp);
            return new Status(isUp, details);
        }
        catch (Exception e) {
            return new Status("down", details, (Throwable)e);
        }
    }
}

