/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.event.xdm.aem;

import com.adobe.xdm.content.Page;
import com.day.cq.wcm.api.PageModification;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import java.util.Optional;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PageModification
extends Page {
    public static final String PAGE_MODIFICATION_TYPE = "pageModification";
    private final String movedFromPath;
    private final String above;
    private final String vid;
    private final Date modificationDate;
    private final Set<String> modificationPaths;
    private final PageModification.ModificationType modificationType;

    private PageModification(Page page, PageModification.ModificationType modificationType, String vid, String movedFromPath, String above, Date md, Set<String> modificationPaths) {
        this.setTitle(page.getTitle());
        this.setId(page.getId());
        this.setPath(page.getPath());
        this.setVersion(page.getVersion());
        this.setType(PAGE_MODIFICATION_TYPE);
        this.modificationType = modificationType;
        this.vid = vid;
        this.movedFromPath = movedFromPath;
        this.above = above;
        this.modificationDate = md == null ? new Date() : md;
        this.modificationPaths = modificationPaths;
    }

    public static Optional<PageModification> of(Page page, com.day.cq.wcm.api.PageModification pageModification) {
        if (page == null) {
            return Optional.empty();
        }
        if (pageModification.getType().equals((Object)PageModification.ModificationType.MOVED)) {
            return Optional.of(new PageModification(page, pageModification.getType(), pageModification.getVersionId(), pageModification.getPath(), pageModification.getAbove(), pageModification.getModificationDate(), pageModification.getModificationPaths()));
        }
        return Optional.of(new PageModification(page, pageModification.getType(), pageModification.getVersionId(), null, pageModification.getAbove(), pageModification.getModificationDate(), pageModification.getModificationPaths()));
    }

    @JsonProperty(value="pageModification:moveFromPath")
    public String getMovedFromPath() {
        return this.movedFromPath;
    }

    @JsonProperty(value="pageModification:above")
    public String getAbove() {
        return this.above;
    }

    @JsonProperty(value="pageModification:vid")
    public String getVid() {
        return this.vid;
    }

    @JsonProperty(value="pageModification:modificationDate")
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @JsonProperty(value="pageModification:modificationPaths")
    public Set<String> getModificationPaths() {
        return this.modificationPaths;
    }

    @JsonProperty(value="pageModification:title")
    public String getTitle() {
        return super.getTitle();
    }

    @JsonProperty(value="pageModification:path")
    public String getPath() {
        return super.getPath();
    }

    @JsonProperty(value="pageModification:type")
    public String getModificationSubType() {
        return this.modificationType.toString();
    }

    @JsonProperty(value="pageModification:version")
    public String getVersion() {
        return super.getVersion();
    }

    @JsonIgnore
    public PageModification.ModificationType getModificationType() {
        return this.modificationType;
    }
}

