/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.event.xdm.aem;

import com.adobe.aio.aem.event.xdm.event.AemPageModificationEvent;
import com.adobe.aio.exception.AIOException;
import com.adobe.xdm.XdmObject;
import com.adobe.xdm.assets.Asset;
import com.adobe.xdm.common.XdmEvent;
import com.adobe.xdm.content.ContentRepository;
import com.adobe.xdm.content.Page;
import com.adobe.xdm.event.AemAssetCreatedEvent;
import com.adobe.xdm.event.AemAssetDeletedEvent;
import com.adobe.xdm.event.AemAssetUpdatedEvent;
import com.adobe.xdm.event.AemPagePublishedEvent;
import com.adobe.xdm.event.AemPageUnpublishedEvent;
import com.adobe.xdm.event.OsgiEmittedEvent;
import com.adobe.xdm.extensions.aem.AemUser;
import com.adobe.xdm.extensions.ims.ImsOrg;
import java.lang.reflect.InvocationTargetException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class XdmUtil {
    public static final String URN_OBJECT_ID_PREFIX = "urn:aaid:aem:";
    public static final String URN_EVENT_ID_PREFIX = "urn:oeid:aem:";
    public static final String PAGE_PRIMARY_TYPE = "cq:Page";
    public static final String NON_AVAILABLE = "N/A";

    private XdmUtil() {
    }

    public static XdmEvent getXdmEvent(String xdmEventType) {
        try {
            Class xdmClassDefinition;
            if (xdmEventType.equals(OsgiEmittedEvent.class.getCanonicalName())) {
                xdmClassDefinition = OsgiEmittedEvent.class;
            } else if (xdmEventType.equals(AemAssetCreatedEvent.class.getCanonicalName())) {
                xdmClassDefinition = AemAssetCreatedEvent.class;
            } else if (xdmEventType.equals(AemAssetUpdatedEvent.class.getCanonicalName())) {
                xdmClassDefinition = AemAssetUpdatedEvent.class;
            } else if (xdmEventType.equals(AemAssetDeletedEvent.class.getCanonicalName())) {
                xdmClassDefinition = AemAssetDeletedEvent.class;
            } else if (xdmEventType.equals(AemPagePublishedEvent.class.getCanonicalName())) {
                xdmClassDefinition = AemPagePublishedEvent.class;
            } else if (xdmEventType.equals(AemPageUnpublishedEvent.class.getCanonicalName())) {
                xdmClassDefinition = AemPageUnpublishedEvent.class;
            } else if (xdmEventType.equals(AemPageModificationEvent.class.getCanonicalName())) {
                xdmClassDefinition = AemPageModificationEvent.class;
            } else {
                throw new ClassNotFoundException("Unexpected/unimplemented/unmapped xdm event class: " + xdmEventType);
            }
            return (XdmEvent)xdmClassDefinition.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AIOException("Invalid Adobe I/O Events' OSGI Event Mapping `aio.xdm.event.type`. " + xdmEventType + " could not be used due to " + e.getMessage(), (Throwable)e);
        }
    }

    public static AemUser getAemUser(String userId) {
        AemUser aemUser = new AemUser();
        if (userId != null) {
            aemUser.setId(userId);
        } else {
            aemUser.setId(NON_AVAILABLE);
        }
        return aemUser;
    }

    private static ContentRepository getContentRepository(String rootUrl) {
        ContentRepository aemInstance = new ContentRepository();
        aemInstance.setRoot(rootUrl);
        return aemInstance;
    }

    public static Optional<Asset> getDeletedAsset(String path, Predicate<String> isPathOfInterest) {
        if (!isPathOfInterest.test(path)) {
            return Optional.empty();
        }
        Asset asset = new Asset();
        asset.setAssetId(NON_AVAILABLE);
        asset.setPath(path);
        return Optional.of(asset);
    }

    public static Optional<Asset> getAsset(Resource resource) {
        Resource metadataResource;
        if (!XdmUtil.isPrimaryTypeAsset(resource)) {
            return Optional.empty();
        }
        Asset asset = new Asset();
        asset.setPath(resource.getPath());
        asset.setAssetName(resource.getName());
        asset.setAssetId(XdmUtil.getNodeJcrUuid(resource).orElse(NON_AVAILABLE));
        Resource jcrContent = resource.getChild("jcr:content");
        if (jcrContent != null && (metadataResource = jcrContent.getChild("metadata")) != null) {
            ValueMap metadataValueMap = metadataResource.getValueMap();
            asset.setFormat((String)metadataValueMap.get("dc:format", String.class));
            String etag = (String)metadataValueMap.get("dam:sha1", String.class);
            if (etag == null) {
                SecureRandom random = new SecureRandom();
                etag = System.currentTimeMillis() + "-" + random.nextInt(1000000);
            }
            asset.setEtag(etag);
        }
        return Optional.of(asset);
    }

    public static Optional<String> getNodeJcrUuid(Resource resource) {
        return XdmUtil.getNodePrefixedPropertyValue(resource, "jcr:uuid", URN_OBJECT_ID_PREFIX);
    }

    public static boolean isPrimaryTypePage(Resource resource) {
        return XdmUtil.isNodeProperty(resource, "jcr:primaryType", PAGE_PRIMARY_TYPE);
    }

    public static boolean isPrimaryTypeAsset(Resource resource) {
        return XdmUtil.isNodeProperty(resource, "jcr:primaryType", "dam:Asset");
    }

    private static boolean isNodeProperty(Resource resource, String propertyName, String expectedPropertyValue) {
        return expectedPropertyValue.equals(XdmUtil.getNodePropertyValue(resource, propertyName).orElse(null));
    }

    private static Optional<String> getNodePropertyValue(Resource resource, String propertyName) {
        return XdmUtil.getNodePrefixedPropertyValue(resource, propertyName, null);
    }

    private static Optional<String> getNodePrefixedPropertyValue(Resource resource, String propertyName, String valuePrefix) {
        if (resource == null) {
            return Optional.empty();
        }
        Node node = (Node)resource.adaptTo(Node.class);
        if (node == null) {
            return Optional.empty();
        }
        try {
            if (!node.hasProperty(propertyName)) {
                return Optional.empty();
            }
            String value = node.getProperty(propertyName).getString();
            return Optional.of(valuePrefix != null ? valuePrefix + value : value);
        }
        catch (RepositoryException e) {
            throw new AIOException("Could not get the value of " + propertyName, (Throwable)e);
        }
    }

    public static ImsOrg getImsOrg(String imsOrgId) {
        ImsOrg imsOrg = new ImsOrg();
        imsOrg.setImsOrgId(imsOrgId);
        return imsOrg;
    }

    public static XdmEvent getXdmEvent(XdmObject object, XdmObject actor, Date publicationDate, String imsOrgId, String rootUrl, String xdmEventType) {
        XdmEvent xdmEvent = XdmUtil.getXdmEvent(xdmEventType);
        xdmEvent.setTo((XdmObject)XdmUtil.getImsOrg(imsOrgId));
        xdmEvent.setGenerator((XdmObject)XdmUtil.getContentRepository(rootUrl));
        xdmEvent.setId(URN_EVENT_ID_PREFIX + UUID.randomUUID().toString());
        xdmEvent.setObject(object);
        xdmEvent.setPublished(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX", Locale.US).format(publicationDate));
        xdmEvent.setActor(actor);
        return xdmEvent;
    }

    public static Optional<Page> getPage(Resource cqPageResource) {
        if (!XdmUtil.isPrimaryTypePage(cqPageResource) || cqPageResource == null) {
            return Optional.empty();
        }
        Page page = new Page();
        page.setId(XdmUtil.getNodeJcrUuid(cqPageResource.getChild("jcr:content")).orElse(NON_AVAILABLE));
        page.setVersion(XdmUtil.getNodePrefixedPropertyValue(cqPageResource.getChild("jcr:content"), "jcr:versionHistory", null).orElse(NON_AVAILABLE));
        page.setPath(cqPageResource.getPath());
        com.day.cq.wcm.api.Page cQPage = (com.day.cq.wcm.api.Page)cqPageResource.adaptTo(com.day.cq.wcm.api.Page.class);
        page.setTitle(cQPage != null ? cQPage.getTitle() : "");
        return Optional.of(page);
    }

    public static Optional<Page> getDeletedPage(String path, Predicate<String> isPathOfInterest) {
        if (!isPathOfInterest.test(path)) {
            return Optional.empty();
        }
        Page page = new Page();
        page.setId(NON_AVAILABLE);
        page.setVersion(NON_AVAILABLE);
        page.setPath(path);
        return Optional.of(page);
    }

    public static <T> Optional<T> getXdmObjectFromResource(Resource resource, Predicate<String> isPathOfInterest, Function<Resource, Optional<T>> converter) {
        if (!isPathOfInterest.test(resource.getPath())) {
            return Optional.empty();
        }
        return converter.apply(resource);
    }
}

