/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.event.publish;

import com.adobe.aio.aem.event.publish.EventPublishService;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JobConsumer.class}, immediate=true, property={"job.topics=aio/events", "label = Adobe I/O Events Publish Job Consumer", "description =Adobe I/O Events Publish Job Consumer"})
public class EventPublishJobConsumer
implements JobConsumer {
    public static final String AIO_EVENTS_JOB_TOPIC = "aio/events";
    public static final String AIO_EVENT_PROPERTY = "event";
    public static final String AIO_EVENT_CODE_PROPERTY = "event_code";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private EventPublishService eventPublishService;

    public JobConsumer.JobResult process(Job job) {
        try {
            String eventPayload = (String)job.getProperty(AIO_EVENT_PROPERTY);
            String eventCode = (String)job.getProperty(AIO_EVENT_CODE_PROPERTY);
            if (eventPayload == null || eventPayload.isEmpty()) {
                this.log.error("Adobe I/O Events Publish Job Consumer `{}` is missing an event payload. Marking it as `CANCEL`", (Object)job);
                return JobConsumer.JobResult.CANCEL;
            }
            if (eventCode == null) {
                this.log.error("Adobe I/O Events Publish Job Consumer `{}` is missing an event code. Marking it as `CANCEL`", (Object)job);
                return JobConsumer.JobResult.CANCEL;
            }
            this.eventPublishService.publishEvent(eventPayload, eventCode);
            this.log.info("Adobe I/O Events Publish Job Consumer completed: published `{}` event: `{}`", (Object)eventCode, (Object)eventPayload);
            return JobConsumer.JobResult.OK;
        }
        catch (Exception e) {
            this.log.error("Adobe I/O Events Publish Job Consumer `{}` processing failed: `{}", new Object[]{job, e.getMessage(), e});
            return JobConsumer.JobResult.FAILED;
        }
    }
}

