/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.event.publish.internal;

import com.adobe.aio.aem.event.management.EventProviderRegistrationService;
import com.adobe.aio.aem.event.publish.EventPublishService;
import com.adobe.aio.aem.event.publish.ocd.ApiPublishingConfig;
import com.adobe.aio.aem.status.Status;
import com.adobe.aio.aem.workspace.WorkspaceSupplier;
import com.adobe.aio.event.publish.PublishService;
import java.time.Instant;
import java.util.HashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EventPublishService.class}, property={"label = Adobe I/O Events' Event Publish Service", "description = Adobe I/O Events' Event Publish Service"})
@Designate(ocd=ApiPublishingConfig.class)
public class EventPublishServiceImpl
implements EventPublishService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private WorkspaceSupplier workspaceSupplier;
    @Reference
    private EventProviderRegistrationService eventProviderRegistrationService;
    private String publishUrl;

    @Activate
    @Modified
    protected void activate(ApiPublishingConfig configuration) {
        this.log.info("activating");
        this.publishUrl = configuration.aio_publish_url();
    }

    public Status getStatus() {
        HashMap<String, Object> details = new HashMap<String, Object>(1);
        details.put("aio_ping_published", false);
        try {
            details.put("aio_publish_url", this.publishUrl);
            details.put("workspace_status", this.workspaceSupplier.getStatus());
            details.put("aio_event_provider_status", this.eventProviderRegistrationService.getStatus());
            this.publishEvent("{\"publisher\":\"AEM status check\",\"time\":\"" + Instant.now().toEpochMilli() + "\"}", "ping");
            details.put("aio_ping_published", true);
            return new Status("up", details);
        }
        catch (Exception e) {
            return new Status("down", details, (Throwable)e);
        }
    }

    @Override
    public void publishEvent(String eventJsonPayload, String adobeIoEventCode) {
        PublishService publishService = PublishService.builder().workspace(this.workspaceSupplier.getWorkspace()).url(this.publishUrl).build();
        publishService.publishRawEvent(this.eventProviderRegistrationService.getRegisteredProvider().getId(), adobeIoEventCode, eventJsonPayload);
    }
}

