/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.event.management.internal;

import com.adobe.aio.aem.event.management.EventMetadataRegistrationService;
import com.adobe.aio.aem.event.management.EventMetadataStatus;
import com.adobe.aio.aem.event.management.EventMetadataSupplier;
import com.adobe.aio.aem.event.management.EventProviderRegistrationService;
import com.adobe.aio.aem.status.Status;
import com.adobe.aio.event.management.model.EventMetadata;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={EventMetadataRegistrationService.class}, property={"label = Adobe I/O Events' Event Metadata Registration Service", "description = Adobe I/O Events' Event Metadata Registration Service"})
public class EventMetadataRegistrationServiceImpl
implements EventMetadataRegistrationService {
    private static final int TIME_OUT_MILLISECONDS = 60000;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(12);
    private final Map<String, EventMetadataStatus> eventMetadataStatusByEventCode = new ConcurrentHashMap<String, EventMetadataStatus>();
    @Reference(service=EventMetadataSupplier.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, bind="bindEventMetadataSupplier", unbind="unbindEventMetadataSupplier")
    private volatile List<EventMetadataSupplier> eventMetadataSupplierList;
    @Reference
    EventProviderRegistrationService eventProviderRegistrationService;
    private BundleContext bundleContext;

    protected synchronized void bindEventMetadataSupplier(EventMetadataSupplier eventMetadataSupplier) {
        EventMetadata configuredEventMetadata = eventMetadataSupplier.getConfiguredEventMetadata();
        this.registerEventMetadata(configuredEventMetadata);
        this.log.debug("binding Adobe I/O Events' Metadata : {} ", (Object)configuredEventMetadata);
    }

    @Override
    public void registerEventMetadata(EventMetadata configuredEventMetadata) {
        this.scheduledExecutorService.schedule(() -> this.registerEventMetadataWithRetry(configuredEventMetadata), (long)ThreadLocalRandom.current().nextInt(500, 1000), TimeUnit.MILLISECONDS);
    }

    public void registerEventMetadataWithRetry(EventMetadata configuredEventMetadata) {
        long start = Instant.now().toEpochMilli();
        boolean isUp = false;
        try {
            while (!isUp && Instant.now().toEpochMilli() - start < 60000L) {
                EventMetadataStatus eventMetadataStatus = this.registerEventMetadataSync(configuredEventMetadata);
                this.eventMetadataStatusByEventCode.put(configuredEventMetadata.getEventCode(), eventMetadataStatus);
                isUp = eventMetadataStatus.isUp();
                Thread.sleep(ThreadLocalRandom.current().nextInt(1000, 2000));
            }
        }
        catch (InterruptedException e) {
            this.log.error("Adobe I/O Events Metadata Registration got interrupted : `{}", (Object)e.getMessage(), (Object)e);
            this.eventMetadataStatusByEventCode.put(configuredEventMetadata.getEventCode(), new EventMetadataStatus(configuredEventMetadata, null, e));
        }
    }

    private EventMetadataStatus registerEventMetadataSync(EventMetadata configuredEventMetadata) {
        EventMetadata registeredEventMetadata = null;
        try {
            registeredEventMetadata = this.eventProviderRegistrationService.registerEventMetadata(configuredEventMetadata);
            this.log.info("Adobe I/O Events Metadata Registration completed: registered event metadata `{}`", (Object)registeredEventMetadata);
            return new EventMetadataStatus(configuredEventMetadata, registeredEventMetadata);
        }
        catch (Exception e) {
            this.log.error("Adobe I/O Events Metadata Registration processing failed: `{}", (Object)e.getMessage(), (Object)e);
            return new EventMetadataStatus(configuredEventMetadata, registeredEventMetadata, e);
        }
    }

    protected synchronized void unbindEventMetadataSupplier(EventMetadataSupplier eventMetadataSupplier) {
        this.log.debug("unbinded Adobe I/O Events' Event Metadata : {} ", (Object)eventMetadataSupplier.getConfiguredEventMetadata());
    }

    private void addStatus(String eventCode, EventMetadataStatus eventMetadataStatus) {
        this.eventMetadataStatusByEventCode.put(eventCode, eventMetadataStatus);
    }

    public Status getStatus() {
        HashMap<String, Object> details = new HashMap<String, Object>(1);
        try {
            if (this.eventMetadataStatusByEventCode.isEmpty()) {
                return new Status("down", null, "No event metadata configuration found (yet?)");
            }
            details.put("size", "" + this.eventMetadataStatusByEventCode.size());
            details.put("event_metadata", this.eventMetadataStatusByEventCode);
            boolean isUp = this.eventMetadataStatusByEventCode.values().stream().allMatch(EventMetadataStatus::isUp);
            return new Status(isUp, details);
        }
        catch (Exception e) {
            return new Status("down", details, (Throwable)e);
        }
    }
}

