/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.event.management.internal;

import com.adobe.aio.aem.event.management.EventMetadataRegistrationService;
import com.adobe.aio.aem.event.management.EventMetadataSupplier;
import com.adobe.aio.aem.event.management.EventProviderRegistrationService;
import com.adobe.aio.aem.event.management.ocd.EventMetadataConfig;
import com.adobe.aio.event.management.model.EventMetadata;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={EventMetadataSupplier.class}, property={"label = Adobe I/O Events' Event Metadata Supplier Service", "description = Adobe I/O Events' Event Metadata Supplier Service"})
@Designate(ocd=EventMetadataConfig.class, factory=true)
public class EventMetadataSupplierImpl
implements EventMetadataSupplier {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = new ObjectMapper();
    @Reference
    JobManager jobManager;
    @Reference
    EventMetadataRegistrationService eventMetadataStatusSupplier;
    @Reference
    EventProviderRegistrationService eventProviderRegistrationService;
    private EventMetadata configuredEventMetadata;

    @Activate
    protected void activate(EventMetadataConfig eventMetadataConfig) {
        this.configuredEventMetadata = EventMetadata.builder().description(eventMetadataConfig.aio_event_description()).label(eventMetadataConfig.aio_event_label()).eventCode(eventMetadataConfig.aio_event_code()).build();
    }

    @Override
    public EventMetadata getConfiguredEventMetadata() {
        return this.configuredEventMetadata;
    }
}

