/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.event.management.internal;

import com.adobe.aio.aem.event.management.EventProviderConfigSupplier;
import com.adobe.aio.aem.event.management.ocd.EventProviderConfig;
import com.adobe.aio.aem.status.Status;
import com.adobe.aio.aem.util.ResourceResolverWrapper;
import com.adobe.aio.aem.util.ResourceResolverWrapperFactory;
import com.adobe.aio.event.management.model.ProviderInputModel;
import com.adobe.aio.exception.AIOException;
import com.day.cq.commons.Externalizer;
import java.net.URL;
import java.util.HashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={EventProviderConfigSupplier.class}, property={"label = Adobe I/O Events' Provider Config Supplier", "description = Adobe I/O Events' Provider Config Supplier"})
@Designate(ocd=EventProviderConfig.class)
public class EventProviderConfigSupplierImpl
implements EventProviderConfigSupplier {
    static final String AEM_PROVIDER_METADATA_ID = "aem";
    static final String AEM_CLOUD_DOMAIN_SUFFIX = ".adobeaemcloud.com";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    Externalizer externalizerService;
    @Reference
    private ResourceResolverWrapperFactory resourceResolverWrapperFactory;
    private EventProviderConfig eventProviderConfig;
    private URL rootUrl;

    static String getInstanceId(URL url) {
        int indexOfAdobeAemCloudDomain = url.getHost().lastIndexOf(AEM_CLOUD_DOMAIN_SUFFIX);
        if (indexOfAdobeAemCloudDomain > 1) {
            return url.getHost().substring(0, indexOfAdobeAemCloudDomain);
        }
        if (url.getHost().contains("localhost")) {
            return url.getHost() + url.getPort();
        }
        return url.getHost();
    }

    @Activate
    @Modified
    protected void activate(EventProviderConfig eventProviderConfig) {
        this.eventProviderConfig = eventProviderConfig;
    }

    public Status getStatus() {
        HashMap<String, String> details = new HashMap<String, String>(1);
        Exception error = null;
        try {
            details.put("externalizer_name", this.eventProviderConfig.externalizer_name());
            details.put("root_url", this.getRootUrl() != null ? this.getRootUrl().toString() : null);
            details.put("provider_input_model", (String)this.getProviderInputModel());
        }
        catch (Exception e) {
            this.log.error("Adobe I/O Events' Provider Config Supplier activation error: {}", (Object)e.getMessage(), (Object)e);
            error = e;
        }
        return new Status(details, (Throwable)error);
    }

    @Override
    public ProviderInputModel getProviderInputModel() {
        return this.getProviderInputModel(this.eventProviderConfig, this.getRootUrl());
    }

    @Override
    public URL getRootUrl() {
        if (this.rootUrl == null) {
            this.rootUrl = this.resolveRootUrl();
        }
        return this.rootUrl;
    }

    private URL resolveRootUrl() {
        URL uRL;
        block8: {
            ResourceResolverWrapper resourceResolverWrapper = this.resourceResolverWrapperFactory.getWrapper();
            try {
                uRL = new URL(this.externalizerService.externalLink(resourceResolverWrapper.getResolver(), this.eventProviderConfig.externalizer_name(), "/"));
                if (resourceResolverWrapper == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceResolverWrapper != null) {
                        try {
                            resourceResolverWrapper.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new AIOException("Cannot look up the Adobe I/O Event providers instanceId due to " + e.getMessage(), (Throwable)e);
                }
            }
            resourceResolverWrapper.close();
        }
        return uRL;
    }

    private ProviderInputModel getProviderInputModel(EventProviderConfig providerConfig, URL rootUrl) {
        String instanceId = EventProviderConfigSupplierImpl.getInstanceId(rootUrl);
        return ProviderInputModel.builder().instanceId(instanceId).providerMetadataId(AEM_PROVIDER_METADATA_ID).label(providerConfig.aio_provider_label().isEmpty() ? instanceId : providerConfig.aio_provider_label()).description(providerConfig.aio_provider_description().isEmpty() ? "AEM " + instanceId : providerConfig.aio_provider_description()).docsUrl(providerConfig.aio_provider_docs_url()).eventDeliveryFormat(providerConfig.event_delivery_format()).build();
    }
}

