/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.event.management.internal;

import com.adobe.aio.aem.event.management.EventProviderConfigSupplier;
import com.adobe.aio.aem.event.management.EventProviderRegistrationService;
import com.adobe.aio.aem.event.management.ocd.ApiManagementConfig;
import com.adobe.aio.aem.status.Status;
import com.adobe.aio.aem.workspace.WorkspaceSupplier;
import com.adobe.aio.event.management.ProviderService;
import com.adobe.aio.event.management.model.EventMetadata;
import com.adobe.aio.event.management.model.Provider;
import com.adobe.aio.exception.AIOException;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"label = Adobe I/O Events' Provider Registration Service", "description = Adobe I/O Events' Provider Provider Registration Servic"})
@Designate(ocd=ApiManagementConfig.class)
public class EventProviderRegistrationServiceImpl
implements EventProviderRegistrationService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private WorkspaceSupplier workspaceSupplier;
    @Reference
    private EventProviderConfigSupplier eventProviderConfigSupplier;
    private ProviderService providerService;
    private String providerId;
    private String apiManagementUrl;

    @Activate
    protected void activate(ApiManagementConfig config) {
        this.apiManagementUrl = config.aio_api_management_url();
    }

    public Status getStatus() {
        HashMap<String, Object> details = new HashMap<String, Object>(1);
        try {
            details.put("workspace_status", this.workspaceSupplier.getStatus());
            details.put("provider_config_status", this.eventProviderConfigSupplier.getStatus());
            details.put("api_management_url", this.apiManagementUrl);
            details.put("provider_already_registered", this.isProviderRegistered());
            details.put("registered_provider", this.getRegisteredProvider());
            return new Status("up", details);
        }
        catch (Exception e) {
            return new Status("down", details, (Throwable)e);
        }
    }

    @Override
    public EventMetadata registerEventMetadata(EventMetadata eventMetadata) {
        return (EventMetadata)this.getProviderService().createEventMetadata(this.getRegisteredProvider().getId(), eventMetadata).orElseThrow(() -> new AIOException("Error creating a new Adobe I/O Events Metadata, your workspace or provider metadata are unknown to Adobe I/O Events. Please check your configurations."));
    }

    private Provider registerProvider() {
        Optional createdProvider = this.getProviderService().createOrUpdateProvider(this.eventProviderConfigSupplier.getProviderInputModel());
        if (createdProvider.isPresent()) {
            this.providerId = ((Provider)createdProvider.get()).getId();
            return (Provider)createdProvider.get();
        }
        throw new AIOException("Error creating a new Adobe I/O Events Provider, your workspace or provider metadata are unknown to Adobe I/O Events. Please check your configurations.");
    }

    @Override
    public synchronized Provider getRegisteredProvider() {
        if (!this.isProviderRegistered()) {
            this.log.warn("The Adobe I/O Events Provider was not registered yet, trying registering it...");
            return this.registerProvider();
        }
        return (Provider)this.getProviderService().findProviderById(this.providerId).orElseThrow(() -> new AIOException("Error looking up the Adobe I/O Events Provider previously successfully registered."));
    }

    private boolean isProviderRegistered() {
        return !StringUtils.isEmpty((CharSequence)this.providerId);
    }

    private ProviderService getProviderService() {
        if (this.providerService == null) {
            this.providerService = ProviderService.builder().workspace(this.workspaceSupplier.getWorkspace()).url(this.apiManagementUrl).build();
        }
        return this.providerService;
    }
}

