/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.status;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.osgi.framework.FrameworkUtil;

public class Status {
    public static final String UP = "up";
    public static final String DOWN = "down";
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="details")
    private Object details;
    @JsonProperty(value="error")
    private String error;
    @JsonProperty(value="version")
    private String version;

    public Status(boolean status, Object details) {
        this(status ? UP : DOWN, details);
    }

    public Status(Object details, Throwable error) {
        this(error == null ? UP : DOWN, details, error);
    }

    public Status(String status, Object details) {
        this.status = status;
        this.details = details;
        this.version = FrameworkUtil.getBundle(this.getClass()).getVersion().toString();
    }

    public Status(String status, Object details, String error) {
        this.status = status;
        this.details = details;
        this.error = error;
        this.version = FrameworkUtil.getBundle(this.getClass()).getVersion().toString();
    }

    public Status(String status, Object details, Throwable error) {
        this(status, details, error != null ? error.getClass().getSimpleName() + ": " + error.getMessage() : null);
    }

    public String getStatus() {
        return this.status;
    }

    public Object getDetails() {
        return this.details;
    }

    public String getError() {
        return this.error;
    }

    public String toString() {
        return "HC{status='" + this.status + '\'' + ", details=" + this.details + ", error='" + this.error + '\'' + '}';
    }
}

