/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.util;

import com.adobe.aio.exception.AIOException;
import java.util.Collections;
import java.util.Map;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;

public class ResourceResolverWrapper
implements AutoCloseable {
    String USER_MAPPED_SUB_SERVICE_NAME = "aio_service";
    Map<String, Object> SERVICE_AUTH_INFO = Collections.singletonMap("sling.service.subservice", this.USER_MAPPED_SUB_SERVICE_NAME);
    ResourceResolver resolver;
    ResourceResolverFactory factory;

    public ResourceResolverWrapper(ResourceResolverFactory rrf) {
        this.factory = rrf;
    }

    @Override
    public void close() throws Exception {
        if (this.resolver != null) {
            this.resolver.close();
        }
    }

    public ResourceResolver getResolver() {
        if (this.resolver == null) {
            try {
                this.resolver = this.factory.getServiceResourceResolver(this.SERVICE_AUTH_INFO);
            }
            catch (LoginException e) {
                throw new AIOException("Configuration error, Could not access the resource resolver associated with the system-user `" + this.USER_MAPPED_SUB_SERVICE_NAME + "` due to : " + e.getMessage(), (Throwable)e);
            }
        }
        return this.resolver;
    }
}

