/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.aem.workspace.internal;

import com.adobe.aio.aem.status.Status;
import com.adobe.aio.aem.workspace.WorkspaceSupplier;
import com.adobe.aio.aem.workspace.ocd.WorkspaceConfig;
import com.adobe.aio.util.WorkspaceUtil;
import com.adobe.aio.workspace.Workspace;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkspaceSupplier.class}, property={"label = Adobe I/O Events' Workspace Supplier", "description = Adobe I/O Events' Workspace Supplier"})
@Designate(ocd=WorkspaceConfig.class)
public class WorkspaceSupplierImpl
implements WorkspaceSupplier {
    private final Logger log = LoggerFactory.getLogger(WorkspaceSupplierImpl.class);
    private WorkspaceConfig workspaceConfig;

    @Activate
    @Modified
    protected void activate(WorkspaceConfig config) {
        this.log.debug("activating...");
        this.workspaceConfig = config;
    }

    @Override
    public Status getStatus() {
        HashMap<String, Workspace> details = new HashMap<String, Workspace>();
        try {
            Workspace workspace = this.getWorkspace();
            details.put("workspace", workspace);
            workspace.validateAll();
            return new Status("up", details);
        }
        catch (IllegalArgumentException e) {
            return new Status("down", details, e);
        }
    }

    @Override
    public Workspace getWorkspace() {
        return WorkspaceUtil.getWorkspaceBuilder(this.getAuthConfigMap(this.workspaceConfig)).build();
    }

    private Map<String, String> getAuthConfigMap(WorkspaceConfig config) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.putIfNotBlank(map, "aio_api_key", config.aio_api_key());
        this.putIfNotBlank(map, "aio_consumer_org_id", config.aio_consumer_org_id());
        this.putIfNotBlank(map, "aio_ims_org_id", config.aio_ims_org_id());
        this.putIfNotBlank(map, "aio_ims_url", config.aio_ims_url());
        this.putIfNotBlank(map, "aio_project_id", config.aio_project_id());
        this.putIfNotBlank(map, "aio_workspace_id", config.aio_workspace_id());
        this.putIfNotBlank(map, "aio_credential_id", config.aio_credential_id());
        this.putIfNotBlank(map, "aio_client_secret", config.aio_client_secret());
        this.putIfNotBlank(map, "aio_technical_account_id", config.aio_technical_account_id());
        this.putIfNotBlank(map, "aio_meta_scopes", config.aio_meta_scopes());
        this.putIfNotBlank(map, "aio_encoded_pkcs8", config.aio_encoded_pkcs8());
        this.putIfNotBlank(map, "aio_oauth_scopes", config.aio_oauth_scopes());
        return map;
    }

    private void putIfNotBlank(Map<String, String> map, String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            map.put(key, value);
        }
    }
}

