/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.auth;

import com.adobe.aio.auth.Context;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.security.PrivateKey;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JwtContext
implements Context {
    public static final String TECHNICAL_ACCOUNT_ID = "aio_technical_account_id";
    public static final String META_SCOPES = "aio_meta_scopes";
    private final String technicalAccountId;
    private final Set<String> metascopes;
    private final String clientSecret;
    private final PrivateKey privateKey;

    public JwtContext(String clientSecret, String technicalAccountId, Set<String> metascopes, PrivateKey privateKey) {
        this.clientSecret = clientSecret;
        this.technicalAccountId = technicalAccountId;
        this.metascopes = metascopes;
        this.privateKey = privateKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.clientSecret)) {
            throw new IllegalStateException("Your `JwtContext` is missing a clientSecret");
        }
        if (StringUtils.isEmpty((CharSequence)this.technicalAccountId)) {
            throw new IllegalStateException("Your `JwtContext` is missing a technicalAccountId");
        }
        if (this.metascopes.isEmpty()) {
            throw new IllegalStateException("Your `JwtContext` is missing a metascope");
        }
        if (this.privateKey == null) {
            throw new IllegalStateException("Your `JwtContext` is missing a privateKey");
        }
    }

    public String getTechnicalAccountId() {
        return this.technicalAccountId;
    }

    public Set<String> getMetascopes() {
        return this.metascopes;
    }

    @JsonIgnore
    public String getClientSecret() {
        return this.clientSecret;
    }

    public boolean isClientSecretDefined() {
        return !StringUtils.isEmpty((CharSequence)this.clientSecret);
    }

    @JsonIgnore
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public boolean isPrivateKeyDefined() {
        return this.privateKey != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JwtContext that = (JwtContext)o;
        if (!Objects.equals(this.technicalAccountId, that.technicalAccountId)) {
            return false;
        }
        if (!Objects.equals(this.metascopes, that.metascopes)) {
            return false;
        }
        if (!Objects.equals(this.clientSecret, that.clientSecret)) {
            return false;
        }
        return Objects.equals(this.privateKey, that.privateKey);
    }

    public int hashCode() {
        int result = this.technicalAccountId != null ? this.technicalAccountId.hashCode() : 0;
        result = 31 * result + (this.metascopes != null ? this.metascopes.hashCode() : 0);
        result = 31 * result + (this.clientSecret != null ? this.clientSecret.hashCode() : 0);
        result = 31 * result + (this.privateKey != null ? this.privateKey.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JwtContext{technicalAccountId='" + this.technicalAccountId + '\'' + ", metascopes=" + this.metascopes + '}';
    }

    public static class Builder {
        private String clientSecret;
        private String technicalAccountId;
        private PrivateKey privateKey;
        private final Set<String> metascopes = new HashSet<String>();

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder technicalAccountId(String technicalAccountId) {
            this.technicalAccountId = technicalAccountId;
            return this;
        }

        public Builder addMetascope(String metascope) {
            this.metascopes.add(metascope);
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public JwtContext build() {
            return new JwtContext(this.clientSecret, this.technicalAccountId, this.metascopes, this.privateKey);
        }
    }
}

