/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.auth;

import com.adobe.aio.auth.Context;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class OAuthContext
implements Context {
    public static final String SCOPES = "aio_oauth_scopes";
    private final String clientSecret;
    private final Set<String> scopes;

    public OAuthContext(String clientSecret, Set<String> scopes) {
        this.clientSecret = clientSecret;
        this.scopes = scopes;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.clientSecret)) {
            throw new IllegalStateException("Your `OAuthContext` is missing a clientSecret.");
        }
        if (this.scopes.isEmpty()) {
            throw new IllegalStateException("Your `OAuthContext` is missing a scope.");
        }
    }

    @JsonIgnore
    public String getClientSecret() {
        return this.clientSecret;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthContext that = (OAuthContext)o;
        if (!Objects.equals(this.clientSecret, that.clientSecret)) {
            return false;
        }
        return Objects.equals(this.scopes, that.scopes);
    }

    public int hashCode() {
        int result = this.clientSecret != null ? this.clientSecret.hashCode() : 0;
        result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OAuthContext{scopes=" + this.scopes + '}';
    }

    public static class Builder {
        private String clientSecret;
        private final Set<String> scopes = new HashSet<String>();

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder addScope(String scope) {
            if (StringUtils.isBlank((CharSequence)scope)) {
                return this;
            }
            this.scopes.add(scope.trim());
            return this;
        }

        public OAuthContext build() {
            return new OAuthContext(this.clientSecret, this.scopes);
        }
    }
}

