/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.journal.model;

import com.adobe.aio.event.journal.model.Event;
import com.adobe.aio.event.journal.model.Page;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JournalEntry {
    private static final String NEXT = "next";
    private List<Event> events;
    @JsonProperty(value="_page")
    private Page page;
    @JsonIgnore
    private Map<String, String> links = new HashMap<String, String>();
    @JsonIgnore
    private int retryAfterInSeconds;

    public List<Event> getEvents() {
        return this.events;
    }

    public Page getPage() {
        return this.page;
    }

    @JsonIgnore
    public String getNextLink() {
        return this.links.get(NEXT);
    }

    @JsonIgnore
    public Map<String, String> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, String> links) {
        this.links = links;
    }

    @JsonIgnore
    public int getRetryAfterInSeconds() {
        return this.retryAfterInSeconds;
    }

    public void setRetryAfterInSeconds(String retryAfterInSeconds) {
        this.retryAfterInSeconds = Integer.valueOf(retryAfterInSeconds);
    }

    @JsonIgnore
    public int size() {
        return this.isEmpty() ? 0 : this.events.size();
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.events == null || this.events.isEmpty();
    }

    public String toString() {
        if (!this.isEmpty()) {
            return "JournalEntry{events=" + this.events + ", page=" + this.page + ", links=" + this.links + '}';
        }
        return "JournalEntry{retryAfterInSeconds=" + this.retryAfterInSeconds + ", links=" + this.links + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JournalEntry entry = (JournalEntry)o;
        return this.retryAfterInSeconds == entry.retryAfterInSeconds && Objects.equals(this.events, entry.events) && Objects.equals(this.page, entry.page) && Objects.equals(this.links, entry.links);
    }

    public int hashCode() {
        return Objects.hash(this.events, this.page, this.links, this.retryAfterInSeconds);
    }
}

