/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.management;

import com.adobe.aio.event.management.feign.FeignProviderService;
import com.adobe.aio.event.management.model.EventMetadata;
import com.adobe.aio.event.management.model.Provider;
import com.adobe.aio.event.management.model.ProviderInputModel;
import com.adobe.aio.event.management.model.SampleEvent;
import com.adobe.aio.workspace.Workspace;
import java.util.List;
import java.util.Optional;

public interface ProviderService {
    public List<Provider> getProviders();

    public Optional<Provider> findProviderById(String var1);

    public void deleteProvider(String var1);

    public Optional<Provider> createProvider(ProviderInputModel var1);

    public Optional<Provider> createOrUpdateProvider(ProviderInputModel var1);

    public Optional<Provider> updateProvider(String var1, ProviderInputModel var2);

    public Optional<Provider> findCustomEventsProviderByInstanceId(String var1);

    public Optional<Provider> findProviderBy(String var1, String var2);

    public List<EventMetadata> getEventMetadata(String var1);

    public Optional<EventMetadata> getEventMetadata(String var1, String var2);

    public Optional<EventMetadata> createEventMetadata(String var1, EventMetadata var2);

    public Optional<EventMetadata> updateEventMetadata(String var1, EventMetadata var2);

    public void deleteEventMetadata(String var1, String var2);

    public void deleteAllEventMetadata(String var1);

    public static Builder builder() {
        return new Builder();
    }

    public Optional<SampleEvent> getSampleEvent(String var1, String var2);

    public static class Builder {
        private Workspace workspace;
        private String url;

        public Builder workspace(Workspace workspace) {
            this.workspace = workspace;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public ProviderService build() {
            return new FeignProviderService(this.workspace, this.url);
        }
    }
}

