/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.management;

import com.adobe.aio.event.management.feign.FeignRegistrationService;
import com.adobe.aio.event.management.model.Registration;
import com.adobe.aio.event.management.model.RegistrationCreateModel;
import com.adobe.aio.event.management.model.RegistrationPaginatedModel;
import com.adobe.aio.event.management.model.RegistrationUpdateModel;
import com.adobe.aio.workspace.Workspace;
import java.util.List;
import java.util.Optional;

public interface RegistrationService {
    public Optional<Registration> findById(String var1);

    public void delete(String var1);

    public Optional<Registration> createOrUpdateRegistration(RegistrationCreateModel.Builder var1);

    public Optional<Registration> createRegistration(RegistrationCreateModel.Builder var1);

    public Optional<Registration> updateRegistration(String var1, RegistrationUpdateModel.Builder var2);

    public List<Registration> getRegistrationsForWorkspace();

    default public Optional<RegistrationPaginatedModel> getAllRegistrationsForOrg() {
        return this.getAllRegistrationsForOrg(0L, 10L);
    }

    public Optional<RegistrationPaginatedModel> getAllRegistrationsForOrg(long var1, long var3);

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Workspace workspace;
        private String url;

        public Builder workspace(Workspace workspace) {
            this.workspace = workspace;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public RegistrationService build() {
            return new FeignRegistrationService(this.workspace, this.url);
        }
    }
}

