/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.management.model;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DeliveryType {
    WEBHOOK("webhook", true),
    JOURNAL("journal", false),
    WEBHOOK_BATCH("webhook_batch", true);

    private final boolean isWebhookDelivery;
    private final String friendlyName;
    private static final Logger logger;
    private static final Map<String, DeliveryType> DELIVERY_TYPE_FRIENDLY_NAME_MAP;

    public static DeliveryType fromFriendlyName(String friendlyName) {
        if (!DELIVERY_TYPE_FRIENDLY_NAME_MAP.containsKey(friendlyName.toLowerCase())) {
            logger.error("`{}` is not a delivery type known to Adobe I/O Events", (Object)friendlyName);
            throw new IllegalArgumentException("Invalid delivery type code: " + friendlyName);
        }
        return DELIVERY_TYPE_FRIENDLY_NAME_MAP.get(friendlyName.toLowerCase());
    }

    public boolean isWebhookDelivery() {
        return this.isWebhookDelivery;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    private DeliveryType(String friendlyName, boolean isWebhookDelivery) {
        this.isWebhookDelivery = isWebhookDelivery;
        this.friendlyName = friendlyName;
    }

    static {
        logger = LoggerFactory.getLogger(DeliveryType.class);
        DELIVERY_TYPE_FRIENDLY_NAME_MAP = new HashMap<String, DeliveryType>();
        Stream.of(DeliveryType.values()).filter(deliveryType -> StringUtils.isNotBlank((CharSequence)deliveryType.getFriendlyName())).forEach(deliveryType -> DELIVERY_TYPE_FRIENDLY_NAME_MAP.put(deliveryType.getFriendlyName().toLowerCase(), (DeliveryType)((Object)deliveryType)));
    }
}

