/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.management.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class EventMetadata {
    @JsonProperty(value="event_code")
    private String eventCode;
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="sample_event_template")
    private String sampleEventTemplate;

    private EventMetadata() {
    }

    private EventMetadata(String eventCode, String label, String description, String sampleEventTemplate) {
        if (StringUtils.isEmpty((CharSequence)eventCode)) {
            throw new IllegalArgumentException("EventMetadata is missing an Event Code");
        }
        this.eventCode = eventCode;
        this.label = StringUtils.isEmpty((CharSequence)label) ? eventCode : label;
        this.description = description;
        this.sampleEventTemplate = sampleEventTemplate;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public String getEventCode() {
        return this.eventCode;
    }

    public String getSampleEventTemplate() {
        return this.sampleEventTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventMetadata that = (EventMetadata)o;
        return Objects.equals(this.description, that.description) && Objects.equals(this.label, that.label) && Objects.equals(this.eventCode, that.eventCode) && Objects.equals(this.sampleEventTemplate, that.sampleEventTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.label, this.eventCode, this.sampleEventTemplate);
    }

    public String toString() {
        return "EventMetadata{eventCode='" + this.eventCode + '\'' + ", label='" + this.label + '\'' + ", description='" + this.description + '\'' + '}';
    }

    @JsonIgnore
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String eventCode;
        private String label;
        private String description;
        private String sampleEventTemplate;

        public Builder eventCode(String eventCode) {
            this.eventCode = eventCode;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder sampleEventTemplate(String sampleEventTemplate) {
            this.sampleEventTemplate = sampleEventTemplate;
            return this;
        }

        public EventMetadata build() {
            return new EventMetadata(this.eventCode, this.label, this.description, this.sampleEventTemplate);
        }
    }
}

