/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.management.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class EventsOfInterestInputModel {
    @JsonProperty(value="event_code")
    String eventCode;
    @JsonProperty(value="provider_id")
    String providerId;

    private EventsOfInterestInputModel(String providerId, String eventCode) {
        if (StringUtils.isBlank((CharSequence)providerId) || StringUtils.isBlank((CharSequence)eventCode)) {
            throw new IllegalArgumentException("Invalid EventsOfInterestInputModel, neither providerId, nor eventCode can be empty/blank");
        }
        this.providerId = providerId;
        this.eventCode = eventCode;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public String getEventCode() {
        return this.eventCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsOfInterestInputModel that = (EventsOfInterestInputModel)o;
        return Objects.equals(this.eventCode, that.eventCode) && Objects.equals(this.providerId, that.providerId);
    }

    public int hashCode() {
        return Objects.hash(this.eventCode, this.providerId);
    }

    public String toString() {
        return "EventsOfInterestInputModel{eventCode='" + this.eventCode + '\'' + ", providerId='" + this.providerId + '\'' + '}';
    }

    @JsonIgnore
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String providerId;
        private String eventCode;

        public Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public Builder eventCode(String eventCode) {
            this.eventCode = eventCode;
            return this;
        }

        public EventsOfInterestInputModel build() {
            return new EventsOfInterestInputModel(this.providerId, this.eventCode);
        }
    }
}

