/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.management.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProviderInputModel {
    public static final String DELIVERY_FORMAT_ADOBE_IO = "adobe_io";
    public static final String DELIVERY_FORMAT_CLOUD_EVENTS_V1 = "cloud_events_v1";
    @JsonProperty(value="instance_id")
    private final String instanceId;
    @JsonProperty(value="provider_metadata")
    private final String providerMetadataId;
    @JsonProperty(value="event_delivery_format")
    private final String eventDeliveryFormat;
    private final String label;
    private final String description;
    @JsonProperty(value="docs_url")
    private final String docsUrl;

    private ProviderInputModel(String label, String description, String docsUrl, String instanceId, String providerMetadataId, String eventDeliveryFormat) {
        if (StringUtils.isEmpty((CharSequence)label)) {
            throw new IllegalArgumentException("ProviderUpdateModel is missing a label");
        }
        this.providerMetadataId = StringUtils.isEmpty((CharSequence)providerMetadataId) ? "3rd_party_custom_events" : providerMetadataId;
        this.label = label;
        this.description = description;
        this.docsUrl = docsUrl;
        this.instanceId = instanceId;
        this.eventDeliveryFormat = eventDeliveryFormat;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDocsUrl() {
        return this.docsUrl;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getProviderMetadataId() {
        return this.providerMetadataId;
    }

    public String getEventDeliveryFormat() {
        return this.eventDeliveryFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProviderInputModel that = (ProviderInputModel)o;
        return Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.providerMetadataId, that.providerMetadataId) && Objects.equals(this.eventDeliveryFormat, that.eventDeliveryFormat) && Objects.equals(this.label, that.label) && Objects.equals(this.description, that.description) && Objects.equals(this.docsUrl, that.docsUrl);
    }

    public int hashCode() {
        return Objects.hash(this.instanceId, this.providerMetadataId, this.label, this.description, this.docsUrl, this.eventDeliveryFormat);
    }

    public String toString() {
        return "ProviderInputModel{label='" + this.label + '\'' + ", description='" + this.description + '\'' + ", docsUrl='" + this.docsUrl + '\'' + ", providerMetadataId='" + this.providerMetadataId + '\'' + ", instanceId='" + this.instanceId + '\'' + ", eventDeliveryFormat='" + this.eventDeliveryFormat + '\'' + '}';
    }

    @JsonIgnore
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String label;
        private String description;
        private String docsUrl;
        private String instanceId;
        private String providerMetadataId;
        private String eventDeliveryFormat;

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder docsUrl(String docsUrl) {
            this.docsUrl = docsUrl;
            return this;
        }

        public Builder providerMetadataId(String providerMetadataId) {
            this.providerMetadataId = providerMetadataId;
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder eventDeliveryFormat(String eventDeliveryFormat) {
            this.eventDeliveryFormat = eventDeliveryFormat;
            return this;
        }

        public ProviderInputModel build() {
            return new ProviderInputModel(this.label, this.description, this.docsUrl, this.instanceId, this.providerMetadataId, this.eventDeliveryFormat);
        }
    }
}

