/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.management.model;

import com.adobe.aio.event.management.model.EventsOfInterestInputModel;
import com.adobe.aio.event.management.model.RegistrationUpdateModel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RegistrationCreateModel
extends RegistrationUpdateModel {
    @JsonProperty(value="client_id")
    private final String clientId;

    private RegistrationCreateModel(String clientId, String name, String description, String deliveryType, String runtimeAction, Set<EventsOfInterestInputModel> eventsOfInterestInputModels, String webhookUrl, boolean enabled) {
        super(name, description, webhookUrl, eventsOfInterestInputModels, deliveryType, runtimeAction, enabled);
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("Registration is missing a clientId");
        }
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegistrationCreateModel)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistrationCreateModel that = (RegistrationCreateModel)o;
        return Objects.equals(this.clientId, that.clientId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientId, this.name, this.description, this.deliveryType, this.runtimeAction, this.eventsOfInterestInputModels, this.webhookUrl, this.enabled);
    }

    @Override
    public String toString() {
        return "RegistrationInputModel{clientId='" + this.clientId + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", deliveryType=" + this.deliveryType + ", runtimeAction=" + this.runtimeAction + ", eventsOfInterestInputModels=" + this.eventsOfInterestInputModels + ", webhookUrl='" + this.webhookUrl + '\'' + ", enabled='" + this.enabled + '\'' + '}';
    }

    @JsonIgnore
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends RegistrationUpdateModel.Builder<Builder> {
        protected String clientId;

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        public RegistrationCreateModel build() {
            return new RegistrationCreateModel(this.clientId, this.name, this.description, this.deliveryType, this.runtimeAction, this.eventsOfInterestInputModels, this.webhookUrl, this.enabled);
        }
    }
}

