/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.event.management.model;

import com.adobe.aio.event.management.model.DeliveryType;
import com.adobe.aio.event.management.model.EventsOfInterestInputModel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RegistrationUpdateModel {
    protected String name;
    protected String description;
    @JsonProperty(value="webhook_url")
    protected String webhookUrl;
    @JsonProperty(value="events_of_interest")
    protected Set<EventsOfInterestInputModel> eventsOfInterestInputModels;
    @JsonProperty(value="delivery_type")
    protected String deliveryType;
    @JsonProperty(value="runtime_action")
    protected String runtimeAction;
    @JsonProperty(value="enabled")
    protected Boolean enabled;

    RegistrationUpdateModel(String name, String description, String webhookUrl, Set<EventsOfInterestInputModel> eventsOfInterestInputModels, String deliveryType, String runtimeAction, Boolean enabled) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Registration is missing a name");
        }
        if (StringUtils.isBlank((CharSequence)deliveryType)) {
            throw new IllegalArgumentException("Registration is missing a delivery_type");
        }
        if (DeliveryType.fromFriendlyName(deliveryType).isWebhookDelivery()) {
            if (StringUtils.isNotEmpty((CharSequence)webhookUrl) && StringUtils.isNotEmpty((CharSequence)runtimeAction)) {
                throw new IllegalArgumentException("Pick one, you cannot set both a webhook url and a Runtime Action");
            }
            if (StringUtils.isEmpty((CharSequence)webhookUrl) && StringUtils.isEmpty((CharSequence)runtimeAction)) {
                throw new IllegalArgumentException("Registration is a webhook registration, but missing a webhook url or a Runtime Action");
            }
        }
        this.name = name;
        this.description = description;
        this.webhookUrl = webhookUrl;
        this.eventsOfInterestInputModels = eventsOfInterestInputModels;
        this.deliveryType = deliveryType;
        this.runtimeAction = runtimeAction;
        this.enabled = enabled == null || enabled != false;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public Set<EventsOfInterestInputModel> getEventsOfInterests() {
        return this.eventsOfInterestInputModels;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public String getDeliveryType() {
        return this.deliveryType;
    }

    public String getRuntimeAction() {
        return this.runtimeAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegistrationUpdateModel)) {
            return false;
        }
        RegistrationUpdateModel that = (RegistrationUpdateModel)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.webhookUrl, that.webhookUrl) && Objects.equals(this.eventsOfInterestInputModels, that.eventsOfInterestInputModels) && Objects.equals(this.deliveryType, that.deliveryType) && Objects.equals(this.runtimeAction, that.runtimeAction) && Objects.equals(this.enabled, that.enabled);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.webhookUrl, this.eventsOfInterestInputModels, this.deliveryType, this.runtimeAction, this.enabled);
    }

    public String toString() {
        return "RegistrationUpdateModel{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", webhookUrl='" + this.webhookUrl + '\'' + ", eventsOfInterestInputModels=" + this.eventsOfInterestInputModels + ", deliveryType=" + this.deliveryType + ", runtimeAction=" + this.runtimeAction + ", enabled='" + this.enabled + '\'' + '}';
    }

    @JsonIgnore
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder> {
        protected String name;
        protected String description;
        protected String deliveryType;
        protected String runtimeAction;
        protected Set<EventsOfInterestInputModel> eventsOfInterestInputModels = new HashSet<EventsOfInterestInputModel>();
        protected String webhookUrl;
        protected Boolean enabled = Boolean.TRUE;

        public T name(String name) {
            this.name = name;
            return (T)this;
        }

        public T description(String description) {
            this.description = description;
            return (T)this;
        }

        public T deliveryType(String deliveryType) {
            this.deliveryType = deliveryType;
            return (T)this;
        }

        public T runtimeAction(String runtimeAction) {
            this.runtimeAction = runtimeAction;
            return (T)this;
        }

        public T addEventsOfInterests(EventsOfInterestInputModel eventsOfInterestInputModel) {
            this.eventsOfInterestInputModels.add(eventsOfInterestInputModel);
            return (T)this;
        }

        public T addEventsOfInterests(Set<EventsOfInterestInputModel> eventsOfInterestInputModel) {
            this.eventsOfInterestInputModels.addAll(eventsOfInterestInputModel);
            return (T)this;
        }

        public T webhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
            return (T)this;
        }

        public T enabled(Boolean enabled) {
            this.enabled = enabled;
            return (T)this;
        }

        public RegistrationUpdateModel build() {
            return new RegistrationUpdateModel(this.name, this.description, this.webhookUrl, this.eventsOfInterestInputModels, this.deliveryType, this.runtimeAction, this.enabled);
        }
    }
}

