/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.ims;

import com.adobe.aio.auth.JwtContext;
import com.adobe.aio.workspace.Workspace;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class JwtTokenBuilder {
    private final Map<String, Object> claims;
    private final PrivateKey privateKey;
    private static final String ISS = "iss";
    private static final String EXP = "exp";
    private static final String SUB = "sub";
    private static final String AUD = "aud";
    private static final String IAT = "iat";
    private static final String AUD_SUFFIX = "/c/";

    public JwtTokenBuilder(Workspace workspace) {
        if (!workspace.isAuthJWT()) {
            throw new IllegalStateException("AuthContext in workspace not of type `JwtContext`.");
        }
        JwtContext context = (JwtContext)workspace.getAuthContext();
        context.validate();
        this.claims = JwtTokenBuilder.getClaims(workspace, context);
        this.privateKey = context.getPrivateKey();
    }

    private static Map<String, Object> getClaims(Workspace workspace, JwtContext context) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put(ISS, workspace.getImsOrgId());
        claims.put(SUB, context.getTechnicalAccountId());
        claims.put(AUD, workspace.getImsUrl() + AUD_SUFFIX + workspace.getApiKey());
        for (String metascope : context.getMetascopes()) {
            claims.put(workspace.getImsUrl() + metascope, true);
        }
        long iat = System.currentTimeMillis() / 1000L;
        claims.put(IAT, iat);
        claims.put(EXP, iat + 180L);
        return claims;
    }

    public String build() {
        return Jwts.builder().setClaims(this.claims).signWith(SignatureAlgorithm.RS256, (Key)this.privateKey).compact();
    }
}

