/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.ims.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

public class KeyStoreUtil {
    private static final String PKCS_12 = "PKCS12";
    private static final String RSA = "RSA";

    private KeyStoreUtil() {
    }

    public static PrivateKey getPrivateKeyFromPkcs12File(String filePath, String alias, String password) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keystore = KeyStore.getInstance(PKCS_12);
        keystore.load(new FileInputStream(filePath), password.toCharArray());
        return (PrivateKey)keystore.getKey(alias, password.toCharArray());
    }

    public static PrivateKey getPrivateKeyFromEncodedPkcs8(String base64EncodedPkcs8) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return KeyStoreUtil.getPrivateKeyFromPkcs8(Base64.getDecoder().decode(base64EncodedPkcs8));
    }

    public static PrivateKey getPrivateKeyFromPkcs8File(String filePath) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        return KeyStoreUtil.getPrivateKeyFromPkcs8(Files.readAllBytes(Paths.get(filePath, new String[0])));
    }

    private static PrivateKey getPrivateKeyFromPkcs8(byte[] pkcs8) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return KeyFactory.getInstance(RSA).generatePrivate(new PKCS8EncodedKeySpec(pkcs8));
    }
}

