/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.ims.util;

import com.adobe.aio.ims.util.KeyStoreUtil;
import java.security.PrivateKey;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PrivateKeyBuilder {
    public static final String AIO_ENCODED_PKCS_8 = "aio_encoded_pkcs8";
    private Map<String, String> configMap;
    private String encodedPkcs8Key;

    public PrivateKeyBuilder encodedPkcs8Key(String encodedPkcs8Key) {
        this.encodedPkcs8Key = encodedPkcs8Key;
        return this;
    }

    public PrivateKey build() {
        if (!StringUtils.isEmpty((CharSequence)this.encodedPkcs8Key)) {
            try {
                return KeyStoreUtil.getPrivateKeyFromEncodedPkcs8(this.encodedPkcs8Key);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("AIO Invalid encoded pkcs8 Private Key configuration. " + e.getMessage(), e);
            }
        }
        return null;
    }
}

