/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.cloudevents.json.ZonedDateTimeDeserializer;
import io.cloudevents.json.ZonedDateTimeSerializer;
import io.openapitools.jackson.dataformat.hal.JacksonHALModule;
import java.time.ZonedDateTime;
import org.apache.commons.lang3.StringUtils;

public class JacksonUtil {
    public static final ObjectMapper DEFAULT_OBJECT_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).serializationInclusion(JsonInclude.Include.NON_NULL)).addModule((Module)new SimpleModule().addSerializer(ZonedDateTime.class, (JsonSerializer)new ZonedDateTimeSerializer()).addDeserializer(ZonedDateTime.class, (JsonDeserializer)new ZonedDateTimeDeserializer()))).addModule((Module)new JacksonHALModule())).addModule((Module)new Jdk8Module())).build();

    private JacksonUtil() {
    }

    public static JsonNode getJsonNode(String jsonPayload) throws JsonProcessingException {
        if (StringUtils.isEmpty((CharSequence)jsonPayload)) {
            return new ObjectMapper().createObjectNode();
        }
        if (jsonPayload.trim().startsWith("{")) {
            return new ObjectMapper().readTree(jsonPayload);
        }
        return new TextNode(jsonPayload);
    }
}

