/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.util;

import com.adobe.aio.auth.Context;
import com.adobe.aio.auth.JwtContext;
import com.adobe.aio.auth.OAuthContext;
import com.adobe.aio.ims.util.PrivateKeyBuilder;
import com.adobe.aio.util.FileUtil;
import com.adobe.aio.workspace.Workspace;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceUtil {
    public static final String API_URL = "aio_api_url";
    public static final String PUBLISH_URL = "aio_publish_url";
    public static final String DEFAULT_TEST_PROPERTIES = "workspace.secret.properties";
    private static final Logger logger = LoggerFactory.getLogger(WorkspaceUtil.class);

    private WorkspaceUtil() {
    }

    public static Workspace.Builder getSystemWorkspaceBuilder() {
        return WorkspaceUtil.getWorkspaceBuilder(WorkspaceUtil.getSystemWorkspaceConfig(DEFAULT_TEST_PROPERTIES));
    }

    public static Workspace.Builder getWorkspaceBuilder(Map<String, String> configMap) {
        Workspace.Builder builder = Workspace.builder().imsUrl(configMap.get("aio_ims_url")).imsOrgId(configMap.get("aio_ims_org_id")).apiKey(configMap.get("aio_api_key")).consumerOrgId(configMap.get("aio_consumer_org_id")).projectId(configMap.get("aio_project_id")).workspaceId(configMap.get("aio_workspace_id")).credentialId(configMap.get("aio_credential_id"));
        builder.authContext(WorkspaceUtil.getAuthContext(configMap));
        return builder;
    }

    public static boolean isOAuthConfig(Map<String, String> configMap) {
        return configMap.containsKey("aio_oauth_scopes");
    }

    public static Context getAuthContext(Map<String, String> configMap) {
        if (WorkspaceUtil.isOAuthConfig(configMap)) {
            return WorkspaceUtil.getOAuthContextBuilder(configMap).build();
        }
        return WorkspaceUtil.getJwtContextBuilder(configMap).build();
    }

    public static OAuthContext.Builder getOAuthContextBuilder(Map<String, String> configMap) {
        OAuthContext.Builder builder = new OAuthContext.Builder();
        builder.clientSecret(configMap.get("aio_client_secret"));
        if (!StringUtils.isEmpty((CharSequence)configMap.get("aio_oauth_scopes"))) {
            Arrays.stream(configMap.get("aio_oauth_scopes").split(",")).forEach(builder::addScope);
        }
        return builder;
    }

    public static JwtContext.Builder getJwtContextBuilder(Map<String, String> configMap) {
        JwtContext.Builder builder = new JwtContext.Builder().clientSecret(configMap.get("aio_client_secret")).technicalAccountId(configMap.get("aio_technical_account_id"));
        if (!StringUtils.isEmpty((CharSequence)configMap.get("aio_meta_scopes"))) {
            String[] metascopeArray;
            for (String metascope : metascopeArray = configMap.get("aio_meta_scopes").split(",")) {
                builder.addMetascope(metascope);
            }
        }
        WorkspaceUtil.getPrivateKey(configMap).ifPresent(builder::privateKey);
        return builder;
    }

    public static Optional<PrivateKey> getPrivateKey(Map<String, String> configMap) {
        String encodedPkcs8Key = configMap.get("aio_encoded_pkcs8");
        if (encodedPkcs8Key != null) {
            logger.debug("loading test JWT Private Key from JVM System Properties");
            try {
                return Optional.of(new PrivateKeyBuilder().encodedPkcs8Key(encodedPkcs8Key).build());
            }
            catch (Exception e) {
                logger.error("Error {} loading test Private Key from configMap", (Object)e.getMessage());
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static String getSystemProperty(String key) {
        return WorkspaceUtil.getSystemProperty(key, DEFAULT_TEST_PROPERTIES);
    }

    public static String getSystemProperty(String key, String propertyClassPath) {
        return WorkspaceUtil.getSystemProperties(Arrays.asList(key), propertyClassPath).get(key);
    }

    public static Map<String, String> getSystemWorkspaceConfig(String propertiesClassPath) {
        return WorkspaceUtil.getSystemProperties(Arrays.asList("aio_api_key", "aio_workspace_id", "aio_client_secret", "aio_consumer_org_id", "aio_ims_org_id", "aio_project_id"), propertiesClassPath);
    }

    private static Map<String, String> getSystemProperties(List<String> keys, String propertiesClassPath) {
        if (StringUtils.isNoneBlank((CharSequence[])((CharSequence[])keys.stream().map(System::getProperty).toArray(String[]::new)))) {
            logger.debug("loading `{}` from JVM System Properties", keys);
            return FileUtil.getMap(System.getProperties());
        }
        if (StringUtils.isNoneBlank((CharSequence[])((CharSequence[])keys.stream().map(System::getenv).toArray(String[]::new)))) {
            logger.debug("loading `{}` from Environment Variables", keys);
            return System.getenv();
        }
        if (WorkspaceUtil.class.getClassLoader().getResourceAsStream(propertiesClassPath) == null) {
            logger.error("No system configuration found for keys `{}`, no properties file either at `{}`", keys, (Object)propertiesClassPath);
            return Collections.emptyMap();
        }
        logger.debug("loading `{}` from classpath `{}`", keys, (Object)propertiesClassPath);
        Map<String, String> map = FileUtil.getMap(propertiesClassPath);
        if (StringUtils.isNoneBlank((CharSequence[])((CharSequence[])keys.stream().map(map::get).toArray(String[]::new)))) {
            return map;
        }
        logger.error("Missing configurations: keys: `{}` classpath: `{}`", keys, (Object)propertiesClassPath);
        return Collections.emptyMap();
    }
}

